/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.deployables;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.util.NullModuleArtifact;

public class EJBDeployableArtifactAdapterUtil {
    public static IModuleArtifact getModuleObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IProject) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject((IProject)obj);
        }
        if (obj instanceof IJavaProject) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject(((IJavaProject)obj).getProject());
        }
        if (obj instanceof IFile) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject((IFile)obj);
        }
        if (obj instanceof ICompilationUnit) {
            return EJBDeployableArtifactAdapterUtil.getModuleObject((ICompilationUnit)obj);
        }
        return null;
    }

    protected static boolean hasInterestedComponents(IProject project) {
        return J2EEProjectUtilities.isEJBProject((IProject)project);
    }

    protected static IModuleArtifact getModuleObject(ICompilationUnit cu) {
        try {
            IFile file = (IFile)cu.getCorrespondingResource();
            IProject project = file.getProject();
            if (EJBDeployableArtifactAdapterUtil.hasInterestedComponents(project)) {
                return EJBDeployableArtifactAdapterUtil.getModuleJavaObject(file);
            }
        }
        catch (JavaModelException e) {
            Logger.getLogger().log((Throwable)e);
        }
        return null;
    }

    protected static IModuleArtifact getModuleObject(IProject project) {
        if (EJBDeployableArtifactAdapterUtil.hasInterestedComponents(project)) {
            IModule dep = EJBDeployableArtifactAdapterUtil.getModule(project, null);
            return EJBDeployableArtifactAdapterUtil.createModuleObject(dep, null, false, false);
        }
        return null;
    }

    protected static IModuleArtifact getModuleObject(IFile file) {
        IVirtualResource[] resources = ComponentCore.createResources((IResource)file);
        IVirtualComponent component = null;
        if (resources[0] != null || resources.length <= 0) {
            component = resources[0].getComponent();
        }
        if (EJBDeployableArtifactAdapterUtil.hasInterestedComponents(file.getProject())) {
            String ext = file.getFileExtension();
            if ("java".equals(ext) || "class".equals(ext)) {
                return EJBDeployableArtifactAdapterUtil.getModuleJavaObject(file);
            }
            if (file.getProjectRelativePath().toString().endsWith("META-INF/ejb-jar.xml")) {
                return EJBDeployableArtifactAdapterUtil.createModuleObject(EJBDeployableArtifactAdapterUtil.getModule(file.getProject(), component), null, false, false);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static IModule getModule(IProject project, IVirtualComponent component) {
        IModule deployable = null;
        Iterator<IModule> iterator = Arrays.asList(ServerUtil.getModules((String)"jst.ejb")).iterator();
        String componentName = null;
        if (component == null) return EJBDeployableArtifactAdapterUtil.getModuleProject(project, iterator);
        componentName = component.getName();
        while (iterator.hasNext()) {
            IModule next = iterator.next();
            if (!(next instanceof IModule) || !(deployable = next).getName().equals(componentName)) continue;
            return deployable;
        }
        return null;
    }

    protected static IModule getModuleProject(IProject project, Iterator iterator) {
        IModule deployable = null;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof IModule) || !(deployable = (IModule)next).getProject().equals((Object)project)) continue;
            return deployable;
        }
        return null;
    }

    protected static IModuleArtifact getModuleJavaObject(IFile file) {
        IVirtualComponent comp = (IVirtualComponent)file.getAdapter(IVirtualComponent.class);
        return null;
    }

    protected static IModuleArtifact createModuleObject(IModule module, String ejbName, boolean remote, boolean local) {
        if (module != null) {
            return new NullModuleArtifact(module);
        }
        return null;
    }
}

