/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core;

import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;

public class EJBBean
extends ModuleArtifactDelegate {
    private String jndiName;
    private boolean local;
    private boolean remote;

    public EJBBean(IModule module, String jndiName, boolean remote, boolean local) {
        super(module);
        this.jndiName = jndiName;
        this.remote = remote;
        this.local = local;
    }

    public EJBBean() {
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public boolean hasRemoteInterface() {
        return this.remote;
    }

    public boolean hasLocalInterface() {
        return this.local;
    }

    public String getName() {
        return NLS.bind((String)Messages.artifactEJB, (Object)this.jndiName.toString());
    }

    public void deserialize(String s) {
        int ind = s.indexOf("//");
        super.deserialize(s.substring(0, ind));
        this.local = 'T' == s.charAt(ind + 2);
        this.remote = 'T' == s.charAt(ind + 3);
        this.jndiName = s.substring(ind + 4);
    }

    public String serialize() {
        StringBuffer sb = new StringBuffer(super.serialize());
        sb.append("//");
        if (this.local) {
            sb.append("T");
        } else {
            sb.append("F");
        }
        if (this.remote) {
            sb.append("T");
        } else {
            sb.append("F");
        }
        sb.append(this.jndiName);
        return sb.toString();
    }
}

