/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public final class PublishUtil {
    private static final int BUFFER = 65536;
    private static byte[] buf = new byte[65536];

    private PublishUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStatus copyFile(InputStream in, String to) {
        IStatus iStatus;
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(to);
                int avail = in.read(buf);
                while (true) {
                    if (avail <= 0) {
                        iStatus = Status.OK_STATUS;
                        Object var4_7 = null;
                        break;
                    }
                    ((OutputStream)out).write(buf, 0, avail);
                    avail = in.read(buf);
                }
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Error copying file", e);
                Status status = new Status(4, "org.eclipse.jst.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
                Object var4_8 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out == null) return status;
                    ((OutputStream)out).close();
                    return status;
                }
                catch (Exception exception) {}
                return status;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {}
            catch (Exception exception) {}
            if (in != null) {
                in.close();
            }
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            if (out == null) throw throwable;
            ((OutputStream)out).close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (in != null) {
            in.close();
        }
        try {}
        catch (Exception exception) {}
        if (out == null) return iStatus;
        ((OutputStream)out).close();
        return iStatus;
    }

    public static void smartCopy(IModuleResource[] resources, IPath path, IProgressMonitor monitor) throws CoreException {
        IStatus[] status = PublishUtil.publishSmart(resources, path, monitor);
        if (status != null && status.length > 0) {
            throw new CoreException(status[0]);
        }
    }

    public static void handleDelta(int kind, IPath path, IModuleResourceDelta delta) throws CoreException {
        IStatus[] status = PublishUtil.publishDelta(delta, path, null);
        if (status != null && status.length > 0) {
            throw new CoreException(status[0]);
        }
    }

    protected static void deleteFile(IPath path, IModuleFile file) {
        Trace.trace((byte)4, "Deleting: " + file.getName() + " from " + path.toString());
        IPath path2 = path.append(file.getModuleRelativePath()).append(file.getName());
        path2.toFile().delete();
    }

    public static void copy(IModuleResource[] resources, IPath path) throws CoreException {
        IStatus[] status = PublishUtil.publishFull(resources, path, null);
        if (status != null && status.length > 0) {
            throw new CoreException(status[0]);
        }
    }

    public static void createZipFile(IModuleResource[] resources, IPath zipPath) throws CoreException {
        IStatus[] status = PublishUtil.publishZip(resources, zipPath, null);
        if (status != null && status.length > 0) {
            throw new CoreException(status[0]);
        }
    }

    public static IStatus[] deleteDirectory(File dir, IProgressMonitor monitor) {
        return org.eclipse.wst.server.core.util.PublishUtil.deleteDirectory((File)dir, (IProgressMonitor)monitor);
    }

    public static IStatus[] publishSmart(IModuleResource[] resources, IPath path, IProgressMonitor monitor) {
        return org.eclipse.wst.server.core.util.PublishUtil.publishSmart((IModuleResource[])resources, (IPath)path, (IProgressMonitor)monitor);
    }

    public static IStatus[] publishDelta(IModuleResourceDelta[] delta, IPath path, IProgressMonitor monitor) {
        return org.eclipse.wst.server.core.util.PublishUtil.publishDelta((IModuleResourceDelta[])delta, (IPath)path, (IProgressMonitor)monitor);
    }

    public static IStatus[] publishDelta(IModuleResourceDelta delta, IPath path, IProgressMonitor monitor) {
        return org.eclipse.wst.server.core.util.PublishUtil.publishDelta((IModuleResourceDelta)delta, (IPath)path, (IProgressMonitor)monitor);
    }

    public static IStatus[] publishFull(IModuleResource[] resources, IPath path, IProgressMonitor monitor) {
        return org.eclipse.wst.server.core.util.PublishUtil.publishFull((IModuleResource[])resources, (IPath)path, (IProgressMonitor)monitor);
    }

    public static IStatus[] publishZip(IModuleResource[] resources, IPath path, IProgressMonitor monitor) {
        return org.eclipse.wst.server.core.util.PublishUtil.publishZip((IModuleResource[])resources, (IPath)path, (IProgressMonitor)monitor);
    }
}

