/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.operations.AddServletOperation;
import org.eclipse.jst.j2ee.internal.web.operations.INewServletClassDataModelProperties;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class NewServletClassDataModelProvider
extends NewJavaClassDataModelProvider
implements INewServletClassDataModelProperties {
    private static final String SERVLET_SUPERCLASS = "javax.servlet.http.HttpServlet";
    private static final String[] SERVLET_INTERFACES = new String[]{"javax.servlet.Servlet"};
    private static final String ANNOTATED_TEMPLATE_DEFAULT = "servletXDoclet.javajet";
    private static final String NON_ANNOTATED_TEMPLATE_DEFAULT = "servletXDocletNonAnnotated.javajet";
    private List interfaceList;
    private static boolean useAnnotations = false;

    public IDataModelOperation getDefaultOperation() {
        return new AddServletOperation(this.getDataModel());
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("IAnnotationsDataModel.useAnnotations".equals(propertyName)) {
            return !this.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS") && this.isAnnotationsSupported();
        }
        return super.isPropertyEnabled(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("NewServletClassDataModel.INIT");
        propertyNames.add("NewServletClassDataModel.DO_POST");
        propertyNames.add("NewServletClassDataModel.DESTROY");
        propertyNames.add("NewServletClassDataModel.TO_STRING");
        propertyNames.add("NewServletClassDataModel.DO_PUT");
        propertyNames.add("NewServletClassDataModel.DO_GET");
        propertyNames.add("NewServletClassDataModel.GET_SERVLET_INFO");
        propertyNames.add("NewServletClassDataModel.DO_DELETE");
        propertyNames.add("NewServletClassDataModel.IS_SERVLET_TYPE");
        propertyNames.add("NewServletClassDataModel.INIT_PARAM");
        propertyNames.add("NewServletClassDataModel.URL_MAPPINGS");
        propertyNames.add("IAnnotationsDataModel.useAnnotations");
        propertyNames.add("NewServletClassDataModel.DISPLAY_NAME");
        propertyNames.add("NewServletClassDataModel.DESCRIPTION");
        propertyNames.add("NewServletClassDataModel.NON_ANNOTATED_TEMPLATE_FILE");
        propertyNames.add("NewServletClassDataModel.TEMPLATE_FILE");
        propertyNames.add("NewServletClassDataModel.USE_EXISTING_CLASS");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("NewServletClassDataModel.DO_POST")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewServletClassDataModel.DO_GET")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewServletClassDataModel.IS_SERVLET_TYPE")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            return NewServletClassDataModelProvider.shouldDefaultAnnotations();
        }
        if (propertyName.equals("NewServletClassDataModel.DISPLAY_NAME")) {
            String className = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
            if (className.endsWith(".jsp")) {
                int index = className.lastIndexOf("/");
                className = className.substring(index + 1, className.length() - 4);
            } else {
                int index = className.lastIndexOf(".");
                className = className.substring(index + 1);
            }
            return className;
        }
        if (propertyName.equals("NewServletClassDataModel.URL_MAPPINGS")) {
            return this.getDefaultUrlMapping();
        }
        if (propertyName.equals("NewJavaClassDataModel.INTERFACES")) {
            return this.getServletInterfaces();
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return SERVLET_SUPERCLASS;
        }
        if (propertyName.equals("NewServletClassDataModel.TEMPLATE_FILE")) {
            return ANNOTATED_TEMPLATE_DEFAULT;
        }
        if (propertyName.equals("NewServletClassDataModel.NON_ANNOTATED_TEMPLATE_FILE")) {
            return NON_ANNOTATED_TEMPLATE_DEFAULT;
        }
        if (propertyName.equals("NewServletClassDataModel.USE_EXISTING_CLASS")) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object getDefaultUrlMapping() {
        ArrayList<String[]> urlMappings = null;
        String text = (String)this.getProperty("NewServletClassDataModel.DISPLAY_NAME");
        if (text != null) {
            urlMappings = new ArrayList<String[]>();
            urlMappings.add(new String[]{"/" + text});
        }
        return urlMappings;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            useAnnotations = (Boolean)propertyValue;
            if (useAnnotations && !this.isAnnotationsSupported()) {
                return true;
            }
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        }
        if (propertyName.equals("NewJavaClassDataModel.SOURCE_FOLDER")) {
            String sourceFolder = (String)propertyValue;
            int index = sourceFolder.indexOf(File.separator);
            String projectName = sourceFolder;
            if (index == 0) {
                projectName = sourceFolder.substring(1);
            }
            if ((index = projectName.indexOf(File.separator)) != -1) {
                projectName = projectName.substring(0, index);
                this.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", projectName);
            }
        }
        boolean result = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME") && !this.getDataModel().isPropertySet("NewServletClassDataModel.DISPLAY_NAME")) {
            this.getDataModel().notifyPropertyChange("NewServletClassDataModel.DISPLAY_NAME", 2);
        }
        if (propertyName.equals("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) {
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        }
        if (this.getBooleanProperty("IAnnotationsDataModel.useAnnotations") && !this.isAnnotationsSupported()) {
            this.setBooleanProperty("IAnnotationsDataModel.useAnnotations", false);
        }
        if (propertyName.equals("NewServletClassDataModel.USE_EXISTING_CLASS")) {
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
            if (((Boolean)propertyValue).booleanValue()) {
                this.setProperty("IAnnotationsDataModel.useAnnotations", Boolean.FALSE);
            }
            this.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", null);
            this.setProperty("NewJavaClassDataModel.CLASS_NAME", null);
        }
        return result;
    }

    protected boolean isAnnotationsSupported() {
        if (!this.getDataModel().isPropertySet("IArtifactEditOperationDataModelProperties.PROJECT_NAME")) {
            return true;
        }
        if (this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME").equals("")) {
            return true;
        }
        IProject project = ProjectUtilities.getProject((String)this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
        String moduleName = this.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME");
        if (project == null || moduleName == null || moduleName.equals("")) {
            return true;
        }
        int j2eeVersion = J2EEVersionUtil.convertVersionStringToInt((String)J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project));
        return j2eeVersion > 12;
    }

    public IStatus validate(String propertyName) {
        IStatus result = Status.OK_STATUS;
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS") && this.getStringProperty(propertyName).equals(SERVLET_SUPERCLASS)) {
            return WTPCommonPlugin.OK_STATUS;
        }
        if (propertyName.equals("NewServletClassDataModel.INIT_PARAM")) {
            return this.validateInitParamList((List)this.getProperty(propertyName));
        }
        if (propertyName.equals("NewServletClassDataModel.URL_MAPPINGS")) {
            return this.validateURLMappingList((List)this.getProperty(propertyName));
        }
        if (propertyName.equals("NewServletClassDataModel.DISPLAY_NAME")) {
            return this.validateDisplayName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME")) {
            if (this.getStringProperty(propertyName).length() != 0 && this.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS")) {
                return WTPCommonPlugin.OK_STATUS;
            }
            result = super.validateJavaClassName(this.getStringProperty(propertyName));
            if (result.isOK() && (result = this.validateJavaClassName(this.getStringProperty(propertyName))).isOK() && !this.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS")) {
                result = this.canCreateTypeInClasspath(this.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
            }
            return result;
        }
        return super.validate(propertyName);
    }

    private IStatus validateInitParamList(List prop) {
        boolean dup;
        if (prop != null && !prop.isEmpty() && (dup = this.hasDuplicatesInStringArrayList(prop))) {
            String msg = WebMessages.ERR_DUPLICATED_INIT_PARAMETER;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateURLMappingList(List prop) {
        if (prop != null && !prop.isEmpty()) {
            boolean dup = this.hasDuplicatesInStringArrayList(prop);
            if (dup) {
                String msg = WebMessages.ERR_DUPLICATED_URL_MAPPING;
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        } else {
            String msg = WebMessages.ERR_SERVLET_MAPPING_URL_PATTERN_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private boolean hasDuplicatesInStringArrayList(List input) {
        if (input == null) {
            return false;
        }
        int n = input.size();
        boolean dup = false;
        int i = 0;
        while (i < n) {
            String[] sArray1 = (String[])input.get(i);
            int j = i + 1;
            while (j < n) {
                String[] sArray2 = (String[])input.get(j);
                if (this.isTwoStringArraysEqual(sArray1, sArray2)) {
                    dup = true;
                    break;
                }
                ++j;
            }
            if (dup) break;
            ++i;
        }
        return dup;
    }

    private boolean isTwoStringArraysEqual(String[] sArray1, String[] sArray2) {
        if (sArray1 == null || sArray2 == null) {
            return false;
        }
        int n1 = sArray1.length;
        int n2 = sArray1.length;
        if (n1 == 0 || n2 == 0) {
            return false;
        }
        if (n1 != n2) {
            return false;
        }
        return sArray1[0].equals(sArray2[0]);
    }

    private List getServletInterfaces() {
        if (this.interfaceList == null) {
            this.interfaceList = new ArrayList();
            int i = 0;
            while (i < SERVLET_INTERFACES.length) {
                this.interfaceList.add(SERVLET_INTERFACES[i]);
                ++i;
            }
        }
        return this.interfaceList;
    }

    private IStatus validateDisplayName(String prop) {
        if (prop == null || prop.trim().length() == 0) {
            String msg = WebMessages.ERR_DISPLAY_NAME_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (this.getTargetProject() == null || this.getTargetComponent() == null) {
            return WTPCommonPlugin.OK_STATUS;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.getTargetProject());
        Object mObj = provider.getModelObject();
        if (mObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)mObj;
            EList servlets = webApp.getServlets();
            boolean exists = false;
            if (servlets != null && !servlets.isEmpty()) {
                int i = 0;
                while (i < servlets.size()) {
                    String name = ((Servlet)servlets.get(i)).getServletName();
                    if (prop.equals(name)) {
                        exists = true;
                    }
                    ++i;
                }
            }
            if (exists) {
                String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_DISPLAY_NAME_EXIST, new String[]{prop});
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        } else if (mObj instanceof WebApp) {
            WebApp webApp = (WebApp)mObj;
            List servlets = webApp.getServlets();
            boolean exists = false;
            if (servlets != null && !servlets.isEmpty()) {
                int i = 0;
                while (i < servlets.size()) {
                    String name = ((org.eclipse.jst.javaee.web.Servlet)servlets.get(i)).getServletName();
                    if (prop.equals(name)) {
                        exists = true;
                    }
                    ++i;
                }
            }
            if (exists) {
                String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_DISPLAY_NAME_EXIST, new String[]{prop});
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private static Boolean shouldDefaultAnnotations() {
        if (useAnnotations) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

