/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.common.project.facet.core.IActionConfig;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.IDecorationsProvider;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.common.project.facet.ui.internal.AbstractDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.ChangeTargetedRuntimesDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.ConstraintDisplayDialog;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.ModifyFacetedProjectDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.RuntimesPanel;
import org.eclipse.wst.common.project.facet.ui.internal.SavePresetDialog;
import org.eclipse.wst.common.project.facet.ui.internal.util.BasicToolTip;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;
import org.eclipse.wst.common.project.facet.ui.internal.util.HeaderToolTip;
import org.eclipse.wst.common.project.facet.ui.internal.util.SwtUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetsSelectionPanel
extends Composite
implements ISelectionProvider {
    private static final String FACET_COLUMN = "facet";
    private static final String VERSION_COLUMN = "version";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String CW_FACET = "cw.facet";
    private static final String CW_VERSION = "cw.version";
    private static final String SASH1W1 = "sash.1.weight.1";
    private static final String SASH1W2 = "sash.1.weight.2";
    private static final String SASH2W1 = "sash.2.weight.1";
    private static final String SASH2W2 = "sash.2.weight.2";
    private static final String IMG_ERROR = "##error##";
    private static final String IMG_WARNING = "##warning##";
    private static final String IMG_DOWN_ARROW = "##down-arrow##";
    private final IDialogSettings settings;
    private final Composite topComposite;
    private final SashForm sform1;
    private final SashForm sform2;
    private final Label presetsLabel;
    private final Combo presetsCombo;
    private final Button savePresetButton;
    private final Button deletePresetButton;
    private final CheckboxTreeViewer treeViewer;
    private final Tree tree;
    private final TreeColumn colFacet;
    private final TreeColumn colVersion;
    private final Menu popupMenu;
    private final MenuItem popupMenuConstraints;
    private final ComboBoxCellEditor ceditor;
    private final FixedFacetToolTip fixedFacetToolTip;
    private final TableViewer problemsView;
    private final RuntimesPanel runtimesPanel;
    private final Button showHideRuntimesButton;
    private final IWizardContext context;
    private final List<TableRowData> data;
    private final Set<IProjectFacetVersion> base;
    private final Set<IFacetedProject.Action> actions;
    private Object oldSelection;
    private IStatus problems;
    private final List<Listener> listeners;
    private final List<ISelectionChangedListener> selectionListeners;
    private final ModifyFacetedProjectDataModel model;
    private final ImageRegistry imageRegistry;

    public FacetsSelectionPanel(Composite parent, int style, IWizardContext context, Set<IProjectFacetVersion> base, ModifyFacetedProjectDataModel model) {
        super(parent, style);
        this.context = context;
        this.data = new ArrayList<TableRowData>();
        this.model = model;
        this.base = base == null ? new HashSet() : base;
        this.actions = new HashSet<IFacetedProject.Action>();
        this.oldSelection = null;
        this.problems = Status.OK_STATUS;
        this.listeners = new ArrayList<Listener>();
        this.selectionListeners = new ArrayList<ISelectionChangedListener>();
        for (IProjectFacet f : ProjectFacetsManager.getProjectFacets()) {
            try {
                this.data.add(new TableRowData(f));
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }
        this.imageRegistry = new ImageRegistry();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.project.facet.ui");
        URL url = bundle.getEntry("images/error.gif");
        this.imageRegistry.put(IMG_ERROR, ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("images/warning.gif");
        this.imageRegistry.put(IMG_WARNING, ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("images/down-arrow.gif");
        this.imageRegistry.put(IMG_DOWN_ARROW, ImageDescriptor.createFromURL((URL)url));
        IDialogSettings root = FacetUiPlugin.getInstance().getDialogSettings();
        IDialogSettings temp = root.getSection(((Object)((Object)this)).getClass().getName());
        if (temp == null) {
            temp = root.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        if (temp.get(WIDTH) == null) {
            temp.put(WIDTH, 600);
        }
        if (temp.get(HEIGHT) == null) {
            temp.put(HEIGHT, 300);
        }
        if (temp.get(SASH1W1) == null) {
            temp.put(SASH1W1, 60);
        }
        if (temp.get(SASH1W2) == null) {
            temp.put(SASH1W2, 40);
        }
        if (temp.get(SASH2W1) == null) {
            temp.put(SASH2W1, 70);
        }
        if (temp.get(SASH2W2) == null) {
            temp.put(SASH2W2, 30);
        }
        this.settings = temp;
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        GridData topgd = GridLayoutUtil.gdfill();
        topgd.heightHint = this.settings.getInt(HEIGHT);
        topgd.widthHint = this.settings.getInt(WIDTH);
        this.topComposite = new Composite((Composite)this, 0);
        this.topComposite.setLayout((Layout)new GridLayout(4, false));
        this.topComposite.setLayoutData((Object)topgd);
        this.topComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point size = FacetsSelectionPanel.this.topComposite.getSize();
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.WIDTH, size.x);
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.HEIGHT, size.y);
            }
        });
        this.presetsLabel = new Label(this.topComposite, 0);
        this.presetsLabel.setText(Resources.presetsLabel);
        this.presetsCombo = new Combo(this.topComposite, 8);
        this.presetsCombo.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.syncWithPresetsModel(this.presetsCombo);
        this.savePresetButton = new Button(this.topComposite, 8);
        this.savePresetButton.setText(Resources.saveButtonLabel);
        this.savePresetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleSavePreset();
            }
        });
        this.deletePresetButton = new Button(this.topComposite, 8);
        this.deletePresetButton.setText(Resources.deleteButtonLabel);
        this.deletePresetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleDeletePreset();
            }
        });
        int width = Math.max(SwtUtil.getPreferredWidth((Control)this.savePresetButton), SwtUtil.getPreferredWidth((Control)this.deletePresetButton)) + 15;
        this.savePresetButton.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gd(), width));
        this.deletePresetButton.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gd(), width));
        this.sform1 = new SashForm(this.topComposite, 65792);
        this.sform1.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdfill(), 4));
        this.sform2 = new SashForm((Composite)this.sform1, 66048);
        this.sform2.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdfill(), 4));
        this.treeViewer = new CheckboxTreeViewer((Composite)this.sform2, 2048);
        this.tree = this.treeViewer.getTree();
        this.tree.setHeaderVisible(true);
        this.ceditor = new ComboBoxCellEditor((Composite)this.tree, new String[0], 8);
        this.treeViewer.setColumnProperties(new String[]{FACET_COLUMN, VERSION_COLUMN});
        this.treeViewer.setCellModifier((ICellModifier)new CellModifier());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.ceditor;
        this.treeViewer.setCellEditors(cellEditorArray);
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.treeViewer.setSorter((ViewerSorter)new Sorter());
        this.colFacet = new TreeColumn(this.tree, 0);
        this.colFacet.setText(Resources.facetColumnLabel);
        this.colFacet.setResizable(true);
        if (this.settings.get(CW_FACET) == null) {
            this.settings.put(CW_FACET, this.computeDefaultFacetColumnWidth());
        }
        this.colFacet.setWidth(this.settings.getInt(CW_FACET));
        this.colFacet.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.CW_FACET, FacetsSelectionPanel.this.colFacet.getWidth());
            }
        });
        this.colVersion = new TreeColumn(this.tree, 0);
        this.colVersion.setText(Resources.versionColumnLabel);
        this.colVersion.setResizable(true);
        if (this.settings.get(CW_VERSION) == null) {
            this.settings.put(CW_VERSION, this.computeDefaultVersionColumnWidth());
        }
        this.colVersion.setWidth(this.settings.getInt(CW_VERSION));
        this.colVersion.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.CW_VERSION, FacetsSelectionPanel.this.colVersion.getWidth());
            }
        });
        this.popupMenu = new Menu((Decorations)this.getShell(), 8);
        this.popupMenuConstraints = new MenuItem(this.popupMenu, 8);
        this.popupMenuConstraints.setText(Resources.showConstraints);
        this.popupMenuConstraints.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleShowConstraints();
            }
        });
        new FacetToolTip((Control)this.tree);
        new CategoryToolTip((Control)this.tree);
        this.fixedFacetToolTip = new FixedFacetToolTip((Control)this.tree);
        this.treeViewer.setInput(new Object());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                FacetsSelectionPanel.this.selectionChanged(e);
            }
        });
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                FacetsSelectionPanel.this.checkStateChanged(e);
            }
        });
        this.tree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.handleMouseDownEvent(event);
            }
        });
        this.tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.handlePaintItemEvent(event);
            }
        });
        this.problemsView = new TableViewer((Composite)this.sform2, 2048);
        this.problemsView.setContentProvider((IContentProvider)new ProblemsContentProvider());
        this.problemsView.setLabelProvider((IBaseLabelProvider)new ProblemsLabelProvider());
        this.problemsView.setInput(new Object());
        this.problemsView.getTable().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int[] weights = FacetsSelectionPanel.this.sform2.getWeights();
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH2W1, weights[0]);
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH2W2, weights[1]);
            }
        });
        int[] weights2 = new int[]{this.settings.getInt(SASH2W1), this.settings.getInt(SASH2W2)};
        this.sform2.setWeights(weights2);
        this.runtimesPanel = new RuntimesPanel((Composite)this.sform1, 0, this.model.getTargetedRuntimesDataModel());
        this.runtimesPanel.setLayoutData(GridLayoutUtil.gdhhint(GridLayoutUtil.gdhfill(), 80));
        this.model.getTargetedRuntimesDataModel().addRuntimeFilter(new ChangeTargetedRuntimesDataModel.IRuntimeFilter(){

            public boolean check(IRuntime runtime) {
                IFacetedProject project = FacetsSelectionPanel.this.getDataModel().getFacetedProject();
                if (project != null && project.getTargetedRuntimes().contains(runtime)) {
                    return true;
                }
                for (IProjectFacetVersion fv : FacetsSelectionPanel.this.getSelectedProjectFacets()) {
                    if (runtime.supports(fv)) continue;
                    return false;
                }
                return true;
            }
        });
        this.addProjectFacetsListener(new Listener(){

            public void handleEvent(Event event) {
                ChangeTargetedRuntimesDataModel rdm = FacetsSelectionPanel.this.getDataModel().getTargetedRuntimesDataModel();
                rdm.refreshTargetableRuntimes();
            }
        });
        this.runtimesPanel.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int[] weights = FacetsSelectionPanel.this.sform1.getWeights();
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH1W1, weights[0]);
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH1W2, weights[1]);
            }
        });
        int[] weights1 = new int[]{this.settings.getInt(SASH1W1), this.settings.getInt(SASH1W2)};
        this.sform1.setWeights(weights1);
        this.sform1.setMaximizedControl((Control)this.sform2);
        this.showHideRuntimesButton = new Button(this.topComposite, 8);
        this.showHideRuntimesButton.setText(Resources.showRuntimes);
        GridData gd = GridLayoutUtil.gdhalign(GridLayoutUtil.gdhspan(GridLayoutUtil.gd(), 4), 3);
        gd = GridLayoutUtil.gdwhint(gd, SwtUtil.getPreferredWidth((Control)this.showHideRuntimesButton) + 15);
        this.showHideRuntimesButton.setLayoutData((Object)gd);
        this.showHideRuntimesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleShowHideRuntimes();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FacetsSelectionPanel.this.handleDisposeEvent();
            }
        });
        this.updateValidationDisplay();
        Dialog.applyDialogFont((Control)parent);
        this.model.addListener(ModifyFacetedProjectDataModel.EVENT_FIXED_FACETS_CHANGED, new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                FacetsSelectionPanel.this.handleModelChangedEvent(ModifyFacetedProjectDataModel.EVENT_FIXED_FACETS_CHANGED);
            }
        });
        this.model.addListener(ModifyFacetedProjectDataModel.EVENT_SELECTED_PRESET_CHANGED, new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                FacetsSelectionPanel.this.handleModelChangedEvent(ModifyFacetedProjectDataModel.EVENT_SELECTED_PRESET_CHANGED);
            }
        });
        this.syncWithPresetsModel(this.presetsCombo);
        this.model.getTargetedRuntimesDataModel().addListener("targetedRuntimesChanged", new AbstractDataModel.IDataModelListener(){

            public void handleEvent() {
                FacetsSelectionPanel.this.handleModelChangedEvent("targetedRuntimesChanged");
            }
        });
    }

    public ModifyFacetedProjectDataModel getDataModel() {
        return this.model;
    }

    public boolean isSelectionValid() {
        return this.problems.getSeverity() != 4;
    }

    public Set<IFacetedProject.Action> getActions() {
        return this.actions;
    }

    public IFacetedProject.Action getAction(IFacetedProject.Action.Type type, IProjectFacetVersion f) {
        return FacetsSelectionPanel.getAction(this.actions, type, f);
    }

    private static IFacetedProject.Action getAction(Set<IFacetedProject.Action> actions, IFacetedProject.Action.Type type, IProjectFacetVersion fv) {
        for (IFacetedProject.Action action : actions) {
            if (action.getType() != type || action.getProjectFacetVersion() != fv) continue;
            return action;
        }
        return null;
    }

    private static IFacetedProject.Action getAction(Set<IFacetedProject.Action> actions, IFacetedProject.Action.Type type, IProjectFacet f) {
        for (IFacetedProject.Action action : actions) {
            if (action.getType() != type || action.getProjectFacetVersion().getProjectFacet() != f) continue;
            return action;
        }
        return null;
    }

    private IFacetedProject.Action createAction(Set<IFacetedProject.Action> actions, IFacetedProject.Action.Type type, IProjectFacetVersion fv) {
        IFacetedProject.Action action = FacetsSelectionPanel.getAction(actions, type, fv);
        if (action == null) {
            Object config = null;
            if (fv.supports(this.base, type)) {
                try {
                    IProjectFacet f = fv.getProjectFacet();
                    action = FacetsSelectionPanel.getAction(actions, type, f);
                    if (action != null) {
                        IProjectFacetVersion current = action.getProjectFacetVersion();
                        if (fv.supports(this.base, type) && current.supports(this.base, type) && fv.getActionDefinition(this.base, type) == current.getActionDefinition(this.base, type)) {
                            config = action.getConfig();
                            IActionConfig c = null;
                            if (config instanceof IActionConfig) {
                                c = (IActionConfig)config;
                            } else if (config != null) {
                                IAdapterManager m = Platform.getAdapterManager();
                                String t = IActionConfig.class.getName();
                                c = (IActionConfig)m.loadAdapter(config, t);
                            }
                            if (c != null) {
                                c.setVersion(fv);
                            }
                        }
                    }
                    if (config == null) {
                        String pjname = this.context.getProjectName();
                        config = this.context.getConfig(fv, type, pjname);
                    }
                }
                catch (CoreException e) {
                    FacetUiPlugin.log((Exception)((Object)e));
                }
            }
            action = new IFacetedProject.Action(type, fv, config);
        }
        return action;
    }

    public void setDefaultFacetsForRuntime(IRuntime runtime) {
        HashSet<IProjectFacetVersion> defaultFacets;
        if (runtime != null) {
            try {
                defaultFacets = runtime.getDefaultFacets(this.model.getFixedFacets());
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
                return;
            }
        } else {
            defaultFacets = new HashSet();
            for (IProjectFacet f : this.model.getFixedFacets()) {
                defaultFacets.add(f.getDefaultVersion());
            }
        }
        this.setSelectedProjectFacets(defaultFacets);
        this.model.setSelectedPreset(null);
    }

    public Set<IProjectFacetVersion> getSelectedProjectFacets() {
        HashSet<IProjectFacetVersion> set = new HashSet<IProjectFacetVersion>();
        for (TableRowData trd : this.data) {
            if (!trd.isSelected()) continue;
            set.add(trd.getCurrentVersion());
        }
        return set;
    }

    public void setSelectedProjectFacets(Set<IProjectFacetVersion> sel) {
        ArrayList<TableRowData> toCheck = new ArrayList<TableRowData>();
        ArrayList<TableRowData> needsCategoryRefresh = new ArrayList<TableRowData>();
        for (IProjectFacetVersion fv : sel) {
            IProjectFacet f = fv.getProjectFacet();
            TableRowData trd = this.findTableRowData(f, true);
            if (fv.getPluginId() == null) {
                trd.addUnknownVersion(fv);
            }
            trd.setSelected(true);
            trd.setCurrentVersion(fv);
            toCheck.add(trd);
            needsCategoryRefresh.add(trd);
        }
        for (TableRowData trd : this.data) {
            if (!trd.isSelected() || sel.contains(trd.getCurrentVersion())) continue;
            trd.setSelected(false);
            needsCategoryRefresh.add(trd);
        }
        this.refresh();
        this.treeViewer.setCheckedElements(toCheck.toArray());
        for (TableRowData trd : needsCategoryRefresh) {
            this.refreshCategoryState(trd);
        }
        this.updateValidationDisplay();
    }

    public void setFixedProjectFacets(Set<IProjectFacet> fixed) {
        this.model.setFixedFacets(fixed);
    }

    public void selectPreset(IPreset preset) {
        this.model.setSelectedPreset(preset.getId());
    }

    public boolean setFocus() {
        return this.tree.setFocus();
    }

    public void addProjectFacetsListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeProjectFacetsListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyProjectFacetsListeners() {
        for (Listener listener : this.listeners) {
            listener.handleEvent(null);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public ISelection getSelection() {
        IStructuredSelection ss = (IStructuredSelection)this.treeViewer.getSelection();
        Object sel = ss.getFirstElement();
        if (sel instanceof TableRowData) {
            sel = ((TableRowData)sel).getProjectFacet();
        }
        if (sel == null) {
            return new StructuredSelection(new Object[0]);
        }
        return new StructuredSelection(sel);
    }

    public void setSelection(ISelection selection) {
        ISelection ts;
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object sel = ss.getFirstElement();
        if (sel == null) {
            ts = new StructuredSelection(new Object[0]);
        } else if (sel instanceof IProjectFacet) {
            TableRowData trd = this.findTableRowData((IProjectFacet)sel);
            ts = new StructuredSelection((Object)trd);
        } else {
            ts = selection;
        }
        this.treeViewer.setSelection(ts);
    }

    public void notifySelectionChangedListeners() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
    }

    private ImageRegistry getImageRegistry() {
        return this.imageRegistry;
    }

    private void selectionChanged(SelectionChangedEvent event) {
        Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (selection != this.oldSelection) {
            this.oldSelection = selection;
            this.refreshVersionsDropDown();
            this.notifySelectionChangedListeners();
        }
    }

    private void checkStateChanged(CheckStateChangedEvent event) {
        Object el = event.getElement();
        boolean checked = event.getChecked();
        if (el instanceof TableRowData) {
            TableRowData trd = (TableRowData)el;
            if (trd.isFixed()) {
                if (!checked) {
                    this.treeViewer.setChecked(el, true);
                    String msg = NLS.bind((String)Resources.couldNotDeselectFixedFacetMessage, (Object)trd.getProjectFacet().getLabel());
                    this.fixedFacetToolTip.setMessage(msg);
                    Point cursorLocation = this.getDisplay().getCursorLocation();
                    this.fixedFacetToolTip.show(this.tree.toControl(cursorLocation));
                }
                return;
            }
            trd.setSelected(checked);
            this.refreshCategoryState(trd);
        } else {
            ContentProvider cp = (ContentProvider)this.treeViewer.getContentProvider();
            Object[] children = cp.getChildren(el);
            int selected = 0;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                TableRowData trd = (TableRowData)child;
                if (!trd.isFixed()) {
                    trd.setSelected(checked);
                    this.treeViewer.setChecked((Object)trd, checked);
                }
                if (trd.isSelected()) {
                    ++selected;
                }
                ++n2;
            }
            if (selected == 0 || selected == children.length) {
                this.treeViewer.setGrayed(el, false);
            } else {
                this.treeViewer.setGrayChecked(el, true);
            }
        }
        this.updateValidationDisplay();
        this.model.setSelectedPreset(null);
    }

    private void updateValidationDisplay() {
        Set<IProjectFacetVersion> sel = this.getSelectedProjectFacets();
        HashSet<IFacetedProject.Action> old = new HashSet<IFacetedProject.Action>(this.actions);
        this.actions.clear();
        for (IProjectFacetVersion fv : this.base) {
            if (sel.contains(fv)) continue;
            this.actions.add(this.createAction(old, IFacetedProject.Action.Type.UNINSTALL, fv));
        }
        for (IProjectFacetVersion fv : sel) {
            if (this.base.contains(fv)) continue;
            this.actions.add(this.createAction(old, IFacetedProject.Action.Type.INSTALL, fv));
        }
        HashSet<IFacetedProject.Action> toadd = new HashSet<IFacetedProject.Action>();
        HashSet<IFacetedProject.Action> toremove = new HashSet<IFacetedProject.Action>();
        for (IFacetedProject.Action action1 : this.actions) {
            for (IFacetedProject.Action action2 : this.actions) {
                if (action1.getType() != IFacetedProject.Action.Type.UNINSTALL || action2.getType() != IFacetedProject.Action.Type.INSTALL) continue;
                IProjectFacetVersion f1 = action1.getProjectFacetVersion();
                IProjectFacetVersion f2 = action2.getProjectFacetVersion();
                if (f1.getProjectFacet() != f2.getProjectFacet()) continue;
                toremove.add(action1);
                toremove.add(action2);
                toadd.add(this.createAction(old, IFacetedProject.Action.Type.VERSION_CHANGE, f2));
            }
        }
        this.actions.removeAll(toremove);
        this.actions.addAll(toadd);
        this.problems = this.calculateProblems();
        this.problemsView.refresh();
        if (this.problems.isOK()) {
            if (this.sform2.getMaximizedControl() == null) {
                this.sform2.setMaximizedControl((Control)this.tree);
            }
        } else if (this.sform2.getMaximizedControl() != null) {
            this.sform2.setMaximizedControl(null);
        }
        this.notifyProjectFacetsListeners();
    }

    private IStatus calculateProblems() {
        MultiStatus st = (MultiStatus)ProjectFacetsManager.check(this.base, this.actions);
        for (IProjectFacetVersion fv : this.base) {
            IProjectFacet f = fv.getProjectFacet();
            String msg = null;
            if (f.getPluginId() == null) {
                msg = NLS.bind((String)Resources.facetNotFound, (Object)f.getId());
            } else if (fv.getPluginId() == null) {
                msg = NLS.bind((String)Resources.facetVersionNotFound, (Object)f.getId(), (Object)fv.getVersionString());
            }
            if (msg == null) continue;
            Status sub = new Status(2, "org.eclipse.wst.common.project.facet.ui", 0, msg, null);
            st.add((IStatus)sub);
        }
        for (IRuntime r : this.getDataModel().getTargetedRuntimesDataModel().getTargetedRuntimes()) {
            for (IProjectFacetVersion fv : this.getSelectedProjectFacets()) {
                if (r.supports(fv)) continue;
                String msg = NLS.bind((String)Resources.facetNotSupportedByTarget, (Object)fv.toString(), (Object)r.getLocalizedName());
                Status sub = new Status(4, "org.eclipse.wst.common.project.facet.ui", 0, msg, null);
                st.add((IStatus)sub);
            }
        }
        return st;
    }

    private void refresh() {
        Object[] checked = this.treeViewer.getCheckedElements();
        this.treeViewer.refresh();
        this.treeViewer.setCheckedElements(checked);
        this.refreshVersionsDropDown();
    }

    public void setCategoryExpandedState(ICategory category, boolean expanded) {
        this.treeViewer.setExpandedState((Object)category, expanded);
    }

    public void syncWithPresetsModel(final Combo combo) {
        final ArrayList sortedPresets = new ArrayList();
        AbstractDataModel.IDataModelListener modelToViewContentsListener = new AbstractDataModel.IDataModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent() {
                List list = sortedPresets;
                synchronized (list) {
                    sortedPresets.clear();
                    sortedPresets.addAll(FacetsSelectionPanel.this.model.getAvailablePresets());
                    Collections.sort(sortedPresets, new Comparator<IPreset>(){

                        @Override
                        public int compare(IPreset p1, IPreset p2) {
                            if (p1 == p2) {
                                return 0;
                            }
                            return p1.getLabel().compareTo(p2.getLabel());
                        }
                    });
                    IPreset selectedPreset = FacetsSelectionPanel.this.model.getSelectedPreset();
                    combo.removeAll();
                    combo.add(Resources.customPreset);
                    if (selectedPreset == null) {
                        combo.select(0);
                    }
                    for (IPreset preset : sortedPresets) {
                        combo.add(preset.getLabel());
                        if (preset != selectedPreset) continue;
                        combo.select(combo.getItemCount() - 1);
                    }
                }
            }
        };
        this.model.addListener(ModifyFacetedProjectDataModel.EVENT_AVAILABLE_PRESETS_CHANGED, modelToViewContentsListener);
        this.model.addListener(ModifyFacetedProjectDataModel.EVENT_SELECTED_PRESET_CHANGED, new AbstractDataModel.IDataModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent() {
                List list = sortedPresets;
                synchronized (list) {
                    IPreset preset = FacetsSelectionPanel.this.model.getSelectedPreset();
                    int index = preset == null ? -1 : sortedPresets.indexOf(preset);
                    combo.select(index + 1);
                    FacetsSelectionPanel.this.handlePresetSelected();
                }
            }
        });
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent e) {
                List list = sortedPresets;
                synchronized (list) {
                    int selection = combo.getSelectionIndex();
                    String presetId = selection == 0 ? null : ((IPreset)sortedPresets.get(selection - 1)).getId();
                    FacetsSelectionPanel.this.model.setSelectedPreset(presetId);
                }
            }
        });
        modelToViewContentsListener.handleEvent();
    }

    private void refreshCategoryState(TableRowData trd) {
        ICategory category = trd.getProjectFacet().getCategory();
        if (category != null) {
            int selected = 0;
            for (IProjectFacet f : category.getProjectFacets()) {
                TableRowData ctrd = this.findTableRowData(f);
                if (!ctrd.isSelected()) continue;
                ++selected;
            }
            if (selected == 0) {
                this.treeViewer.setChecked((Object)category, false);
                this.treeViewer.setGrayed((Object)category, false);
            } else if (selected == category.getProjectFacets().size()) {
                this.treeViewer.setChecked((Object)category, true);
                this.treeViewer.setGrayed((Object)category, false);
            } else {
                this.treeViewer.setGrayChecked((Object)category, true);
            }
        }
    }

    private void refreshVersionsDropDown() {
        TableRowData trd = this.getSelectedTableRowData();
        if (trd == null) {
            return;
        }
        List<IProjectFacetVersion> versions = trd.getVersions();
        String[] verstrs = new String[versions.size()];
        int i = 0;
        int n = versions.size();
        while (i < n) {
            IProjectFacetVersion fv = versions.get(i);
            verstrs[i] = fv.getVersionString();
            ++i;
        }
        this.ceditor.setItems(verstrs);
        i = 0;
        n = versions.size();
        while (i < n) {
            if (versions.get(i) == trd.getCurrentVersion()) {
                this.ceditor.setValue((Object)new Integer(i));
                break;
            }
            ++i;
        }
    }

    private TableRowData getSelectedTableRowData() {
        Object obj;
        IStructuredSelection ssel = (IStructuredSelection)this.treeViewer.getSelection();
        if (ssel != null && !ssel.isEmpty() && (obj = ssel.getFirstElement()) instanceof TableRowData) {
            return (TableRowData)obj;
        }
        return null;
    }

    private TableRowData findTableRowData(IProjectFacet f) {
        return this.findTableRowData(f, false);
    }

    private TableRowData findTableRowData(IProjectFacet f, boolean createIfNecessary) {
        for (TableRowData trd : this.data) {
            if (trd.getProjectFacet() != f) continue;
            return trd;
        }
        if (createIfNecessary) {
            try {
                TableRowData trd;
                trd = new TableRowData(f);
                this.data.add(trd);
                return trd;
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }
        throw new IllegalStateException();
    }

    private void handleMouseDownEvent(Event event) {
        List<TreeItem> items = this.getAllTreeItems();
        TreeItem onItem = null;
        for (TreeItem item : items) {
            if (item.getBounds(0).contains(event.x, event.y)) {
                onItem = item;
                break;
            }
            if (!item.getBounds(1).contains(event.x, event.y)) continue;
            this.tree.setSelection(new TreeItem[]{item});
            this.treeViewer.editElement(item.getData(), 1);
            break;
        }
        if (onItem != null && onItem.getData() instanceof TableRowData) {
            TableRowData trd = (TableRowData)onItem.getData();
            IProjectFacetVersion fv = trd.getCurrentVersion();
            IConstraint c = fv.getConstraint();
            if (c.getType() == IConstraint.Type.AND && c.getOperands().size() == 0) {
                this.popupMenuConstraints.setEnabled(false);
            } else {
                this.popupMenuConstraints.setEnabled(true);
            }
            this.tree.setMenu(this.popupMenu);
        } else {
            this.tree.setMenu(null);
        }
    }

    private void handlePaintItemEvent(Event event) {
        TableRowData trd;
        TreeItem item = (TreeItem)event.item;
        Object itemData = item.getData();
        if (itemData instanceof TableRowData && event.index == 1 && (trd = (TableRowData)itemData).getVersions().size() > 1) {
            Image arrowImage = this.getImageRegistry().get(IMG_DOWN_ARROW);
            Rectangle arrowImageBounds = arrowImage.getBounds();
            int columnWidth = this.colVersion.getWidth();
            int itemHeight = this.tree.getItemHeight();
            int x = event.x + columnWidth - arrowImageBounds.width - 10;
            int y = event.y;
            event.gc.setBackground(item.getDisplay().getSystemColor(1));
            event.gc.fillRectangle(x, y, arrowImageBounds.width + 10, itemHeight);
            y = event.y + (itemHeight - arrowImageBounds.height) / 2;
            event.gc.drawImage(arrowImage, x, y);
        }
    }

    private void handleDisposeEvent() {
        this.imageRegistry.dispose();
    }

    private void handleShowConstraints() {
        TreeItem[] items = this.tree.getSelection();
        if (items.length != 1) {
            throw new IllegalStateException();
        }
        TreeItem item = items[0];
        TableRowData trd = (TableRowData)item.getData();
        IProjectFacetVersion fv = trd.getCurrentVersion();
        Rectangle bounds = item.getBounds();
        Point location = new Point(bounds.x, bounds.y + bounds.height);
        location = this.tree.toDisplay(location);
        ConstraintDisplayDialog dialog = new ConstraintDisplayDialog(this.getShell(), location, fv.getConstraint());
        dialog.open();
    }

    private void handlePresetSelected() {
        IPreset preset = this.model.getSelectedPreset();
        if (preset != null) {
            HashSet<TableRowData> selected = new HashSet<TableRowData>();
            for (IProjectFacetVersion fv : preset.getProjectFacets()) {
                TableRowData trd = this.findTableRowData(fv.getProjectFacet());
                if (!trd.isSelected()) {
                    this.treeViewer.setChecked((Object)trd, true);
                    trd.setSelected(true);
                    this.refreshCategoryState(trd);
                }
                if (trd.getCurrentVersion() != fv) {
                    trd.setCurrentVersion(fv);
                    this.treeViewer.update((Object)trd, null);
                }
                selected.add(trd);
            }
            for (TableRowData trd : this.data) {
                if (selected.contains(trd)) continue;
                this.treeViewer.setChecked((Object)trd, false);
                trd.setSelected(false);
                this.refreshCategoryState(trd);
            }
            this.updateValidationDisplay();
        }
    }

    private void handleSavePreset() {
        Set<IProjectFacetVersion> facets = this.getSelectedProjectFacets();
        IPreset preset = SavePresetDialog.showDialog(this.getShell(), facets);
        if (preset != null) {
            this.model.refreshAvailablePresets();
            this.model.setSelectedPreset(preset.getId());
        }
    }

    private void handleDeletePreset() {
        IPreset preset = this.model.getSelectedPreset();
        this.model.setSelectedPreset(null);
        ProjectFacetsManager.deletePreset((IPreset)preset);
        this.model.refreshAvailablePresets();
    }

    private void handleShowHideRuntimes() {
        if (this.sform1.getMaximizedControl() == null) {
            this.sform1.setMaximizedControl((Control)this.sform2);
            this.showHideRuntimesButton.setText(Resources.showRuntimes);
        } else {
            this.sform1.setMaximizedControl(null);
            this.showHideRuntimesButton.setText(Resources.hideRuntimes);
        }
    }

    private void handleModelChangedEvent(String event) {
        if (event.equals(ModifyFacetedProjectDataModel.EVENT_FIXED_FACETS_CHANGED)) {
            for (TableRowData trd : this.data) {
                trd.setFixed(false);
            }
            for (IProjectFacet f : this.model.getFixedFacets()) {
                TableRowData trd = this.findTableRowData(f, true);
                trd.setFixed(true);
                trd.setSelected(true);
                this.treeViewer.setChecked((Object)trd, true);
            }
            this.refresh();
            this.updateValidationDisplay();
        } else if (event.equals(ModifyFacetedProjectDataModel.EVENT_SELECTED_PRESET_CHANGED)) {
            IPreset preset = this.model.getSelectedPreset();
            if (preset == null) {
                this.savePresetButton.setEnabled(true);
                this.deletePresetButton.setEnabled(false);
            } else {
                this.savePresetButton.setEnabled(false);
                this.deletePresetButton.setEnabled(preset.getType() == IPreset.Type.USER_DEFINED);
            }
        } else if (event.equals("targetedRuntimesChanged")) {
            this.refresh();
        }
    }

    private List<TreeItem> getAllTreeItems() {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        FacetsSelectionPanel.getAllTreeItems(this.tree.getItems(), result);
        return result;
    }

    private static void getAllTreeItems(TreeItem[] items, List<TreeItem> result) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            result.add(item);
            FacetsSelectionPanel.getAllTreeItems(item.getItems(), result);
            ++n2;
        }
    }

    private TreeItem getTreeItem(int x, int y) {
        return FacetsSelectionPanel.getTreeItemHelper(x, y, this.tree.getItems());
    }

    private static TreeItem getTreeItemHelper(int x, int y, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getBounds().contains(x, y)) {
                return item;
            }
            TreeItem res = FacetsSelectionPanel.getTreeItemHelper(x, y, item.getItems());
            if (res != null) {
                return res;
            }
            ++n2;
        }
        return null;
    }

    private int computeDefaultFacetColumnWidth() {
        GC gc = new GC((Drawable)this.getDisplay());
        int maxFacetLabelWidth = 0;
        try {
            gc.setFont(this.tree.getFont());
            for (IProjectFacet f : ProjectFacetsManager.getProjectFacets()) {
                maxFacetLabelWidth = Math.max(maxFacetLabelWidth, gc.textExtent((String)f.getLabel()).x);
            }
        }
        finally {
            gc.dispose();
        }
        return Math.max(maxFacetLabelWidth + 100, 200);
    }

    private int computeDefaultVersionColumnWidth() {
        int columnLabelWidth;
        GC gc = new GC((Drawable)this.getDisplay());
        int maxVersionStringWidth = 0;
        try {
            gc.setFont(this.tree.getFont());
            for (IProjectFacet f : ProjectFacetsManager.getProjectFacets()) {
                for (IProjectFacetVersion fv : f.getVersions()) {
                    int textExtent = gc.textExtent((String)fv.getVersionString()).x;
                    maxVersionStringWidth = Math.max(maxVersionStringWidth, textExtent + 30);
                }
            }
            columnLabelWidth = gc.textExtent((String)Resources.versionColumnLabel).x + 30;
        }
        finally {
            gc.dispose();
        }
        return Math.max(maxVersionStringWidth, columnLabelWidth);
    }

    private final class CategoryToolTip
    extends HeaderToolTip {
        public CategoryToolTip(Control control) {
            super(control);
        }

        protected final boolean shouldCreateToolTip(Event event) {
            Object treeItemData;
            TreeItem treeItem = FacetsSelectionPanel.this.getTreeItem(event.x, event.y);
            String description = null;
            if (treeItem != null && treeItem.getBounds(0).contains(event.x, event.y) && (treeItemData = treeItem.getData()) instanceof ICategory) {
                description = ((ICategory)treeItemData).getDescription();
            }
            return description != null && description.trim().length() > 0;
        }

        protected String getToolTipTitle(Event event) {
            return ((ICategory)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData()).getLabel();
        }

        protected Composite createContentArea(Event event, Composite parent) {
            Display display = parent.getDisplay();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)GridLayoutUtil.gl(1));
            composite.setBackground(display.getSystemColor(29));
            Label label = new Label(composite, 64);
            label.setLayoutData((Object)GridLayoutUtil.gdfill());
            label.setBackground(display.getSystemColor(29));
            ICategory category = (ICategory)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData();
            label.setText(category.getDescription());
            return composite;
        }
    }

    private final class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public Object getValue(Object element, String property) {
            TableRowData trd = (TableRowData)element;
            if (property.equals(FacetsSelectionPanel.VERSION_COLUMN)) {
                List<IProjectFacetVersion> versions = trd.getVersions();
                int i = 0;
                int n = versions.size();
                while (i < n) {
                    if (versions.get(i) == trd.getCurrentVersion()) {
                        return new Integer(i);
                    }
                    ++i;
                }
                return new IllegalStateException();
            }
            throw new IllegalStateException();
        }

        public boolean canModify(Object element, String property) {
            return property.equals(FacetsSelectionPanel.VERSION_COLUMN) && element instanceof TableRowData && ((TableRowData)element).getVersions().size() > 1;
        }

        public void modify(Object element, String property, Object value) {
            TreeItem item = (TreeItem)element;
            TableRowData trd = (TableRowData)item.getData();
            if (property.equals(FacetsSelectionPanel.VERSION_COLUMN)) {
                int index = (Integer)value;
                if (index != -1) {
                    IProjectFacetVersion fv = trd.getVersions().get(index);
                    if (trd.getCurrentVersion() != fv) {
                        trd.setCurrentVersion(fv);
                        FacetsSelectionPanel.this.treeViewer.update((Object)trd, null);
                        if (trd.isSelected()) {
                            FacetsSelectionPanel.this.model.setSelectedPreset(null);
                        }
                        FacetsSelectionPanel.this.updateValidationDisplay();
                    }
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private final class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object element) {
            ArrayList<Object> list = new ArrayList<Object>();
            Set categories = ProjectFacetsManager.getCategories();
            for (ICategory cat : categories) {
                boolean visible = false;
                for (IProjectFacet f : cat.getProjectFacets()) {
                    if (!FacetsSelectionPanel.this.findTableRowData(f).isVisible()) continue;
                    visible = true;
                    break;
                }
                if (!visible) continue;
                list.add(cat);
            }
            for (TableRowData trd : FacetsSelectionPanel.this.data) {
                if (trd.getProjectFacet().getCategory() != null || !trd.isVisible()) continue;
                list.add(trd);
            }
            return list.toArray();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ICategory) {
                ICategory category = (ICategory)parent;
                ArrayList<TableRowData> trds = new ArrayList<TableRowData>();
                for (IProjectFacet f : category.getProjectFacets()) {
                    TableRowData trd = FacetsSelectionPanel.this.findTableRowData(f);
                    if (!trd.isVisible()) continue;
                    trds.add(trd);
                }
                return trds.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof TableRowData) {
                IProjectFacet f = ((TableRowData)element).getProjectFacet();
                return f.getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ICategory && !((ICategory)element).getProjectFacets().isEmpty();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class FacetToolTip
    extends HeaderToolTip {
        public FacetToolTip(Control control) {
            super(control);
        }

        protected final boolean shouldCreateToolTip(Event event) {
            Object treeItemData;
            TreeItem treeItem = FacetsSelectionPanel.this.getTreeItem(event.x, event.y);
            String description = null;
            if (treeItem != null && treeItem.getBounds(0).contains(event.x, event.y) && (treeItemData = treeItem.getData()) instanceof TableRowData) {
                IProjectFacetVersion fv = ((TableRowData)treeItemData).getCurrentVersion();
                description = fv.getProjectFacet().getDescription();
            }
            return description != null && description.trim().length() > 0;
        }

        protected String getToolTipTitle(Event event) {
            TableRowData trd = (TableRowData)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData();
            return trd.getCurrentVersion().toString();
        }

        protected Composite createContentArea(Event event, Composite parent) {
            Display display = parent.getDisplay();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)GridLayoutUtil.gl(1));
            composite.setBackground(display.getSystemColor(29));
            Label label = new Label(composite, 64);
            label.setLayoutData((Object)GridLayoutUtil.gdfill());
            label.setBackground(display.getSystemColor(29));
            TableRowData trd = (TableRowData)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData();
            label.setText(trd.getCurrentVersion().getProjectFacet().getDescription());
            return composite;
        }
    }

    private static final class FixedFacetImageDescriptor
    extends CompositeImageDescriptor {
        private static final String OVERLAY_IMG_LOCATION = "images/lock.gif";
        private static final ImageData OVERLAY = FacetUiPlugin.getImageDescriptor("images/lock.gif").getImageData();
        private final ImageData base;
        private final Point size;

        public FixedFacetImageDescriptor(ImageDescriptor base) {
            this.base = base.getImageData();
            this.size = new Point(this.base.width, this.base.height);
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.base, 0, 0);
            this.drawImage(OVERLAY, 0, height - FixedFacetImageDescriptor.OVERLAY.height);
        }

        protected Point getSize() {
            return this.size;
        }
    }

    private final class FixedFacetToolTip
    extends BasicToolTip {
        private static final int FAKE_EVENT_TYPE = -9999;

        public FixedFacetToolTip(Control control) {
            super(control);
            this.setPopupDelay(0);
        }

        public void show(Point location) {
            Event fakeEvent = new Event();
            fakeEvent.type = -9999;
            fakeEvent.x = location.x;
            fakeEvent.y = location.y;
            try {
                Method method = ToolTip.class.getDeclaredMethod("toolTipCreate", Event.class);
                method.setAccessible(true);
                method.invoke((Object)this, fakeEvent);
            }
            catch (Exception e) {
                FacetUiPlugin.log(e);
            }
        }

        protected final boolean shouldCreateToolTip(Event event) {
            return event.type == -9999;
        }
    }

    public static interface IFilter {
        public boolean check(IProjectFacetVersion var1);
    }

    private final class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public String getColumnText(Object element, int column) {
            if (element instanceof ICategory) {
                if (column == 0) {
                    return ((ICategory)element).getLabel();
                }
                return "";
            }
            TableRowData trd = (TableRowData)element;
            switch (column) {
                case 0: {
                    return trd.getProjectFacet().getLabel();
                }
                case 1: {
                    return trd.getCurrentVersion().getVersionString();
                }
            }
            throw new IllegalStateException();
        }

        public Image getColumnImage(Object element, int column) {
            IAdaptable obj;
            String id;
            if (column != 0) {
                return null;
            }
            boolean isFixed = false;
            if (element instanceof TableRowData) {
                TableRowData trd = (TableRowData)element;
                IProjectFacet f = trd.getProjectFacet();
                isFixed = trd.isFixed;
                id = String.valueOf(isFixed ? "F:" : "f:") + f.getId();
                obj = f;
            } else {
                id = "c:" + ((ICategory)element).getId();
                obj = (IAdaptable)element;
            }
            Image image = FacetsSelectionPanel.this.getImageRegistry().get(id);
            if (image == null) {
                IDecorationsProvider decprov = (IDecorationsProvider)obj.getAdapter(IDecorationsProvider.class);
                Object imgdesc = decprov.getIcon();
                if (isFixed) {
                    imgdesc = new FixedFacetImageDescriptor((ImageDescriptor)imgdesc);
                }
                FacetsSelectionPanel.this.getImageRegistry().put(id, imgdesc);
                image = FacetsSelectionPanel.this.getImageRegistry().get(id);
            }
            return image;
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class ProblemsContentProvider
    implements IStructuredContentProvider {
        private ProblemsContentProvider() {
        }

        public Object[] getElements(Object element) {
            return FacetsSelectionPanel.this.problems.getChildren();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class ProblemsLabelProvider
    implements ITableLabelProvider {
        private ProblemsLabelProvider() {
        }

        public String getColumnText(Object element, int column) {
            return ((IStatus)element).getMessage();
        }

        public Image getColumnImage(Object element, int column) {
            IStatus st = (IStatus)element;
            if (st.getSeverity() == 4) {
                return FacetsSelectionPanel.this.getImageRegistry().get(FacetsSelectionPanel.IMG_ERROR);
            }
            return FacetsSelectionPanel.this.getImageRegistry().get(FacetsSelectionPanel.IMG_WARNING);
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class Resources
    extends NLS {
        public static String presetsLabel;
        public static String customPreset;
        public static String saveButtonLabel;
        public static String deleteButtonLabel;
        public static String savePresetDialogTitle;
        public static String savePresetDialogMessage;
        public static String facetColumnLabel;
        public static String versionColumnLabel;
        public static String showConstraints;
        public static String showRuntimes;
        public static String hideRuntimes;
        public static String couldNotDeselectFixedFacetMessage;
        public static String facetNotFound;
        public static String facetVersionNotFound;
        public static String facetNotSupportedByTarget;

        static {
            Resources.initializeMessages((String)FacetsSelectionPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }

        public static String bind(String msg, Object arg1, Object arg2, Object arg3) {
            return NLS.bind((String)msg, (Object[])new Object[]{arg1, arg2, arg3});
        }
    }

    private static final class Sorter
    extends ViewerSorter {
        private Sorter() {
        }

        public int compare(Viewer viewer, Object a, Object b) {
            return Sorter.getLabel(a).compareToIgnoreCase(Sorter.getLabel(b));
        }

        private static String getLabel(Object obj) {
            if (obj instanceof TableRowData) {
                return ((TableRowData)obj).getProjectFacet().getLabel();
            }
            return ((ICategory)obj).getLabel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TableRowData {
        private IProjectFacet f;
        private List<IProjectFacetVersion> allVersionsSorted;
        private IProjectFacetVersion current;
        private boolean isSelected;
        private boolean isFixed;

        public TableRowData(IProjectFacet f) throws CoreException {
            this.f = f;
            this.allVersionsSorted = new ArrayList<IProjectFacetVersion>(f.getSortedVersions(false));
            this.current = f.getDefaultVersion();
            this.isSelected = false;
            this.isFixed = false;
        }

        public IProjectFacet getProjectFacet() {
            return this.f;
        }

        public List<IProjectFacetVersion> getVersions() {
            Set<IProjectFacetVersion> availableVersions = FacetsSelectionPanel.this.model.getAvailableFacets().get(this.f);
            ArrayList<IProjectFacetVersion> versions = new ArrayList<IProjectFacetVersion>();
            for (IProjectFacetVersion fv : this.allVersionsSorted) {
                if ((availableVersions == null || !availableVersions.contains(fv)) && fv.getPluginId() != null) continue;
                versions.add(fv);
            }
            return versions;
        }

        public void addUnknownVersion(IProjectFacetVersion fv) {
            try {
                Comparator c = this.f.getVersionComparator();
                boolean added = false;
                int i = 0;
                int n = this.allVersionsSorted.size();
                while (i < n) {
                    block7: {
                        IProjectFacetVersion x = this.allVersionsSorted.get(i);
                        try {
                            if (c.compare(x.getVersionString(), fv.getVersionString()) < 0) {
                                this.allVersionsSorted.add(i, fv);
                                added = true;
                            }
                            break block7;
                        }
                        catch (Exception e) {
                            FacetUiPlugin.log(e);
                        }
                        break;
                    }
                    ++i;
                }
                if (!added) {
                    this.allVersionsSorted.add(fv);
                }
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }

        public IProjectFacetVersion getCurrentVersion() {
            List<IProjectFacetVersion> versions = this.getVersions();
            if (versions.isEmpty()) {
                this.current = null;
            } else if (!versions.contains(this.current)) {
                this.current = this.getVersions().get(0);
            }
            return this.current;
        }

        public void setCurrentVersion(IProjectFacetVersion fv) {
            this.current = fv;
        }

        public boolean isSelected() {
            if (this.getVersions().isEmpty()) {
                this.isSelected = false;
            }
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public boolean isFixed() {
            return this.isFixed;
        }

        public void setFixed(boolean isFixed) {
            this.isFixed = isFixed;
        }

        public boolean isVisible() {
            return !this.getVersions().isEmpty();
        }

        public String toString() {
            return this.current.toString();
        }
    }
}

