/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.http.core.internal;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;
import org.eclipse.wst.server.http.core.internal.Trace;

public class HttpRuntimeLocator
extends RuntimeLocatorDelegate {
    protected static final String[] runtimeTypes = new String[]{"org.eclipse.wst.server.http.runtime"};

    public void searchForRuntimes(IPath path, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        HttpRuntimeLocator.searchForRuntimes2(path, listener, monitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void searchForRuntimes2(IPath path, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        File[] files = null;
        if (path != null) {
            File f = path.toFile();
            if (!f.exists()) return;
            files = f.listFiles();
        } else {
            files = File.listRoots();
        }
        if (files != null) {
            int size = files.length;
            int work = 100 / size;
            int workLeft = 100 - work * size;
            int i = 0;
            while (i < size) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (files[i] != null && files[i].isDirectory()) {
                    HttpRuntimeLocator.searchDir(listener, files[i], 4, monitor);
                }
                monitor.worked(work);
                ++i;
            }
            monitor.worked(workLeft);
            return;
        } else {
            monitor.worked(100);
        }
    }

    protected static void searchDir(RuntimeLocatorDelegate.IRuntimeSearchListener listener, File dir, int depth, IProgressMonitor monitor) {
        IRuntimeWorkingCopy runtime;
        if ("htdocs".equals(dir.getName()) && (runtime = HttpRuntimeLocator.getRuntimeFromDir(dir.getParentFile(), monitor)) != null) {
            listener.runtimeFound(runtime);
            return;
        }
        if (depth == 0) {
            return;
        }
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                if (monitor.isCanceled()) {
                    return;
                }
                HttpRuntimeLocator.searchDir(listener, files[i], depth - 1, monitor);
                ++i;
            }
        }
    }

    protected static IRuntimeWorkingCopy getRuntimeFromDir(File dir, IProgressMonitor monitor) {
        int i = 0;
        while (i < runtimeTypes.length) {
            try {
                IRuntimeType runtimeType = ServerCore.findRuntimeType((String)runtimeTypes[i]);
                String absolutePath = dir.getAbsolutePath();
                String id = absolutePath.replace(File.separatorChar, '_').replace(':', '-');
                IRuntimeWorkingCopy runtime = runtimeType.createRuntime(id, monitor);
                runtime.setName(dir.getName());
                runtime.setLocation(new Path(absolutePath).append("htdocs"));
                IStatus status = runtime.validate(monitor);
                if (status == null || status.getSeverity() != 4) {
                    return runtime;
                }
                Trace.trace(Trace.FINER, "False runtime found at " + dir.getAbsolutePath() + ": " + status.getMessage());
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Could not find runtime", e);
            }
            ++i;
        }
        return null;
    }
}

