/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.widgets;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.DialogDataEvents;
import org.eclipse.wst.command.internal.env.ui.widgets.PageInfo;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.env.ui.widgets.WizardPageManager;

public abstract class SimpleDialog
extends Dialog
implements DialogDataEvents {
    private WidgetContributor widget_;
    private WidgetDataEvents dataEvents_;
    private Listener statusListener_;
    protected WizardPageManager pageManager_;
    private Text messageText_;
    private boolean ok_;
    Composite parent_;

    public SimpleDialog(Shell shell, PageInfo pageInfo) {
        super(shell);
        this.widget_ = pageInfo.getWidgetFactory().create();
        this.statusListener_ = new StatusListener();
    }

    public Control createDialogArea(Composite parent) {
        this.parent_ = parent;
        Composite control = (Composite)super.createDialogArea(parent);
        this.dataEvents_ = this.widget_.addControls(control, this.statusListener_);
        this.messageText_ = new Text(parent, 74);
        GridData griddata = new GridData(768);
        griddata.horizontalIndent = 10;
        this.messageText_.setLayoutData((Object)griddata);
        this.parent_.setFocus();
        this.callSetters();
        Dialog.applyDialogFont((Control)parent);
        return control;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.validatePageToStatus();
        return c;
    }

    private void enableOk(boolean state) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(state);
        }
    }

    protected abstract void callSetters();

    public WidgetDataEvents getDataEvents() {
        return this.dataEvents_;
    }

    protected WidgetContributor getWidget() {
        return this.widget_;
    }

    private void setMessage(String message) {
        if (message == null) {
            this.messageText_.setText("");
        } else {
            this.messageText_.setText(message);
        }
        this.parent_.layout();
    }

    public void validatePageToStatus() {
        IStatus status = this.widget_.getStatus();
        if (status != null) {
            String message = status.getMessage();
            int severity = status.getSeverity();
            if (severity == 4) {
                if (message.length() == 0) {
                    this.setMessage(null);
                } else {
                    this.setMessage(message);
                }
                this.ok_ = false;
            } else if (severity == 2 | severity == 1) {
                this.setMessage(message);
                this.ok_ = true;
            } else {
                this.setMessage(null);
                this.ok_ = true;
            }
        } else {
            this.setMessage(null);
            this.ok_ = true;
        }
        this.enableOk(this.ok_);
    }

    private class StatusListener
    implements Listener {
        private StatusListener() {
        }

        public void handleEvent(Event evt) {
            SimpleDialog.this.validatePageToStatus();
        }
    }
}

