/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.ServerSchedulingRule;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class DeleteServerDialog
extends MessageDialog {
    protected IServer[] servers;
    protected IFolder[] configs;
    protected List runningServersList;
    protected boolean runningServerCanStop;
    protected Button checkDeleteConfigs;
    protected Button checkDeleteRunning;
    protected Button checkDeleteRunningStop;

    public DeleteServerDialog(Shell parentShell, IServer[] servers, IFolder[] configs) {
        super(parentShell, Messages.deleteServerDialogTitle, null, null, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        if (servers == null || configs == null) {
            throw new IllegalArgumentException();
        }
        this.servers = servers;
        this.configs = configs;
        this.runningServersList = new ArrayList();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getServerState() != 4) {
                this.runningServersList.add(servers[i]);
            }
            if (servers[i].canStop().isOK()) {
                this.runningServerCanStop = true;
            }
            ++i;
        }
        this.message = servers.length == 1 ? NLS.bind((String)Messages.deleteServerDialogMessage, (Object)servers[0].getName()) : NLS.bind((String)Messages.deleteServerDialogMessageMany, (Object)String.valueOf(servers.length));
    }

    protected Control createCustomArea(Composite parent) {
        int size;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.server.ui.svcp0002");
        if (this.configs.length > 0) {
            this.checkDeleteConfigs = new Button(composite, 32);
            this.checkDeleteConfigs.setText(NLS.bind((String)Messages.deleteServerDialogLooseConfigurations, (Object)this.configs[0].getName()));
            this.checkDeleteConfigs.setSelection(true);
        }
        if ((size = this.runningServersList.size()) > 0) {
            this.checkDeleteRunning = new Button(composite, 32);
            this.checkDeleteRunning.setText(Messages.deleteServerDialogRunningServer);
            this.checkDeleteRunning.setSelection(true);
            if (this.runningServerCanStop) {
                this.checkDeleteRunningStop = new Button(composite, 32);
                this.checkDeleteRunningStop.setText(Messages.deleteServerDialogRunningServerStop);
                this.checkDeleteRunningStop.setSelection(true);
                GridData data = new GridData();
                data.horizontalIndent = 15;
                this.checkDeleteRunningStop.setLayoutData((Object)data);
                this.checkDeleteRunning.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DeleteServerDialog.this.checkDeleteRunningStop.setEnabled(DeleteServerDialog.this.checkDeleteRunning.getSelection());
                    }
                });
            }
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            final boolean checked = this.checkDeleteConfigs != null && this.checkDeleteConfigs.getSelection();
            final boolean deleteRunning = this.checkDeleteRunning != null && this.checkDeleteRunning.getSelection();
            final boolean deleteRunningStop = this.checkDeleteRunningStop != null && this.checkDeleteRunningStop.getSelection();
            Job job = new Job(Messages.deleteServerTask){

                protected IStatus run(IProgressMonitor monitor) {
                    if (DeleteServerDialog.this.runningServersList.size() > 0) {
                        DeleteServerDialog.this.prepareForDeletion(deleteRunning, deleteRunningStop);
                    }
                    if (DeleteServerDialog.this.servers.length == 0) {
                        return Status.OK_STATUS;
                    }
                    try {
                        int size = DeleteServerDialog.this.servers.length;
                        int i = 0;
                        while (i < size) {
                            DeleteServerDialog.this.servers[i].delete();
                            ++i;
                        }
                        if (checked) {
                            size = DeleteServerDialog.this.configs.length;
                            i = 0;
                            while (i < size) {
                                DeleteServerDialog.this.configs[i].delete(true, true, monitor);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        Trace.trace((byte)3, "Error while deleting resources", e);
                    }
                    return Status.OK_STATUS;
                }
            };
            int size = this.servers.length;
            ISchedulingRule[] rules = new ISchedulingRule[size + 1];
            int i = 0;
            while (i < size) {
                rules[i] = new ServerSchedulingRule(this.servers[i]);
                ++i;
            }
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            rules[size] = ruleFactory.createRule((IResource)ResourcesPlugin.getWorkspace().getRoot());
            job.setRule(MultiRule.combine((ISchedulingRule[])rules));
            job.schedule();
        }
        super.buttonPressed(buttonId);
    }

    protected void prepareForDeletion(boolean deleteRunning, boolean stopRunning) {
        LinkedList<IServer> serversList = new LinkedList<IServer>(Arrays.asList(this.servers));
        LinkedList<IFolder> configsList = new LinkedList<IFolder>(Arrays.asList(this.configs));
        if (!deleteRunning) {
            int size = this.runningServersList.size();
            int i = 0;
            while (i < size) {
                IServer server = (IServer)this.runningServersList.get(i);
                serversList.remove(server);
                if (server.getServerConfiguration() != null) {
                    configsList.remove(server.getServerConfiguration());
                }
                ++i;
            }
        } else if (stopRunning) {
            MultiServerStopListener listener = new MultiServerStopListener();
            int expected = 0;
            Iterator iter = this.runningServersList.iterator();
            while (iter.hasNext()) {
                IServer s = (IServer)iter.next();
                if (s.canStop().isOK()) {
                    ++expected;
                    s.stop(false, (IServer.IOperationListener)listener);
                    continue;
                }
                serversList.remove(s);
                configsList.remove(s.getServerConfiguration());
            }
            try {
                while (expected != listener.getNumberStopped()) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                Trace.trace((byte)2, "Interrupted while waiting for servers stop");
            }
        }
        this.servers = new IServer[serversList.size()];
        serversList.toArray(this.servers);
        this.configs = new IFolder[configsList.size()];
        configsList.toArray(this.configs);
    }

    class MultiServerStopListener
    implements IServer.IOperationListener {
        protected int num;

        MultiServerStopListener() {
        }

        public void done(IStatus result) {
            ++this.num;
        }

        public int getNumberStopped() {
            return this.num;
        }
    }
}

