/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class ServerTypeTreeContentProvider
extends AbstractTreeContentProvider {
    protected boolean localhost = true;
    protected IModuleType moduleType;
    protected String serverTypeId;
    protected boolean includeIncompatibleVersions;

    public ServerTypeTreeContentProvider(IModuleType moduleType, String serverTypeId) {
        super(false);
        this.moduleType = moduleType;
        this.serverTypeId = serverTypeId;
        this.fillTree();
    }

    public void fillTree() {
        this.clean();
        ArrayList list = new ArrayList();
        IServerType[] serverTypes = ServerCore.getServerTypes();
        if (serverTypes != null) {
            int size = serverTypes.length;
            int i = 0;
            while (i < size) {
                IServerType serverType = serverTypes[i];
                if (this.include(serverType)) {
                    try {
                        IRuntimeType runtimeType = serverType.getRuntimeType();
                        AbstractTreeContentProvider.TreeElement ele = this.getOrCreate(list, runtimeType.getVendor());
                        ele.contents.add(serverType);
                        this.elementToParentMap.put(serverType, ele);
                    }
                    catch (Exception e) {
                        Trace.trace((byte)2, "Error in server configuration content provider", e);
                    }
                }
                ++i;
            }
        }
        this.elements = list.toArray();
    }

    protected boolean include(IServerType serverType) {
        if (this.serverTypeId != null && !serverType.getId().startsWith(this.serverTypeId)) {
            return false;
        }
        IRuntimeType runtimeType = serverType.getRuntimeType();
        if (runtimeType == null) {
            return false;
        }
        String moduleTypeId = null;
        if (this.moduleType != null) {
            moduleTypeId = this.moduleType.getId();
        }
        if (this.includeIncompatibleVersions) {
            if (!ServerUtil.isSupportedModule((IModuleType[])runtimeType.getModuleTypes(), (String)moduleTypeId, null)) {
                return false;
            }
        } else {
            String moduleVersion = null;
            if (this.moduleType != null) {
                moduleVersion = this.moduleType.getVersion();
            }
            if (!ServerUtil.isSupportedModule((IModuleType[])runtimeType.getModuleTypes(), (String)moduleTypeId, (String)moduleVersion)) {
                return false;
            }
        }
        return this.localhost || serverType.supportsRemoteHosts();
    }

    protected boolean checkForNonStubEnvironmentRuntime(IServerType serverType) {
        IRuntimeType runtimeType = serverType.getRuntimeType();
        IRuntime[] runtimes = ServerUIPlugin.getRuntimes(runtimeType);
        if (runtimes == null || runtimes.length == 0) {
            return false;
        }
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            if (!runtimes[i].isStub()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setLocalhost(boolean local) {
        this.localhost = local;
        this.fillTree();
    }

    public void setIncludeIncompatibleVersions(boolean b) {
        this.includeIncompatibleVersions = b;
        this.fillTree();
    }
}

