/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.fragment;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.wizard.fragment.SelectClientWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class OptionalClientWizardFragment
extends WizardFragment {
    protected IClient[] clients;
    protected IModuleArtifact moduleArtifact;
    protected IServer lastServer;

    public OptionalClientWizardFragment(IModuleArtifact moduleArtifact) {
        this.moduleArtifact = moduleArtifact;
    }

    protected void createChildFragments(List list) {
        if (this.clients != null && this.clients.length > 1) {
            list.add(new SelectClientWizardFragment());
        }
    }

    protected void updateClients() {
        if (this.getTaskModel() == null) {
            return;
        }
        try {
            IServer server = (IServer)this.getTaskModel().getObject("server");
            if (this.lastServer == null && server == null) {
                return;
            }
            if (this.lastServer != null && this.lastServer.equals(server)) {
                return;
            }
            this.lastServer = server;
            this.getTaskModel().putObject("clients", null);
            this.getTaskModel().putObject("hasClients", (Object)new Boolean(false));
            Object launchable = null;
            try {
                Object[] obj = ServerUIPlugin.getLaunchableAdapter(server, this.moduleArtifact);
                this.getTaskModel().putObject("launchableAdapter", obj[0]);
                this.getTaskModel().putObject("launchable", obj[1]);
                launchable = obj[1];
            }
            catch (CoreException ce) {
                this.getTaskModel().putObject("launchableAdapter", null);
                this.getTaskModel().putObject("launchable", null);
                EclipseUtil.openError(null, ce.getStatus());
            }
            String launchMode = (String)this.getTaskModel().getObject("launch-mode");
            this.clients = ServerUIPlugin.getClients(server, launchable, launchMode);
            if (this.clients != null) {
                if (this.clients.length > 1) {
                    this.getTaskModel().putObject("clients", (Object)this.clients);
                    this.getTaskModel().putObject("hasClients", (Object)new Boolean(true));
                } else {
                    this.getTaskModel().putObject("client", (Object)this.clients[0]);
                }
            }
            this.updateChildFragments();
        }
        catch (Exception exception) {}
    }

    public void enter() {
        this.updateClients();
    }

    public List getChildFragments() {
        this.updateClients();
        return super.getChildFragments();
    }

    public void setTaskModel(TaskModel taskModel) {
        super.setTaskModel(taskModel);
        this.updateClients();
    }
}

