/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.custom;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MonitorStackLayout
extends Layout {
    public Control topControl;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int maxWidth = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < children.length) {
            if (children[i] == this.topControl) {
                Point size = children[i].computeSize(wHint, hHint, flushCache);
                maxWidth = Math.max(size.x, maxWidth);
                maxHeight = Math.max(size.y, maxHeight);
            }
            ++i;
        }
        int width = maxWidth;
        int height = maxHeight;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        Rectangle rect = composite.getClientArea();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Label) {
                Rectangle r = new Rectangle(rect.x + 2, rect.y, rect.width - 2, rect.height);
                children[i].setBounds(r);
            } else {
                children[i].setBounds(rect);
            }
            children[i].setVisible(children[i] == this.topControl);
            ++i;
        }
    }

    public String toString() {
        return "MonitorStackLayout";
    }
}

