/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsf.designtime.context.AbstractDTExternalContextFactory;
import org.eclipse.jst.jsf.designtime.el.AbstractDTMethodResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTVariableResolver;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFCorePlugin
extends WTPPlugin {
    public static final String PLUGIN_ID = "org.eclipse.jst.jsf.core";
    private static JSFCorePlugin plugin;
    private IPreferenceStore preferenceStore;
    private static Map<String, AbstractDTVariableResolver> _registeredVariableResolvers;
    private static final String VARIABLE_RESOLVER_EXT_POINT_NAME = "variableresolver";
    private static Map<String, AbstractDTPropertyResolver> _registeredPropertyResolvers;
    private static final String PROPERTY_RESOLVER_EXT_POINT_NAME = "propertyresolver";
    private static Map<String, AbstractDTMethodResolver> _registeredMethodResolvers;
    private static final String METHOD_RESOLVER_EXT_POINT_NAME = "methodresolver";
    private static Map<String, AbstractDTExternalContextFactory> _registeredExternalContextProviders;
    private static final String EXTERNAL_CONTEXT_EXT_POINT_NAME = "externalcontext";

    public JSFCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static JSFCorePlugin getDefault() {
        return plugin;
    }

    public static void log(Exception e, String msg) {
        ILog log = JSFCorePlugin.getDefault().getLog();
        log.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public static void log(int severity, String message, Throwable ex) {
        JSFCorePlugin.getDefault().getLog().log((IStatus)new Status(severity, PLUGIN_ID, 0, message, ex));
    }

    public static void log(int severity, String message) {
        JSFCorePlugin.log(severity, message, null);
    }

    public static void log(String message, Throwable t) {
        ILog log = plugin.getLog();
        log.log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, message, t));
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public static synchronized Map<String, AbstractDTVariableResolver> getVariableResolvers() {
        if (_registeredVariableResolvers == null) {
            JSFCorePlugin.registerVariableResolverProviders();
            if (_registeredVariableResolvers == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableMap(_registeredVariableResolvers);
    }

    private static void registerVariableResolverProviders() {
        _registeredVariableResolvers = new HashMap<String, AbstractDTVariableResolver>();
        JSFCorePlugin.loadRegisteredExtensions(VARIABLE_RESOLVER_EXT_POINT_NAME, _registeredVariableResolvers, VARIABLE_RESOLVER_EXT_POINT_NAME);
    }

    public static synchronized Map<String, AbstractDTPropertyResolver> getPropertyResolvers() {
        if (_registeredPropertyResolvers == null) {
            JSFCorePlugin.registerPropertyResolverProviders();
            if (_registeredPropertyResolvers == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableMap(_registeredPropertyResolvers);
    }

    private static void registerPropertyResolverProviders() {
        _registeredPropertyResolvers = new HashMap<String, AbstractDTPropertyResolver>();
        JSFCorePlugin.loadRegisteredExtensions(PROPERTY_RESOLVER_EXT_POINT_NAME, _registeredPropertyResolvers, PROPERTY_RESOLVER_EXT_POINT_NAME);
    }

    public static synchronized Map<String, AbstractDTMethodResolver> getMethodResolvers() {
        if (_registeredMethodResolvers == null) {
            JSFCorePlugin.registerMethodResolverProviders();
            if (_registeredMethodResolvers == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableMap(_registeredMethodResolvers);
    }

    private static void registerMethodResolverProviders() {
        _registeredMethodResolvers = new HashMap<String, AbstractDTMethodResolver>();
        JSFCorePlugin.loadRegisteredExtensions(METHOD_RESOLVER_EXT_POINT_NAME, _registeredMethodResolvers, METHOD_RESOLVER_EXT_POINT_NAME);
    }

    public static synchronized Map<String, AbstractDTExternalContextFactory> getExternalContextProviders() {
        if (_registeredExternalContextProviders == null) {
            JSFCorePlugin.registerExternalContextProviders();
            if (_registeredExternalContextProviders == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableMap(_registeredExternalContextProviders);
    }

    private static void registerExternalContextProviders() {
        _registeredExternalContextProviders = new HashMap<String, AbstractDTExternalContextFactory>();
        JSFCorePlugin.loadRegisteredExtensions(EXTERNAL_CONTEXT_EXT_POINT_NAME, _registeredExternalContextProviders, EXTERNAL_CONTEXT_EXT_POINT_NAME);
    }

    private static <ResolverProvider> void loadRegisteredExtensions(String extName, Map<String, ResolverProvider> registry, String elementName) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(plugin.getBundle().getSymbolicName(), extName);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String bundleId = extension.getContributor().getName();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if (elementName.equals(element.getName()) && element.getAttribute("class") != null && element.getAttribute("id") != null) {
                    String factoryClassName = element.getAttribute("class");
                    String id = element.getAttribute("id");
                    Bundle bundle = Platform.getBundle((String)bundleId);
                    if (bundle != null) {
                        try {
                            Class factoryClass = bundle.loadClass(factoryClassName);
                            Object variableResolver = factoryClass.newInstance();
                            registry.put(id, variableResolver);
                        }
                        catch (Exception e) {
                            ILog logger_ = JSFCorePlugin.getDefault().getLog();
                            logger_.log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, "Error loading resolver provider extension point", (Throwable)e));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), this.getBundle().getSymbolicName());
        }
        return this.preferenceStore;
    }
}

