/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.symbols;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IBoundedMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.symbols.Messages;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.eclipse.jst.jsf.validation.internal.el.ELExpressionValidator;
import org.eclipse.jst.jsf.validation.internal.el.IExpressionSemanticValidator;
import org.w3c.dom.Element;

public abstract class AbstractDataModelVariableFactory {
    public final ValueType createValueExpression(String elText, IStructuredDocumentContext elContext, IFile file) {
        assert (elText != null);
        assert (elContext != null);
        assert (file != null);
        ValidationPreferences prefs = new ValidationPreferences(JSFCorePlugin.getDefault().getPreferenceStore());
        prefs.load();
        ELExpressionValidator validator = new ELExpressionValidator(elContext, elText, file, prefs.getElPrefs());
        validator.validateXMLNode();
        IExpressionSemanticValidator semValidator = validator.getSemanticValidator();
        if (semValidator != null && semValidator.getExpressionType() instanceof ValueType) {
            return (ValueType)semValidator.getExpressionType();
        }
        return null;
    }

    protected final ISymbol createArraySymbol(String symbolName, String signature, IJavaProject javaProject) {
        assert (symbolName != null);
        assert (signature != null);
        assert (javaProject != null);
        String arrayElementType = Signature.getElementType((String)signature);
        int arrayCount = Signature.getArrayCount((String)signature);
        String adjustedSignature = null;
        adjustedSignature = arrayCount > 0 ? Signature.createArraySignature((String)arrayElementType, (int)(arrayCount - 1)) : arrayElementType;
        return this.createScalarSymbol(symbolName, adjustedSignature, javaProject);
    }

    public ISymbol createFromType(String symbolName, ValueType valueType, IJavaProject javaProject) {
        return this.internalCreateFromBaseType(symbolName, valueType, javaProject);
    }

    private ISymbol internalCreateFromBaseType(String symbolName, ValueType valueType, IJavaProject javaProject) {
        if (Signature.getArrayCount((String)valueType.getSignature()) > 0) {
            return this.createArraySymbol(symbolName, valueType.getSignature(), javaProject);
        }
        if (valueType.isInstanceOf("Ljava.util.List;")) {
            return this.createFromList(symbolName, valueType, javaProject);
        }
        if (valueType.isInstanceOf("Ljavax.servlet.jsp.jstl.sql.Result;") || valueType.isInstanceOf("Ljava.sql.ResultSet;") || valueType.isInstanceOf("Ljavax.faces.model.DataModel;")) {
            return this.createDefaultSymbol(symbolName);
        }
        return this.createScalarSymbol(symbolName, valueType.getSignature(), javaProject);
    }

    protected final ISymbol createFromList(String symbolName, ValueType valueType, IJavaProject javaProject) {
        String typeArg;
        assert (symbolName != null);
        assert (valueType != null);
        assert (javaProject != null);
        assert ("Ljava.util.List;".equals(valueType.getSignature()));
        String[] typeArguments = valueType.getTypeArguments();
        if (typeArguments != null && typeArguments.length > 0 && Signature.getTypeSignatureKind((String)(typeArg = typeArguments[0])) == 1) {
            return this.createScalarSymbol(symbolName, typeArg, javaProject);
        }
        return this.createDefaultSymbol(symbolName);
    }

    protected final ISymbol createScalarSymbol(String symbolName, String signature, IJavaProject javaProject) {
        IType type;
        assert (symbolName != null);
        assert (signature != null);
        assert (javaProject != null);
        String elementType = Signature.getElementType((String)signature);
        IJavaTypeDescriptor2 desc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        int arrayCount = Signature.getArrayCount((String)signature);
        if (arrayCount > 0) {
            desc.setArrayCount(arrayCount);
        }
        if ((type = TypeUtil.resolveType((IJavaProject)javaProject, (String)elementType)) != null) {
            desc.setType(type);
        } else {
            desc.setTypeSignatureDelegate(Signature.getTypeErasure((String)signature));
        }
        desc.getTypeParameterSignatures().addAll((Collection)Arrays.asList(Signature.getTypeArguments((String)signature)));
        IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        symbol.setName(symbolName);
        symbol.setTypeDescriptor((ITypeDescriptor)desc);
        symbol.setRuntimeSource(ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL);
        return symbol;
    }

    public final ISymbol createDefaultSymbol(String symbolName) {
        assert (symbolName != null);
        IBoundedMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIBoundedMapTypeDescriptor();
        typeDesc.setMapSource(new HashMap());
        IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        symbol.setName(symbolName);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        symbol.setDetailedDescription(Messages.getString("AbstractDataModelVariableFactory.DataModel.Symbol.RowVariable.DetailedDescription"));
        symbol.setRuntimeSource(ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL);
        return symbol;
    }

    protected static String getELText(Element dataTableElement) {
        assert (dataTableElement != null);
        String attrVal = dataTableElement.getAttribute("value");
        if (attrVal != null) {
            return AppConfigValidationUtil.extractELExpression(attrVal).getElText();
        }
        return null;
    }

    protected final String internalGetVariableSourceName() {
        String variableSourceName = this.getVariableSourceName();
        if (variableSourceName == null) {
            JSFCorePlugin.log("Missing variableSourceName", new Throwable());
            return "**missing variable source name**";
        }
        return variableSourceName;
    }

    protected abstract String getVariableSourceName();
}

