/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.metadataprocessors.IType;
import org.eclipse.jst.jsf.metadataprocessors.ITypeDescriptor;
import org.eclipse.jst.jsf.metadataprocessors.internal.AbstractMetaDataEnabledType;
import org.osgi.framework.Bundle;

public abstract class AbstractMetaDataEnabledTypeFactory {
    protected static AbstractMetaDataEnabledTypeFactory INSTANCE;

    protected AbstractMetaDataEnabledTypeFactory() {
    }

    public abstract ITypeDescriptor getType(String var1);

    public ITypeDescriptor getType(AbstractMetaDataEnabledType type) {
        return this.createType(type);
    }

    protected ITypeDescriptor createType(IType atype) {
        ITypeDescriptor desc;
        if (atype != null && (desc = this.createDescriptor(atype)) != null) {
            desc.setTypeExtension(atype);
            return desc;
        }
        return null;
    }

    private ITypeDescriptor createDescriptor(IType type) {
        Bundle bundle;
        String className;
        block7: {
            className = type.getClassName();
            bundle = Platform.getBundle((String)type.getBundleID());
            if (bundle != null) break block7;
            JSFCorePlugin.log(4, String.valueOf(type.getBundleID()) + " could not be created to load " + className);
            return null;
        }
        try {
            Class klass = bundle.loadClass(className);
            if (klass != null) {
                if (ITypeDescriptor.class.isAssignableFrom(klass)) {
                    return (ITypeDescriptor)klass.newInstance();
                }
                JSFCorePlugin.log(1, String.valueOf(className) + " was not found in " + type.getBundleID() + " for " + type.getTypeID());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            JSFCorePlugin.log(4, String.valueOf(className) + " was not found in " + type.getBundleID() + " for " + type.getTypeID());
        }
        catch (InstantiationException instantiationException) {
            JSFCorePlugin.log(4, "InstantiationException: " + className + " in " + type.getBundleID() + " for " + type.getTypeID());
        }
        catch (IllegalAccessException illegalAccessException) {
            JSFCorePlugin.log(4, "IllegalAccessException: " + className + " in " + type.getBundleID() + " for " + type.getTypeID());
        }
        return null;
    }
}

