/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal;

import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsf.core.internal.IJSFPreferenceModel;

public class ELValidationPreferences
implements IJSFPreferenceModel {
    private static final String KEY_ENABLE_BUILD_VALIDATION = "org.eclipse.jst.jsf.ui.ValidateJSFELBuild";
    private static final boolean DEFAULT_ENABLE_BUILD_VALIDATION = true;
    private static final String KEY_ENABLE_INCREMENTAL_VALIDATION = "org.eclipse.jst.jsf.ui.ValidateJSFELIncremental";
    private static final boolean DEFAULT_ENABLE_INCREMENTAL_VALIDATION = false;
    private boolean _enableBuildValidation;
    private boolean _enableIncrementalValidation;
    private int[] _severities;
    public static final String BINARY_OP_BOTH_OPERANDS_NULL = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_BOTH_OPERANDS_NULL");
    public static final String BINARY_OP_POSSIBLE_DIVISION_BY_ZERO = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_POSSIBLE_DIVISION_BY_ZERO");
    public static final String BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION");
    public static final String BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME");
    public static final String BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME");
    public static final String BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN");
    public static final String BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS");
    public static final String BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME");
    public static final String BINARY_OP_NO_AVAILABLE_TYPE_COERCION = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_NO_AVAILABLE_TYPE_COERCION");
    public static final String BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS");
    public static final String UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME = ELValidationPreferences.createQualifiedKeyName("UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME");
    public static final String UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE = ELValidationPreferences.createQualifiedKeyName("UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE");
    public static final String UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO = ELValidationPreferences.createQualifiedKeyName("UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO");
    public static final String UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION = ELValidationPreferences.createQualifiedKeyName("UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION");
    public static final String UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN = ELValidationPreferences.createQualifiedKeyName("UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN");
    public static final String TERNARY_OP_CHOICE_IS_ALWAYS_SAME = ELValidationPreferences.createQualifiedKeyName("TERNARY_OP_CHOICE_IS_ALWAYS_SAME");
    public static final String TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN = ELValidationPreferences.createQualifiedKeyName("TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN");
    public static final String UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED = ELValidationPreferences.createQualifiedKeyName("UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED");
    public static final String CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING = ELValidationPreferences.createQualifiedKeyName("CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING");
    public static final String MEMBER_NOT_FOUND = ELValidationPreferences.createQualifiedKeyName("MEMBER_NOT_FOUND");
    public static final String VARIABLE_NOT_FOUND = ELValidationPreferences.createQualifiedKeyName("VARIABLE_NOT_FOUND");
    public static final String MISSING_CLOSING_EXPR_BRACKET = ELValidationPreferences.createQualifiedKeyName("MISSING_CLOSING_EXPR_BRACKET");
    public static final String GENERAL_SYNTAX_ERROR = ELValidationPreferences.createQualifiedKeyName("GENERAL_SYNTAX_ERROR");
    public static final String EMPTY_EL_EXPRESSION = ELValidationPreferences.createQualifiedKeyName("EMPTY_EL_EXPRESSION");
    public static final String BINARY_OP_DOT_WITH_VALUEB_NULL = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_DOT_WITH_VALUEB_NULL");
    public static final String BINARY_OP_DOT_WITH_DOTTED_KEY_SHOULD_USE_ARRAY = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_DOT_WITH_DOTTED_KEY_SHOULD_USE_ARRAY");
    public static final String POSSIBLE_ARRAY_INDEX_OUT_OF_BOUNDS = ELValidationPreferences.createQualifiedKeyName("POSSIBLE_ARRAY_INDEX_OUT_OF_BOUNDS");
    public static final String BINARY_COMPARISON_WITH_ENUM_ALWAYS_SAME = ELValidationPreferences.createQualifiedKeyName("BINARY_COMPARISON_WITH_ENUM_ALWAYS_SAME");
    public static final String BINARY_OP_COMPARISON_OF_ENUMS_INCOMPATIBLE = ELValidationPreferences.createQualifiedKeyName("BINARY_OP_COMPARISON_OF_ENUMS_INCOMPATIBLE");
    public static final String MEMBER_IS_INTERMEDIATE = ELValidationPreferences.createQualifiedKeyName("MEMBER_IS_INTERMEDIATE");

    public void load(IPreferenceStore prefStore) {
        if (!prefStore.contains(KEY_ENABLE_BUILD_VALIDATION)) {
            prefStore.setDefault(KEY_ENABLE_BUILD_VALIDATION, true);
        }
        this._enableBuildValidation = prefStore.getBoolean(KEY_ENABLE_BUILD_VALIDATION);
        if (!prefStore.contains(KEY_ENABLE_INCREMENTAL_VALIDATION)) {
            prefStore.setDefault(KEY_ENABLE_INCREMENTAL_VALIDATION, false);
        }
        this._enableIncrementalValidation = prefStore.getBoolean(KEY_ENABLE_INCREMENTAL_VALIDATION);
        this.loadSeverities(prefStore);
    }

    private void loadSeverities(IPreferenceStore prefStore) {
        int[] severities = this.getSeverities();
        int i = 0;
        while (i < 30) {
            String key = ELValidationPreferences.getKeyById(i);
            if (!prefStore.contains(key)) {
                int diagSeverity = ELValidationPreferences.getDefaultSeverity(i);
                Severity severity = ELValidationPreferences.mapDiagToSeverity(diagSeverity);
                prefStore.setDefault(key, severity.toString());
            }
            String storedSeverity = prefStore.getString(key);
            severities[i] = ELValidationPreferences.mapSeverityToDiag(storedSeverity);
            ++i;
        }
    }

    public void commit(IPreferenceStore prefStore) {
        prefStore.setValue(KEY_ENABLE_BUILD_VALIDATION, this._enableBuildValidation);
        prefStore.setValue(KEY_ENABLE_INCREMENTAL_VALIDATION, this._enableIncrementalValidation);
        this.commitSeverities(prefStore);
    }

    private void commitSeverities(IPreferenceStore prefStore) {
        int[] severities = this.getSeverities();
        int i = 0;
        while (i < severities.length) {
            String key = ELValidationPreferences.getKeyById(i);
            prefStore.setValue(key, ELValidationPreferences.mapDiagToSeverity(severities[i]).toString());
            ++i;
        }
    }

    public void setDefaults() {
        this.setEnableBuildValidation(true);
        this.setEnableIncrementalValidation(false);
        this.setProblemSeverityDefaults();
    }

    private void setProblemSeverityDefaults() {
        int[] severities = this.getSeverities();
        int i = 0;
        while (i < 30) {
            severities[i] = ELValidationPreferences.getDefaultSeverity(i);
            ++i;
        }
    }

    public Object getValueByKey(IScopeContext context, String key) {
        if (KEY_ENABLE_BUILD_VALIDATION.equals(key)) {
            return this.isEnableBuildValidation();
        }
        if (KEY_ENABLE_INCREMENTAL_VALIDATION.equals(key)) {
            return this.isEnableIncrementalValidation();
        }
        try {
            Severity severity = this.getSeverity(key);
            return severity.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public Object getStoredValueByKey(IScopeContext context, String key) {
        if (KEY_ENABLE_BUILD_VALIDATION.equals(key)) {
            return context.getNode("org.eclipse.jst.jsf.ui").getBoolean(key, true);
        }
        if (KEY_ENABLE_INCREMENTAL_VALIDATION.equals(key)) {
            return context.getNode("org.eclipse.jst.jsf.ui").getBoolean(key, false);
        }
        try {
            return context.getNode("org.eclipse.jst.jsf.core").get(key, ELValidationPreferences.mapDiagToSeverity(ELValidationPreferences.getDefaultSeverity(ELValidationPreferences.getIdByKey(key))).toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public Object setValueByKey(IScopeContext context, String key, Object value) {
        if (KEY_ENABLE_BUILD_VALIDATION.equals(key)) {
            boolean oldValue = this.isEnableBuildValidation();
            boolean newValue = (Boolean)value;
            this.setEnableBuildValidation(newValue);
            return oldValue;
        }
        if (KEY_ENABLE_INCREMENTAL_VALIDATION.equals(key)) {
            boolean oldValue = this.isEnableIncrementalValidation();
            boolean newValue = (Boolean)value;
            this.setEnableIncrementalValidation(newValue);
            return oldValue;
        }
        Severity oldValue = this.getSeverity(key);
        this.setSeverity(key, (Severity)((Object)value));
        return oldValue;
    }

    public boolean isEnableBuildValidation() {
        return this._enableBuildValidation;
    }

    public boolean isEnableIncrementalValidation() {
        return this._enableIncrementalValidation;
    }

    public void setEnableBuildValidation(boolean enableBuildValidation) {
        this._enableBuildValidation = enableBuildValidation;
    }

    public void setEnableIncrementalValidation(boolean enableIncrementalValidation) {
        this._enableIncrementalValidation = enableIncrementalValidation;
    }

    public Severity getSeverity(String key) {
        int severityDiag = this._severities[ELValidationPreferences.getIdByKey(key)];
        Severity severity = ELValidationPreferences.mapDiagToSeverity(severityDiag);
        return severity;
    }

    public void setSeverity(String key, Severity severity) {
        int newSeverityDiag = ELValidationPreferences.mapSeverityToDiag(severity.toString());
        int diagId = ELValidationPreferences.getIdByKey(key);
        this._severities[diagId] = newSeverityDiag;
    }

    public final int getDiagnosticSeverity(int diagnosticId) {
        return this.getSeverities()[diagnosticId];
    }

    private int[] getSeverities() {
        if (this._severities == null) {
            this._severities = new int[30];
        }
        return this._severities;
    }

    public static Severity mapDiagToSeverity(int diagSeverity) {
        switch (diagSeverity) {
            case 4: {
                return Severity.ERROR;
            }
            case 2: {
                return Severity.WARNING;
            }
        }
        return Severity.IGNORE;
    }

    public static int mapSeverityToDiag(String severity) {
        if ("error".equals(severity)) {
            return 4;
        }
        if ("warning".equals(severity)) {
            return 2;
        }
        if ("ignore".equals(severity)) {
            return 0;
        }
        throw new IllegalArgumentException("Invalid enum name: " + severity);
    }

    public static int getDefaultSeverity(int diagnosticId) {
        switch (diagnosticId) {
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 4;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 2;
            }
            case 11: {
                return 2;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 4;
            }
            case 14: {
                return 4;
            }
            case 15: {
                return 2;
            }
            case 16: {
                return 4;
            }
            case 17: {
                return 2;
            }
            case 18: {
                return 4;
            }
            case 19: {
                return 2;
            }
            case 20: {
                return 2;
            }
            case 21: {
                return 4;
            }
            case 22: {
                return 2;
            }
            case 23: {
                return 2;
            }
            case 24: {
                return 2;
            }
            case 25: {
                return 2;
            }
            case 26: {
                return 2;
            }
            case 27: {
                return 2;
            }
            case 28: {
                return 4;
            }
            case 29: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Diagnostic Id: " + diagnosticId + " is out of range");
    }

    public static String getKeyById(int diagnosticId) {
        switch (diagnosticId) {
            case 0: {
                return BINARY_OP_BOTH_OPERANDS_NULL;
            }
            case 1: {
                return BINARY_OP_POSSIBLE_DIVISION_BY_ZERO;
            }
            case 2: {
                return BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION;
            }
            case 3: {
                return BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME;
            }
            case 4: {
                return BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME;
            }
            case 5: {
                return BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN;
            }
            case 6: {
                return BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS;
            }
            case 7: {
                return BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME;
            }
            case 8: {
                return BINARY_OP_NO_AVAILABLE_TYPE_COERCION;
            }
            case 9: {
                return BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS;
            }
            case 10: {
                return UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME;
            }
            case 11: {
                return UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE;
            }
            case 12: {
                return UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO;
            }
            case 13: {
                return UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION;
            }
            case 14: {
                return UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN;
            }
            case 15: {
                return TERNARY_OP_CHOICE_IS_ALWAYS_SAME;
            }
            case 16: {
                return TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN;
            }
            case 17: {
                return UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED;
            }
            case 18: {
                return CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING;
            }
            case 19: {
                return MEMBER_NOT_FOUND;
            }
            case 20: {
                return VARIABLE_NOT_FOUND;
            }
            case 21: {
                return MISSING_CLOSING_EXPR_BRACKET;
            }
            case 22: {
                return GENERAL_SYNTAX_ERROR;
            }
            case 23: {
                return EMPTY_EL_EXPRESSION;
            }
            case 24: {
                return BINARY_OP_DOT_WITH_VALUEB_NULL;
            }
            case 25: {
                return BINARY_OP_DOT_WITH_DOTTED_KEY_SHOULD_USE_ARRAY;
            }
            case 26: {
                return POSSIBLE_ARRAY_INDEX_OUT_OF_BOUNDS;
            }
            case 27: {
                return BINARY_COMPARISON_WITH_ENUM_ALWAYS_SAME;
            }
            case 28: {
                return BINARY_OP_COMPARISON_OF_ENUMS_INCOMPATIBLE;
            }
            case 29: {
                return MEMBER_IS_INTERMEDIATE;
            }
        }
        throw new IllegalArgumentException("Diagnostic Id: " + diagnosticId + " is out of range");
    }

    public static int getIdByKey(String key) {
        if (BINARY_OP_BOTH_OPERANDS_NULL.equals(key)) {
            return 0;
        }
        if (BINARY_OP_POSSIBLE_DIVISION_BY_ZERO.equals(key)) {
            return 1;
        }
        if (BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION.equals(key)) {
            return 2;
        }
        if (BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME.equals(key)) {
            return 3;
        }
        if (BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME.equals(key)) {
            return 4;
        }
        if (BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN.equals(key)) {
            return 5;
        }
        if (BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS.equals(key)) {
            return 6;
        }
        if (BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME.equals(key)) {
            return 7;
        }
        if (BINARY_OP_NO_AVAILABLE_TYPE_COERCION.equals(key)) {
            return 8;
        }
        if (BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS.equals(key)) {
            return 9;
        }
        if (UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME.equals(key)) {
            return 10;
        }
        if (UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE.equals(key)) {
            return 11;
        }
        if (UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO.equals(key)) {
            return 12;
        }
        if (UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION.equals(key)) {
            return 13;
        }
        if (UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN.equals(key)) {
            return 14;
        }
        if (TERNARY_OP_CHOICE_IS_ALWAYS_SAME.equals(key)) {
            return 15;
        }
        if (TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN.equals(key)) {
            return 16;
        }
        if (UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED.equals(key)) {
            return 17;
        }
        if (CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING.equals(key)) {
            return 18;
        }
        if (MEMBER_NOT_FOUND.equals(key)) {
            return 19;
        }
        if (VARIABLE_NOT_FOUND.equals(key)) {
            return 20;
        }
        if (MISSING_CLOSING_EXPR_BRACKET.equals(key)) {
            return 21;
        }
        if (GENERAL_SYNTAX_ERROR.equals(key)) {
            return 22;
        }
        if (EMPTY_EL_EXPRESSION.equals(key)) {
            return 23;
        }
        if (BINARY_OP_DOT_WITH_VALUEB_NULL.equals(key)) {
            return 24;
        }
        if (BINARY_OP_DOT_WITH_DOTTED_KEY_SHOULD_USE_ARRAY.equals(key)) {
            return 25;
        }
        if (POSSIBLE_ARRAY_INDEX_OUT_OF_BOUNDS.equals(key)) {
            return 26;
        }
        if (BINARY_COMPARISON_WITH_ENUM_ALWAYS_SAME.equals(key)) {
            return 27;
        }
        if (BINARY_OP_COMPARISON_OF_ENUMS_INCOMPATIBLE.equals(key)) {
            return 28;
        }
        if (MEMBER_IS_INTERMEDIATE.equals(key)) {
            return 29;
        }
        throw new IllegalArgumentException("Severity Key: " + key);
    }

    private static String createQualifiedKeyName(String baseName) {
        return "org.eclipse.jst.jsf.core." + baseName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        ERROR{

            public String toString() {
                return "error";
            }
        }
        ,
        WARNING{

            public String toString() {
                return "warning";
            }
        }
        ,
        IGNORE{

            public String toString() {
                return "ignore";
            }
        };


        public static Severity valueOfString(String value) {
            if ("error".equals(value)) {
                return ERROR;
            }
            if ("warning".equals(value)) {
                return WARNING;
            }
            return IGNORE;
        }
    }
}

