/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.BooleanLiteralType;
import org.eclipse.jst.jsf.common.internal.types.FloatLiteralType;
import org.eclipse.jst.jsf.common.internal.types.IntegerLiteralType;
import org.eclipse.jst.jsf.common.internal.types.MethodType;
import org.eclipse.jst.jsf.common.internal.types.NullLiteralType;
import org.eclipse.jst.jsf.common.internal.types.SignatureBasedType;
import org.eclipse.jst.jsf.common.internal.types.StringLiteralType;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.internal.util.IObjectSymbolBasedValueType;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.resolver.ISymbolContextResolver;
import org.eclipse.jst.jsf.designtime.resolver.StructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.validation.internal.ELValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.el.EvaluationTracker;
import org.eclipse.jst.jsf.validation.internal.el.IExpressionSemanticValidator;
import org.eclipse.jst.jsf.validation.internal.el.ValueExpressionTracker;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.ValidationMessageFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.BinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.BracketOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.DotOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.TernaryChoiceOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.UnaryOperator;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAddExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAndExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTChoiceExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTEqualityExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTFunctionInvocation;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTLiteral;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTMultiplyExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOperatorExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOrExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTRelationalExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTUnaryExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValue;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValuePrefix;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValueSuffix;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserVisitor;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.SimpleNode;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

class ASTSemanticValidator
implements JSPELParserVisitor,
IExpressionSemanticValidator {
    private final IFile _targetFile;
    private final ASTExpression _expr;
    private final IStructuredDocumentContext _context;
    private final ISymbolContextResolver _symbolResolver;
    private final List<IMessage> _messages;
    private final EvaluationTracker _tracker;
    private final DiagnosticFactory _diagnosticFactory;
    private final ELValidationPreferences _prefs;
    private boolean _validatorHasBeenCalled;

    ASTSemanticValidator(ASTExpression expr, IStructuredDocumentContext context, ELValidationPreferences prefs) {
        IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        this._targetFile = resolver != null ? (IFile)resolver.getResource() : null;
        this._expr = expr;
        this._context = context;
        this._symbolResolver = StructuredDocumentSymbolResolverFactory.getInstance().getSymbolContextResolver((IModelContext)this._context);
        this._messages = new ArrayList<IMessage>();
        this._tracker = new EvaluationTracker();
        this._diagnosticFactory = new DiagnosticFactory();
        this._prefs = prefs;
    }

    public void validate() {
        this._expr.jjtAccept((JSPELParserVisitor)this, (Object)this._tracker);
        this._validatorHasBeenCalled = true;
    }

    public Object visit(ASTAddExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTAndExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTChoiceExpression node, Object data) {
        if (node.jjtGetNumChildren() != 3) {
            throw new AssertionError((Object)"Binary operators should always have two sub-expressions");
        }
        node.jjtGetChild(0).jjtAccept((JSPELParserVisitor)this, data);
        ValueType choiceArg = ((EvaluationTracker)data).getValueType();
        node.jjtGetChild(1).jjtAccept((JSPELParserVisitor)this, data);
        ValueType whenTrueArg = ((EvaluationTracker)data).getValueType();
        node.jjtGetChild(2).jjtAccept((JSPELParserVisitor)this, data);
        ValueType whenFalseArg = ((EvaluationTracker)data).getValueType();
        if (choiceArg != null && whenTrueArg != null && whenFalseArg != null) {
            TernaryChoiceOperator operator = new TernaryChoiceOperator(this._diagnosticFactory);
            Diagnostic diagnostic = operator.validate(choiceArg);
            if (diagnostic.getSeverity() != 0) {
                Token firstToken = node.getFirstToken();
                int offset = this._context.getDocumentPosition() + firstToken.beginColumn - 1;
                int length = node.getLastToken().endColumn - firstToken.beginColumn + 1;
                Message message = ValidationMessageFactory.createFromDiagnostic(diagnostic, offset, length, this._targetFile, this._prefs);
                this._messages.add((IMessage)message);
            }
            ((EvaluationTracker)data).setType((SignatureBasedType)operator.perform(choiceArg, whenTrueArg, whenFalseArg));
        } else {
            ((EvaluationTracker)data).setType(null);
        }
        return data;
    }

    public Object visit(ASTEqualityExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTExpression node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTFunctionInvocation node, Object data) {
        Object retVal = node.childrenAccept((JSPELParserVisitor)this, data);
        ((EvaluationTracker)data).setType(null);
        return retVal;
    }

    public Object visit(ASTLiteral node, Object data) {
        if (node.jjtGetNumChildren() > 0) {
            throw new AssertionError((Object)"Literals should be terminal");
        }
        BooleanLiteralType type = null;
        Token literalToken = node.getFirstToken();
        switch (literalToken.kind) {
            case 8: {
                type = new StringLiteralType(this.stripQuotes(literalToken.image));
                break;
            }
            case 5: {
                type = new IntegerLiteralType(Long.parseLong(literalToken.image));
                break;
            }
            case 6: {
                type = new FloatLiteralType(Double.parseDouble(literalToken.image));
                break;
            }
            case 11: {
                type = BooleanLiteralType.FALSE;
                break;
            }
            case 10: {
                type = BooleanLiteralType.TRUE;
                break;
            }
            case 12: {
                type = NullLiteralType.SINGLETON;
                break;
            }
            default: {
                JSFCorePlugin.log("Unknown EL literal: " + literalToken.toString(), new Throwable("This throwable simply used to mark a stack trace"));
            }
        }
        ((EvaluationTracker)data).setType((SignatureBasedType)type);
        return data;
    }

    private String stripQuotes(String stringLiteral) {
        if (stringLiteral.startsWith("'") || stringLiteral.startsWith("\"")) {
            if (stringLiteral.length() > 2) {
                return stringLiteral.substring(1, stringLiteral.length() - 1);
            }
            return "";
        }
        return stringLiteral;
    }

    public Object visit(ASTMultiplyExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTOrExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTRelationalExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        Token firstToken;
        node.childrenAccept((JSPELParserVisitor)this, data);
        SignatureBasedType type = ((EvaluationTracker)data).getType();
        if (type != null && UnaryOperator.isUnaryOperator(firstToken = node.getFirstToken())) {
            if (type instanceof ValueType) {
                UnaryOperator unaryOp = UnaryOperator.createUnaryOperator(firstToken, this._diagnosticFactory);
                Diagnostic diagnostic = unaryOp.validate((ValueType)type);
                if (diagnostic.getSeverity() != 0) {
                    int offset = this._context.getDocumentPosition() + firstToken.beginColumn - 1;
                    int length = node.getLastToken().endColumn - firstToken.beginColumn + 1;
                    Message message = ValidationMessageFactory.createFromDiagnostic(diagnostic, offset, length, this._targetFile, this._prefs);
                    this._messages.add((IMessage)message);
                }
                ((EvaluationTracker)data).setType((SignatureBasedType)unaryOp.performOperation((ValueType)type));
            } else {
                int offset = this._context.getDocumentPosition() + firstToken.beginColumn - 1;
                int length = node.getLastToken().endColumn - firstToken.beginColumn + 1;
                this._messages.add((IMessage)ValidationMessageFactory.createFromDiagnostic(this._diagnosticFactory.create_CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING(), offset, length, this._targetFile, this._prefs));
            }
        }
        return data;
    }

    public Object visit(ASTValue node, Object data) {
        ValueExpressionTracker tracker = new ValueExpressionTracker();
        ((EvaluationTracker)data).setValueTracker(tracker);
        node.childrenAccept((JSPELParserVisitor)this, data);
        SignatureBasedType type = ((EvaluationTracker)data).getType();
        if (type instanceof IObjectSymbolBasedValueType && ((IObjectSymbolBasedValueType)type).getSymbol() instanceof IPropertySymbol && ((IPropertySymbol)((IObjectSymbolBasedValueType)type).getSymbol()).isIntermediate()) {
            int problemStartOffset = tracker.getCurPropertySymbolOffset();
            int length = tracker.getCurPropertySymbolLength();
            this._messages.add((IMessage)ValidationMessageFactory.createFromDiagnostic(this._diagnosticFactory.create_MEMBER_IS_INTERMEDIATE(((IPropertySymbol)((IObjectSymbolBasedValueType)type).getSymbol()).getName()), problemStartOffset, length, this._targetFile, this._prefs));
        }
        return data;
    }

    public Object visit(ASTValuePrefix node, Object data) {
        if (node.jjtGetNumChildren() == 0) {
            Token token = node.getFirstToken();
            String image = token.image;
            ISymbol symbol = this._symbolResolver.getVariable(image);
            if (symbol == null) {
                int problemStartOffset = this._context.getDocumentPosition() + token.beginColumn - 1;
                int length = token.endColumn - token.beginColumn + 1;
                Diagnostic diag = this._diagnosticFactory.create_VARIABLE_NOT_FOUND(image);
                if (diag.getSeverity() != 0) {
                    this._messages.add((IMessage)ValidationMessageFactory.createFromDiagnostic(diag, problemStartOffset, length, this._targetFile, this._prefs));
                }
            } else if (symbol instanceof IInstanceSymbol) {
                IObjectSymbolBasedValueType symbolType = IObjectSymbolBasedValueType.getInstance((ISymbol)symbol);
                ((EvaluationTracker)data).setType((SignatureBasedType)symbolType);
            }
        }
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTValueSuffix node, Object data) {
        ValueExpressionTracker tracker = ((EvaluationTracker)data).getValueTracker();
        SignatureBasedType type = ((EvaluationTracker)data).getType();
        if (type instanceof IObjectSymbolBasedValueType) {
            IObjectSymbolBasedValueType symbolType = (IObjectSymbolBasedValueType)type;
            Token firstToken = node.getFirstToken();
            if (node.jjtGetNumChildren() == 0 && firstToken.kind == 13) {
                Token dotId = node.getLastToken();
                int startOffset = this._context.getDocumentPosition() + dotId.beginColumn - 1;
                int length = dotId.endColumn - dotId.beginColumn + 1;
                DotOperator dotOp = new DotOperator(this._diagnosticFactory, this._targetFile);
                StringLiteralType suffixLiteral = new StringLiteralType(dotId.image);
                Diagnostic diag = dotOp.validate((ValueType)symbolType, (ValueType)suffixLiteral);
                if (diag.getSeverity() != 0) {
                    this._messages.add((IMessage)ValidationMessageFactory.createFromDiagnostic(diag, startOffset, length, this._targetFile, this._prefs));
                    ((EvaluationTracker)data).setType(null);
                } else {
                    ((EvaluationTracker)data).setType(dotOp.performOperation((ValueType)symbolType, (ValueType)suffixLiteral));
                    tracker.setCurMemberSymbol(startOffset, length);
                }
                return data;
            }
            if (firstToken.kind == 30) {
                EvaluationTracker subExprTracker = new EvaluationTracker();
                node.childrenAccept((JSPELParserVisitor)this, (Object)subExprTracker);
                SignatureBasedType subExprType = subExprTracker.getType();
                if (subExprType instanceof ValueType) {
                    Token lastToken = node.getLastToken();
                    int startOffset = this._context.getDocumentPosition() + firstToken.beginColumn - 1;
                    int length = lastToken.endColumn - firstToken.beginColumn + 1;
                    BracketOperator bracketOperator = new BracketOperator(this._diagnosticFactory, this._targetFile);
                    Diagnostic diag = bracketOperator.validate((ValueType)symbolType, (ValueType)subExprType);
                    if (diag.getSeverity() != 0) {
                        this._messages.add((IMessage)ValidationMessageFactory.createFromDiagnostic(diag, startOffset, length, this._targetFile, this._prefs));
                        ((EvaluationTracker)data).setType(null);
                    } else {
                        ((EvaluationTracker)data).setType(bracketOperator.performOperation((ValueType)symbolType, (ValueType)subExprType));
                        tracker.setCurMemberSymbol(startOffset, length);
                    }
                }
                return data;
            }
        }
        ((EvaluationTracker)data).setType(null);
        return data;
    }

    public Object visit(SimpleNode node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public void reportFindings(IValidator validator, IReporter reporter) {
        for (IMessage message : this._messages) {
            if ((message.getSeverity() & 7) == 0) continue;
            reporter.addMessage(validator, message);
        }
    }

    private void performBinaryEvaluation(ASTOperatorExpression node, EvaluationTracker tracker) {
        if (node.jjtGetNumChildren() < 2) {
            throw new AssertionError((Object)"Binary operators should always have at least two sub-expressions");
        }
        if (node.getOperatorTokens().size() != node.jjtGetNumChildren() - 1) {
            throw new AssertionError((Object)"Binary operators should always have one operator token less than number of sub-expressions");
        }
        node.jjtGetChild(0).jjtAccept((JSPELParserVisitor)this, (Object)tracker);
        ValueType curType = this.getValueTypeForBinaryOperation(tracker.getType(), (SimpleNode)node.jjtGetChild(0));
        int child = 1;
        while (child < node.jjtGetNumChildren()) {
            node.jjtGetChild(child).jjtAccept((JSPELParserVisitor)this, (Object)tracker);
            ValueType secondType = this.getValueTypeForBinaryOperation(tracker.getType(), (SimpleNode)node.jjtGetChild(child));
            if (curType != null && secondType != null) {
                BinaryOperator operator = BinaryOperator.getBinaryOperator((Token)node.getOperatorTokens().get(child - 1), this._diagnosticFactory, this._context);
                Diagnostic diagnostic = operator.validate(curType, secondType);
                if (diagnostic.getSeverity() != 0) {
                    Token firstToken = node.getFirstToken();
                    int offset = this._context.getDocumentPosition() + firstToken.beginColumn - 1;
                    int length = node.getLastToken().endColumn - firstToken.beginColumn + 1;
                    Message message = ValidationMessageFactory.createFromDiagnostic(diagnostic, offset, length, this._targetFile, this._prefs);
                    this._messages.add((IMessage)message);
                }
                curType = operator.performOperation(curType, secondType);
            }
            ++child;
        }
        tracker.setType((SignatureBasedType)curType);
    }

    private ValueType getValueTypeForBinaryOperation(SignatureBasedType type, SimpleNode node) {
        if (type instanceof ValueType) {
            return (ValueType)type;
        }
        if (type instanceof MethodType) {
            int offset = this._context.getDocumentPosition() + node.getFirstToken().beginColumn - 1;
            int length = node.getLastToken().endColumn - node.getFirstToken().beginColumn + 1;
            this._messages.add((IMessage)ValidationMessageFactory.createFromDiagnostic(this._diagnosticFactory.create_CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING(), offset, length, this._targetFile, this._prefs));
        }
        return null;
    }

    public List getMessages() {
        if (!this._validatorHasBeenCalled) {
            throw new AssertionError((Object)"Should not call getMessages before validate has been called");
        }
        return this._messages;
    }

    public SignatureBasedType getExpressionType() {
        return this._tracker.getType();
    }

    public static void main(String[] args) throws IOException, ParseException {
        int nextCharacter;
        String elText = "";
        while ((nextCharacter = System.in.read()) != -1) {
            char nextChar = (char)nextCharacter;
            if (nextChar == '\n') {
                JSPELParser parser = JSPELParser.createParser((String)elText);
                ASTExpression expr = parser.Expression();
                expr.dump("");
                elText = "";
                continue;
            }
            elText = String.valueOf(elText) + nextChar;
        }
    }
}

