/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.ui.internal.IJpaPlatformUi;
import org.eclipse.jpt.ui.internal.JptUiPlugin;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

public class PlatformRegistry {
    public static final PlatformRegistry INSTANCE = new PlatformRegistry();
    private static final String EXTENSION_ID = "jpaPlatform";
    private static final String EL_PLATFORM = "jpaPlatform";
    private static final String AT_ID = "id";
    private static final String AT_CLASS = "class";
    private Map<String, IConfigurationElement> jpaPlatforms;

    private PlatformRegistry() {
        this.buildJpaPlatforms();
    }

    private void buildJpaPlatforms() {
        this.jpaPlatforms = new HashMap<String, IConfigurationElement>();
        Iterator stream = this.allConfigElements();
        while (stream.hasNext()) {
            this.buildJpaPlatform((IConfigurationElement)stream.next());
        }
    }

    private void buildJpaPlatform(IConfigurationElement configElement) {
        if (!configElement.getName().equals("jpaPlatform")) {
            return;
        }
        String platformId = configElement.getAttribute(AT_ID);
        String platformClass = configElement.getAttribute(AT_CLASS);
        if (platformId == null || platformClass == null) {
            if (platformId == null) {
                this.reportMissingAttribute(configElement, AT_ID);
            }
            if (platformClass == null) {
                this.reportMissingAttribute(configElement, AT_CLASS);
            }
            return;
        }
        if (this.jpaPlatforms.containsKey(platformId)) {
            IConfigurationElement otherConfigElement = this.jpaPlatforms.get(platformId);
            this.reportDuplicatePlatform(configElement, otherConfigElement);
        }
        this.jpaPlatforms.put(platformId, configElement);
    }

    public IJpaPlatformUi getJpaPlatform(String vendorId) {
        IConfigurationElement registeredConfigElement = this.jpaPlatforms.get(vendorId);
        if (registeredConfigElement == null) {
            return null;
        }
        try {
            return (IJpaPlatformUi)registeredConfigElement.createExecutableExtension(AT_CLASS);
        }
        catch (CoreException coreException) {
            this.reportFailedInstantiation(registeredConfigElement);
            return null;
        }
    }

    private Iterator allConfigElements() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.jpt.ui", "jpaPlatform");
        Object[] extensions = extensionPoint.getExtensions();
        return new CompositeIterator((Iterator)new TransformationIterator(CollectionTools.iterator((Object[])extensions)){

            protected Object transform(Object next) {
                return CollectionTools.iterator((Object[])((IExtension)next).getConfigurationElements());
            }
        });
    }

    private void reportMissingAttribute(IConfigurationElement configElement, String attributeName) {
        String message = "An extension element \"" + configElement.getName() + "\" in plugin \"" + configElement.getContributor().getName() + "\" is missing a required attribute \"" + attributeName + "\".";
        JptUiPlugin.log(message);
    }

    private void reportDuplicatePlatform(IConfigurationElement oneConfigElement, IConfigurationElement otherConfigElement) {
        String message = "The plugins \"" + oneConfigElement.getContributor().getName() + "\" and \"" + otherConfigElement.getContributor().getName() + "\" have registered a duplicate attribute \"id\" " + "for the extension element \"jpaVendor\".";
        JptUiPlugin.log(message);
    }

    private void reportFailedInstantiation(IConfigurationElement configElement) {
        String message = "Could not instantiate the class \"" + configElement.getAttribute(AT_CLASS) + "\" for the extension element \"" + configElement.getName() + "\" in the plugin \"" + configElement.getContributor().getName() + "\".";
        JptUiPlugin.log(message);
    }
}

