/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.widgets.CComboViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class StringWithDefaultChooser
extends BaseJpaController {
    private StringHolder stringHolder;
    private Adapter stringHolderListener;
    private CComboViewer comboViewer;
    private static final String DEFAULT = "default";

    public StringWithDefaultChooser(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
        this.buildStringHolderListener();
    }

    private void buildStringHolderListener() {
        this.stringHolderListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                StringWithDefaultChooser.this.stringHolderChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        this.comboViewer = new CComboViewer(combo);
        this.comboViewer.setContentProvider(this.buildContentProvider());
        this.comboViewer.setLabelProvider(this.buildLabelProvider());
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StringWithDefaultChooser.this.selectionChanged(event.getSelection());
            }
        });
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StringWithDefaultChooser.this.comboModified(e);
            }
        });
    }

    private IContentProvider buildContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return new String[]{StringWithDefaultChooser.DEFAULT};
            }
        };
    }

    private IBaseLabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element == StringWithDefaultChooser.DEFAULT && StringWithDefaultChooser.this.stringHolder.wrappedObject() != null) {
                    return StringWithDefaultChooser.this.stringHolder.defaultItem();
                }
                return super.getText(element);
            }
        };
    }

    void selectionChanged(ISelection sel) {
        if (this.isPopulating()) {
            return;
        }
        if (sel instanceof IStructuredSelection) {
            String selection = (String)((IStructuredSelection)sel).getFirstElement();
            if (this.comboViewer.getCombo().getSelectionIndex() == 0) {
                selection = null;
            }
            if (this.stringHolder.getString() == null) {
                if (selection != null) {
                    this.stringHolder.setString(selection);
                }
            } else if (!this.stringHolder.getString().equals(selection)) {
                this.stringHolder.setString(selection);
            }
        }
    }

    private void comboModified(ModifyEvent e) {
        if (this.isPopulating()) {
            return;
        }
        CCombo combo = (CCombo)e.getSource();
        combo.getSelectionIndex();
        String text = combo.getText();
        if (text != null && combo.getItemCount() > 0 && text.equals(combo.getItem(0))) {
            text = null;
        }
        if (this.stringHolder.getString() != text) {
            this.stringHolder.setString(text);
        }
    }

    private void stringHolderChanged(Notification notification) {
        if (notification.getFeatureID(this.stringHolder.featureClass()) == this.stringHolder.featureId()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (StringWithDefaultChooser.this.getCombo().isDisposed()) {
                        return;
                    }
                    StringWithDefaultChooser.this.populate();
                }
            });
        } else if (this.stringHolder.supportsDefault() && notification.getFeatureID(this.stringHolder.featureClass()) == this.stringHolder.defaultFeatureId()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (StringWithDefaultChooser.this.getCombo().isDisposed()) {
                        return;
                    }
                    StringWithDefaultChooser.this.populate();
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.stringHolder != null && this.stringHolder.wrappedObject() != null) {
            this.stringHolder.wrappedObject().eAdapters().add((Object)this.stringHolderListener);
        }
    }

    protected void disengageListeners() {
        if (this.stringHolder != null && this.stringHolder.wrappedObject() != null) {
            this.stringHolder.wrappedObject().eAdapters().remove((Object)this.stringHolderListener);
        }
    }

    public void doPopulate(EObject obj) {
        this.stringHolder = (StringHolder)obj;
        this.comboViewer.setInput(this.stringHolder);
        this.populateCombo();
    }

    protected void doPopulate() {
        this.populateCombo();
    }

    private void populateCombo() {
        if (this.stringHolder.wrappedObject() == null) {
            this.comboViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            return;
        }
        this.comboViewer.update(this.comboViewer.getElementAt(0), null);
        String string = this.stringHolder.getString();
        if (string == null) {
            if (((StructuredSelection)this.comboViewer.getSelection()).getFirstElement() == DEFAULT) {
                this.comboViewer.refresh();
            } else {
                this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)DEFAULT));
            }
        } else if (!this.comboViewer.getCombo().getText().equals(string)) {
            this.comboViewer.getCombo().setText(string);
        }
    }

    public CCombo getCombo() {
        return this.comboViewer.getCombo();
    }

    public Control getControl() {
        return this.getCombo();
    }

    public static interface StringHolder
    extends EObject {
        public String getString();

        public void setString(String var1);

        public Class featureClass();

        public int featureId();

        public boolean supportsDefault();

        public int defaultFeatureId();

        public EObject wrappedObject();

        public String defaultItem();
    }
}

