/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.xml.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.content.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlPersistentAttribute;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class XmlJavaAttributeChooser
extends BaseJpaController {
    private XmlPersistentAttribute attribute;
    private Adapter persistentAttributeListener;
    private Text text;

    public XmlJavaAttributeChooser(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
        this.buildPersistentAttributeListener();
    }

    private void buildPersistentAttributeListener() {
        this.persistentAttributeListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                XmlJavaAttributeChooser.this.persistentAttributeChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        this.text = this.getWidgetFactory().createText(parent, "");
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XmlJavaAttributeChooser.this.textModified(e);
            }
        });
    }

    private void textModified(ModifyEvent e) {
        if (this.isPopulating()) {
            return;
        }
        String text = ((Text)e.getSource()).getText();
        this.attribute.setName(text);
    }

    private void persistentAttributeChanged(Notification notification) {
        if (notification.getFeatureID(XmlAttributeMapping.class) == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    XmlJavaAttributeChooser.this.populate();
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.attribute != null) {
            this.attribute.eAdapters().add((Object)this.persistentAttributeListener);
        }
    }

    protected void disengageListeners() {
        if (this.attribute != null) {
            this.attribute.eAdapters().remove((Object)this.persistentAttributeListener);
        }
    }

    public void doPopulate(EObject obj) {
        this.attribute = obj == null ? null : ((XmlAttributeMapping)obj).getPersistentAttribute();
        this.populateText();
    }

    protected void doPopulate() {
        this.populateText();
    }

    private void populateText() {
        if (this.attribute == null) {
            this.text.clearSelection();
            return;
        }
        String name = this.attribute.getName();
        if (name == null) {
            name = "";
        }
        this.setTextData(name);
    }

    private void setTextData(String textData) {
        if (!textData.equals(this.text.getText())) {
            this.text.setText(textData);
        }
    }

    public Control getControl() {
        return this.text;
    }
}

