/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.xml.details;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jpt.core.internal.content.orm.EntityMappings;
import org.eclipse.jpt.core.internal.content.orm.EntityMappingsInternal;
import org.eclipse.jpt.ui.internal.JptUiPlugin;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.xml.JptUiXmlMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class XmlPackageChooser
extends BaseJpaController {
    private EntityMappingsInternal entityMappings;
    private Adapter entityMappingsListener;
    private IContentAssistProcessor contentAssistProcessor;
    private Composite composite;
    private Text text;

    public XmlPackageChooser(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
        this.buildSchemaHolderListener();
    }

    private void buildSchemaHolderListener() {
        this.entityMappingsListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                XmlPackageChooser.this.entityMappingsChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        this.composite = this.getWidgetFactory().createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 1;
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        this.text = this.getWidgetFactory().createText(this.composite, "");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.text.setLayoutData((Object)data);
        this.contentAssistProcessor = new JavaPackageCompletionProcessor((ILabelProvider)new JavaElementLabelProvider(64));
        ControlContentAssistHelper.createTextContentAssistant((Text)this.text, (IContentAssistProcessor)this.contentAssistProcessor);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XmlPackageChooser.this.textModified(e);
            }
        });
        Button browseButton = this.getWidgetFactory().createButton(this.composite, "Browse...", 0x800000);
        data = new GridData();
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment packageFragment = XmlPackageChooser.this.choosePackage();
                if (packageFragment != null) {
                    XmlPackageChooser.this.text.setText(packageFragment.getElementName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IPackageFragment packageFragment = XmlPackageChooser.this.choosePackage();
                if (packageFragment != null) {
                    XmlPackageChooser.this.text.setText(packageFragment.getElementName());
                }
            }
        });
    }

    private void textModified(ModifyEvent e) {
        if (this.isPopulating()) {
            return;
        }
        String text = ((Text)e.getSource()).getText();
        this.entityMappings.setPackage(text);
    }

    private void entityMappingsChanged(Notification notification) {
        if (notification.getFeatureID(EntityMappings.class) == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    XmlPackageChooser.this.populate();
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.entityMappings != null) {
            this.entityMappings.eAdapters().add((Object)this.entityMappingsListener);
        }
    }

    protected void disengageListeners() {
        if (this.entityMappings != null) {
            this.entityMappings.eAdapters().remove((Object)this.entityMappingsListener);
        }
    }

    public void doPopulate(EObject obj) {
        this.entityMappings = (EntityMappingsInternal)obj;
        this.populateText();
    }

    protected void doPopulate() {
        this.populateText();
    }

    private void populateText() {
        String package_;
        if (this.entityMappings == null) {
            this.text.clearSelection();
            return;
        }
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            ((JavaPackageCompletionProcessor)this.contentAssistProcessor).setPackageFragmentRoot(root);
        }
        if ((package_ = this.entityMappings.getPackage()) == null) {
            this.setTextData("");
        } else {
            this.setTextData(package_);
        }
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        IProject project = this.entityMappings.getJpaProject().getProject();
        IJavaProject root = JavaCore.create((IProject)project);
        try {
            return root.getAllPackageFragmentRoots()[0];
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            return null;
        }
    }

    private void setTextData(String textData) {
        if (!textData.equals(this.text.getText())) {
            this.text.setText(textData);
        }
    }

    public Control getControl() {
        return this.composite;
    }

    protected IPackageFragment choosePackage() {
        SelectionDialog selectionDialog;
        try {
            selectionDialog = JavaUI.createPackageDialog((Shell)this.text.getShell(), (IPackageFragmentRoot)this.getPackageFragmentRoot());
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            throw new RuntimeException(e);
        }
        selectionDialog.setTitle(JptUiXmlMessages.XmlPackageChooser_PackageDialog_title);
        selectionDialog.setMessage(JptUiXmlMessages.XmlPackageChooser_PackageDialog_message);
        selectionDialog.setHelpAvailable(false);
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            selectionDialog.setInitialSelections(new Object[]{pack});
        }
        if (selectionDialog.open() == 0) {
            return (IPackageFragment)selectionDialog.getResult()[0];
        }
        return null;
    }

    public IPackageFragment getPackageFragment() {
        String packageString = this.text.getText();
        return this.getPackageFragmentRoot().getPackageFragment(packageString);
    }
}

