/*******************************************************************************
 * Copyright (c) 2004, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.javascript.core.internal.jsparser.node;



/* This file was generated by SableCC (http://www.sablecc.org/). */
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Node implements Switchable, Cloneable {

	private Node parent;

	public abstract Object clone();

	protected List cloneList(List list) {
		List clone = new LinkedList();

		for (Iterator i = list.iterator(); i.hasNext();) {
			clone.add(((Node) i.next()).clone());
		}

		return clone;
	}

	protected Node cloneNode(Node node) {
		if (node != null) {
			return (Node) node.clone();
		}

		return null;
	}

	public Node parent() {
		return parent;
	}

	void parent(Node parent) {
		this.parent = parent;
	}

	abstract void removeChild(Node child);

	public void replaceBy(Node node) {
		if (parent != null) {
			parent.replaceChild(this, node);
		}
	}

	abstract void replaceChild(Node oldChild, Node newChild);

	protected String toString(Node node) {
		if (node != null) {
			return node.toString();
		}

		return "";//$NON-NLS-1$
	}

	protected String toString(List list) {
		StringBuffer s = new StringBuffer();

		for (Iterator i = list.iterator(); i.hasNext();) {
			s.append(i.next());
		}

		return s.toString();
	}
}
