/***************************************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM Corporation - initial API and implementation
 *   Oracle Corporation - revision
 **************************************************************************************************/
package org.eclipse.jst.jsf.facesconfig.emf;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage
 * @generated
 */
public interface FacesConfigFactory extends EFactory {
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String copyright = "Copyright (c) 2005, 2006 IBM Corporation and others";

    /**
     * The singleton instance of the factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	FacesConfigFactory eINSTANCE = org.eclipse.jst.jsf.facesconfig.emf.impl.FacesConfigFactoryImpl.init();

    /**
     * Returns a new object of class '<em>Action Listener Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Action Listener Type</em>'.
     * @generated
     */
	ActionListenerType createActionListenerType();

    /**
     * Returns a new object of class '<em>Application Factory Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Application Factory Type</em>'.
     * @generated
     */
	ApplicationFactoryType createApplicationFactoryType();

    /**
     * Returns a new object of class '<em>Application Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Application Type</em>'.
     * @generated
     */
	ApplicationType createApplicationType();

    /**
     * Returns a new object of class '<em>Attribute Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Attribute Class Type</em>'.
     * @generated
     */
	AttributeClassType createAttributeClassType();

    /**
     * Returns a new object of class '<em>Attribute Extension Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Attribute Extension Type</em>'.
     * @generated
     */
	AttributeExtensionType createAttributeExtensionType();

    /**
     * Returns a new object of class '<em>Attribute Name Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Attribute Name Type</em>'.
     * @generated
     */
	AttributeNameType createAttributeNameType();

    /**
     * Returns a new object of class '<em>Attribute Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Attribute Type</em>'.
     * @generated
     */
	AttributeType createAttributeType();

    /**
     * Returns a new object of class '<em>Component Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Component Class Type</em>'.
     * @generated
     */
	ComponentClassType createComponentClassType();

    /**
     * Returns a new object of class '<em>Component Extension Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Component Extension Type</em>'.
     * @generated
     */
	ComponentExtensionType createComponentExtensionType();

    /**
     * Returns a new object of class '<em>Component Family Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Component Family Type</em>'.
     * @generated
     */
	ComponentFamilyType createComponentFamilyType();

    /**
     * Returns a new object of class '<em>Component Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Component Type</em>'.
     * @generated
     */
	ComponentType createComponentType();

    /**
     * Returns a new object of class '<em>Component Type Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Component Type Type</em>'.
     * @generated
     */
	ComponentTypeType createComponentTypeType();

    /**
     * Returns a new object of class '<em>Converter Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Converter Class Type</em>'.
     * @generated
     */
	ConverterClassType createConverterClassType();

    /**
     * Returns a new object of class '<em>Converter For Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Converter For Class Type</em>'.
     * @generated
     */
	ConverterForClassType createConverterForClassType();

    /**
     * Returns a new object of class '<em>Converter Id Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Converter Id Type</em>'.
     * @generated
     */
	ConverterIdType createConverterIdType();

    /**
     * Returns a new object of class '<em>Converter Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Converter Type</em>'.
     * @generated
     */
	ConverterType createConverterType();

    /**
     * Returns a new object of class '<em>Default Locale Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Default Locale Type</em>'.
     * @generated
     */
	DefaultLocaleType createDefaultLocaleType();

    /**
     * Returns a new object of class '<em>Default Render Kit Id Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Default Render Kit Id Type</em>'.
     * @generated
     */
	DefaultRenderKitIdType createDefaultRenderKitIdType();

    /**
     * Returns a new object of class '<em>Default Value Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Default Value Type</em>'.
     * @generated
     */
	DefaultValueType createDefaultValueType();

    /**
     * Returns a new object of class '<em>Description Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Description Type</em>'.
     * @generated
     */
	DescriptionType createDescriptionType();

    /**
     * Returns a new object of class '<em>Display Name Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Display Name Type</em>'.
     * @generated
     */
	DisplayNameType createDisplayNameType();

    /**
     * Returns a new object of class '<em>Document Root</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Document Root</em>'.
     * @generated
     */
	DocumentRoot createDocumentRoot();

    /**
     * Returns a new object of class '<em>Dynamic Attribute</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Dynamic Attribute</em>'.
     * @generated
     */
    DynamicAttribute createDynamicAttribute();

    /**
     * Returns a new object of class '<em>Dynamic Element</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Dynamic Element</em>'.
     * @generated
     */
    DynamicElement createDynamicElement();

    /**
     * Returns a new object of class '<em>EL Resolver Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>EL Resolver Type</em>'.
     * @generated
     */
    ELResolverType createELResolverType();

    /**
     * Returns a new object of class '<em>Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Type</em>'.
     * @generated
     */
	FacesConfigType createFacesConfigType();

    /**
     * Returns a new object of class '<em>Faces Context Factory Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Faces Context Factory Type</em>'.
     * @generated
     */
	FacesContextFactoryType createFacesContextFactoryType();

    /**
     * Returns a new object of class '<em>Facet Extension Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Facet Extension Type</em>'.
     * @generated
     */
	FacetExtensionType createFacetExtensionType();

    /**
     * Returns a new object of class '<em>Facet Name Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Facet Name Type</em>'.
     * @generated
     */
	FacetNameType createFacetNameType();

    /**
     * Returns a new object of class '<em>Facet Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Facet Type</em>'.
     * @generated
     */
	FacetType createFacetType();

    /**
     * Returns a new object of class '<em>Factory Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Factory Type</em>'.
     * @generated
     */
	FactoryType createFactoryType();

    /**
     * Returns a new object of class '<em>From Action Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>From Action Type</em>'.
     * @generated
     */
	FromActionType createFromActionType();

    /**
     * Returns a new object of class '<em>From Outcome Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>From Outcome Type</em>'.
     * @generated
     */
	FromOutcomeType createFromOutcomeType();

    /**
     * Returns a new object of class '<em>From View Id Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>From View Id Type</em>'.
     * @generated
     */
	FromViewIdType createFromViewIdType();

    /**
     * Returns a new object of class '<em>Icon Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Icon Type</em>'.
     * @generated
     */
	IconType createIconType();

    /**
     * Returns a new object of class '<em>Key Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Key Class Type</em>'.
     * @generated
     */
	KeyClassType createKeyClassType();

    /**
     * Returns a new object of class '<em>Key Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Key Type</em>'.
     * @generated
     */
	KeyType createKeyType();

    /**
     * Returns a new object of class '<em>Large Icon Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Large Icon Type</em>'.
     * @generated
     */
	LargeIconType createLargeIconType();

    /**
     * Returns a new object of class '<em>Lifecycle Factory Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Lifecycle Factory Type</em>'.
     * @generated
     */
	LifecycleFactoryType createLifecycleFactoryType();

    /**
     * Returns a new object of class '<em>Lifecycle Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Lifecycle Type</em>'.
     * @generated
     */
	LifecycleType createLifecycleType();

    /**
     * Returns a new object of class '<em>List Entries Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>List Entries Type</em>'.
     * @generated
     */
	ListEntriesType createListEntriesType();

    /**
     * Returns a new object of class '<em>Locale Config Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Locale Config Type</em>'.
     * @generated
     */
	LocaleConfigType createLocaleConfigType();

    /**
     * Returns a new object of class '<em>Managed Bean Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Managed Bean Class Type</em>'.
     * @generated
     */
	ManagedBeanClassType createManagedBeanClassType();

    /**
     * Returns a new object of class '<em>Managed Bean Name Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Managed Bean Name Type</em>'.
     * @generated
     */
	ManagedBeanNameType createManagedBeanNameType();

    /**
     * Returns a new object of class '<em>Managed Bean Scope Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Managed Bean Scope Type</em>'.
     * @generated
     */
	ManagedBeanScopeType createManagedBeanScopeType();

    /**
     * Returns a new object of class '<em>Managed Bean Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Managed Bean Type</em>'.
     * @generated
     */
	ManagedBeanType createManagedBeanType();

    /**
     * Returns a new object of class '<em>Managed Property Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Managed Property Type</em>'.
     * @generated
     */
	ManagedPropertyType createManagedPropertyType();

    /**
     * Returns a new object of class '<em>Map Entries Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Map Entries Type</em>'.
     * @generated
     */
	MapEntriesType createMapEntriesType();

    /**
     * Returns a new object of class '<em>Map Entry Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Map Entry Type</em>'.
     * @generated
     */
	MapEntryType createMapEntryType();

    /**
     * Returns a new object of class '<em>Message Bundle Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Message Bundle Type</em>'.
     * @generated
     */
	MessageBundleType createMessageBundleType();

    /**
     * Returns a new object of class '<em>Navigation Case Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Navigation Case Type</em>'.
     * @generated
     */
	NavigationCaseType createNavigationCaseType();

    /**
     * Returns a new object of class '<em>Navigation Handler Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Navigation Handler Type</em>'.
     * @generated
     */
	NavigationHandlerType createNavigationHandlerType();

    /**
     * Returns a new object of class '<em>Navigation Rule Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Navigation Rule Type</em>'.
     * @generated
     */
	NavigationRuleType createNavigationRuleType();

    /**
     * Returns a new object of class '<em>Null Value Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Null Value Type</em>'.
     * @generated
     */
	NullValueType createNullValueType();

    /**
     * Returns a new object of class '<em>Phase Listener Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Phase Listener Type</em>'.
     * @generated
     */
	PhaseListenerType createPhaseListenerType();

    /**
     * Returns a new object of class '<em>Property Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Property Class Type</em>'.
     * @generated
     */
	PropertyClassType createPropertyClassType();

    /**
     * Returns a new object of class '<em>Property Extension Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Property Extension Type</em>'.
     * @generated
     */
	PropertyExtensionType createPropertyExtensionType();

    /**
     * Returns a new object of class '<em>Property Name Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Property Name Type</em>'.
     * @generated
     */
	PropertyNameType createPropertyNameType();

    /**
     * Returns a new object of class '<em>Property Resolver Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Property Resolver Type</em>'.
     * @generated
     */
	PropertyResolverType createPropertyResolverType();

    /**
     * Returns a new object of class '<em>Property Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Property Type</em>'.
     * @generated
     */
	PropertyType createPropertyType();

    /**
     * Returns a new object of class '<em>Redirect Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Redirect Type</em>'.
     * @generated
     */
	RedirectType createRedirectType();

    /**
     * Returns a new object of class '<em>Referenced Bean Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Referenced Bean Class Type</em>'.
     * @generated
     */
	ReferencedBeanClassType createReferencedBeanClassType();

    /**
     * Returns a new object of class '<em>Referenced Bean Name Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Referenced Bean Name Type</em>'.
     * @generated
     */
	ReferencedBeanNameType createReferencedBeanNameType();

    /**
     * Returns a new object of class '<em>Referenced Bean Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Referenced Bean Type</em>'.
     * @generated
     */
	ReferencedBeanType createReferencedBeanType();

    /**
     * Returns a new object of class '<em>Renderer Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Renderer Class Type</em>'.
     * @generated
     */
	RendererClassType createRendererClassType();

    /**
     * Returns a new object of class '<em>Renderer Extension Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Renderer Extension Type</em>'.
     * @generated
     */
	RendererExtensionType createRendererExtensionType();

    /**
     * Returns a new object of class '<em>Renderer Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Renderer Type</em>'.
     * @generated
     */
	RendererType createRendererType();

    /**
     * Returns a new object of class '<em>Renderer Type Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Renderer Type Type</em>'.
     * @generated
     */
	RendererTypeType createRendererTypeType();

    /**
     * Returns a new object of class '<em>Render Kit Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Render Kit Class Type</em>'.
     * @generated
     */
	RenderKitClassType createRenderKitClassType();

    /**
     * Returns a new object of class '<em>Render Kit Factory Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Render Kit Factory Type</em>'.
     * @generated
     */
	RenderKitFactoryType createRenderKitFactoryType();

    /**
     * Returns a new object of class '<em>Render Kit Id Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Render Kit Id Type</em>'.
     * @generated
     */
	RenderKitIdType createRenderKitIdType();

    /**
     * Returns a new object of class '<em>Render Kit Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Render Kit Type</em>'.
     * @generated
     */
	RenderKitType createRenderKitType();

    /**
     * Returns a new object of class '<em>Small Icon Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Small Icon Type</em>'.
     * @generated
     */
	SmallIconType createSmallIconType();

    /**
     * Returns a new object of class '<em>State Manager Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>State Manager Type</em>'.
     * @generated
     */
	StateManagerType createStateManagerType();

    /**
     * Returns a new object of class '<em>Suggested Value Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Suggested Value Type</em>'.
     * @generated
     */
	SuggestedValueType createSuggestedValueType();

    /**
     * Returns a new object of class '<em>Supported Locale Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Supported Locale Type</em>'.
     * @generated
     */
	SupportedLocaleType createSupportedLocaleType();

    /**
     * Returns a new object of class '<em>To View Id Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>To View Id Type</em>'.
     * @generated
     */
	ToViewIdType createToViewIdType();

    /**
     * Returns a new object of class '<em>Validator Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Validator Class Type</em>'.
     * @generated
     */
	ValidatorClassType createValidatorClassType();

    /**
     * Returns a new object of class '<em>Validator Id Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Validator Id Type</em>'.
     * @generated
     */
	ValidatorIdType createValidatorIdType();

    /**
     * Returns a new object of class '<em>Validator Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Validator Type</em>'.
     * @generated
     */
	ValidatorType createValidatorType();

    /**
     * Returns a new object of class '<em>Value Class Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Value Class Type</em>'.
     * @generated
     */
	ValueClassType createValueClassType();

    /**
     * Returns a new object of class '<em>Value Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Value Type</em>'.
     * @generated
     */
	ValueType createValueType();

    /**
     * Returns a new object of class '<em>Variable Resolver Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>Variable Resolver Type</em>'.
     * @generated
     */
	VariableResolverType createVariableResolverType();

    /**
     * Returns a new object of class '<em>View Handler Type</em>'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return a new object of class '<em>View Handler Type</em>'.
     * @generated
     */
	ViewHandlerType createViewHandlerType();

    /**
     * Returns a new object of class '<em>Application Extension Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Application Extension Type</em>'.
     * @generated
     */
    ApplicationExtensionType createApplicationExtensionType();

    /**
     * Returns a new object of class '<em>Resource Bundle Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Resource Bundle Type</em>'.
     * @generated
     */
    ResourceBundleType createResourceBundleType();

    /**
     * Returns a new object of class '<em>Base Name Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Base Name Type</em>'.
     * @generated
     */
    BaseNameType createBaseNameType();

    /**
     * Returns a new object of class '<em>Var Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Var Type</em>'.
     * @generated
     */
    VarType createVarType();

    /**
     * Returns a new object of class '<em>Render Kit Extension Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Render Kit Extension Type</em>'.
     * @generated
     */
    RenderKitExtensionType createRenderKitExtensionType();

    /**
     * Returns a new object of class '<em>Navigation Rule Extension Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Navigation Rule Extension Type</em>'.
     * @generated
     */
    NavigationRuleExtensionType createNavigationRuleExtensionType();

    /**
     * Returns a new object of class '<em>Validator Extension Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Validator Extension Type</em>'.
     * @generated
     */
    ValidatorExtensionType createValidatorExtensionType();

    /**
     * Returns a new object of class '<em>Extension Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Extension Type</em>'.
     * @generated
     */
    FacesConfigExtensionType createFacesConfigExtensionType();

    /**
     * Returns a new object of class '<em>Factory Extension Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Factory Extension Type</em>'.
     * @generated
     */
    FactoryExtensionType createFactoryExtensionType();

    /**
     * Returns a new object of class '<em>Lifecycle Extension Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Lifecycle Extension Type</em>'.
     * @generated
     */
    LifecycleExtensionType createLifecycleExtensionType();

    /**
     * Returns a new object of class '<em>Managed Bean Extension Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Managed Bean Extension Type</em>'.
     * @generated
     */
    ManagedBeanExtensionType createManagedBeanExtensionType();

    /**
     * Returns a new object of class '<em>Converter Extension Type</em>'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Converter Extension Type</em>'.
     * @generated
     */
    ConverterExtensionType createConverterExtensionType();

    /**
     * Returns the package supported by this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the package supported by this factory.
     * @generated
     */
	FacesConfigPackage getFacesConfigPackage();

} //FacesConfigFactory
