/*******************************************************************************
 * Copyright (c) 2007 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.ui.internal;

import java.util.Collection;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.ui.internal.details.IJpaDetailsProvider;
import org.eclipse.jpt.ui.internal.structure.IJpaStructureProvider;

public interface IJpaPlatformUi
{
	Collection<IJpaStructureProvider> structureProviders();
	
	Collection<IJpaDetailsProvider> detailsProviders();
	
	void generateDDL(IJpaProject project, IStructuredSelection selection);
	
	void generateEntities(IJpaProject project, IStructuredSelection selection);
}
