/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.ui.DelegatingValidatorPreferencesDialog;
import org.eclipse.wst.validation.internal.ui.ResourceHandler;
import org.eclipse.wst.validation.internal.ui.ValidationPropertiesPage;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;

public class ValidationPropertiesPage
extends PropertyPage {
    static final String NEWLINE = System.getProperty("line.separator");
    static final String TAB = "\t";
    static final String NEWLINE_AND_TAB = String.valueOf(NEWLINE) + "\t";
    private IValidationPage _pageImpl = null;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        IProject project = this.getProject();
        if (project == null || !project.isOpen()) {
            this._pageImpl = new InvalidPage(parent);
        } else {
            try {
                this._pageImpl = ConfigurationManager.getManager().getProjectConfiguration(project).numberOfValidators() == 0 ? new NoValidatorsPage(parent) : new ValidatorListPage(parent);
            }
            catch (InvocationTargetException exc) {
                this._pageImpl = new InvalidPage(parent);
                this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            }
            catch (Exception exc) {
                this._pageImpl = new InvalidPage(parent);
                this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            }
        }
        return this._pageImpl.getControl();
    }

    public void dispose() {
        super.dispose();
        try {
            this._pageImpl.dispose();
        }
        catch (Exception exc) {
            this.logError(exc);
        }
    }

    public IProject getProject() {
        Object adaptedObject;
        IAdaptable selectedElement = this.getElement();
        if (selectedElement == null) {
            return null;
        }
        if (selectedElement instanceof IProject) {
            return (IProject)selectedElement;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adaptedObject = selectedElement.getAdapter((Class)clazz)) instanceof IProject) {
            return (IProject)adaptedObject;
        }
        return null;
    }

    protected void noDefaultAndApplyButton() {
        super.noDefaultAndApplyButton();
    }

    protected void performDefaults() {
        super.performDefaults();
        try {
            this._pageImpl.performDefaults();
        }
        catch (InvocationTargetException exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
        catch (Exception exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
    }

    public boolean performCancel() {
        this._pageImpl.performCancel();
        return true;
    }

    public boolean performOk() {
        try {
            return this._pageImpl.performOk();
        }
        catch (InvocationTargetException exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            return false;
        }
        catch (Exception exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            return false;
        }
    }

    void logError(Throwable exc) {
        Logger logger = WTPUIPlugin.getLogger();
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry entry = ValidationUIPlugin.getLogEntry();
            entry.setSourceIdentifier("ValidationPropertiesPage.displayAndLogError");
            entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL_PAGE");
            entry.setTargetException(exc);
            logger.write(Level.SEVERE, (Object)entry);
            if (exc instanceof InvocationTargetException && ((InvocationTargetException)exc).getTargetException() != null) {
                entry.setTargetException(((InvocationTargetException)exc).getTargetException());
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    void displayAndLogError(String title, String message, Throwable exc) {
        this.logError(exc);
        this.displayMessage(title, message, 1);
    }

    private void displayMessage(String title, String message, int iIconType) {
        MessageBox messageBox = new MessageBox(this.getShell(), 0x20 | iIconType | 0x10000);
        messageBox.setMessage(message);
        messageBox.setText(title);
        messageBox.open();
    }

    protected Button getDefaultsButton() {
        return super.getDefaultsButton();
    }

    public static interface IValidationPage {
        public Composite createPage(Composite var1) throws InvocationTargetException;

        public boolean performOk() throws InvocationTargetException;

        public boolean performDefaults() throws InvocationTargetException;

        public Composite getControl();

        public void dispose();

        public boolean performCancel();
    }

    public class InvalidPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private Label messageLabel = null;

        public InvalidPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPropertiesPage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            this.messageLabel = new Label(this.composite, 0);
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_EXC_INVALID_REGISTER"));
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performDefaults() {
            return true;
        }

        public boolean performOk() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }

        public boolean performCancel() {
            return true;
        }
    }

    public class NoValidatorsPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private GridData data = null;
        private Label messageLabel = null;

        public NoValidatorsPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPropertiesPage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            this.data = new GridData(272);
            this.composite.setLayoutData((Object)this.data);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            this.messageLabel = new Label(this.composite, 0);
            String[] msgParm = new String[]{ValidationPropertiesPage.this.getProject().getName()};
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_LBL_NOVALIDATORS_DESC", msgParm));
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performDefaults() {
            return true;
        }

        public boolean performOk() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }

        public boolean performCancel() {
            return true;
        }
    }

    public class ValidatorListPage
    implements IValidationPage {
        Composite page = null;
        GridLayout layout = null;
        GridData data = null;
        Label messageLabel = null;
        TableViewer validatorList = null;
        Button overrideGlobalButton = null;
        boolean existingOverrideGlobalVal = false;
        Button disableAllValidation = null;
        boolean existingDisableAllValidation = false;
        private Button enableAllButton = null;
        private Button disableAllButton = null;
        Label emptyRowPlaceholder = null;
        private Table validatorsTable;
        ProjectConfiguration pagePreferences = null;
        private boolean canOverride = false;
        private Button addValidationBuilder = null;
        private Color color = null;
        private ValidatorMetaData[] oldVmd = null;
        private Map oldDelegates = null;

        public ValidatorListPage(Composite parent) throws InvocationTargetException {
            ConfigurationManager prefMgr = ConfigurationManager.getManager();
            this.pagePreferences = prefMgr.getProjectConfiguration(ValidationPropertiesPage.this.getProject());
            this.canOverride = prefMgr.getGlobalConfiguration().canProjectsOverride();
            this.oldVmd = this.pagePreferences.getEnabledValidators();
            this.oldDelegates = new HashMap(this.pagePreferences.getDelegatingValidators());
            this.createPage(parent);
            this.existingOverrideGlobalVal = this.overrideGlobalButton.getSelection();
            this.existingDisableAllValidation = this.disableAllValidation.getSelection();
        }

        private void setupTableColumns(Table table, TableViewer viewer) {
            TableColumn validatorColumn = new TableColumn(table, 0);
            validatorColumn.setText(ResourceHandler.getExternalizedMessage("VALIDATOR"));
            validatorColumn.setResizable(false);
            validatorColumn.setWidth(320);
            TableColumn manualColumn = new TableColumn(table, 0);
            manualColumn.setText(ResourceHandler.getExternalizedMessage("MANUAL"));
            manualColumn.setResizable(false);
            manualColumn.setWidth(40);
            TableColumn buildColumn = new TableColumn(table, 0);
            buildColumn.setText(ResourceHandler.getExternalizedMessage("BUILD"));
            buildColumn.setResizable(false);
            buildColumn.setWidth(40);
            TableColumn settingsColumn = new TableColumn(table, 0);
            settingsColumn.setText(ResourceHandler.getExternalizedMessage("SETTINGS"));
            settingsColumn.setResizable(false);
            settingsColumn.setWidth(50);
        }

        public Composite createPage(Composite parent) throws InvocationTargetException {
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.page = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.page);
            this.page.setLayout((Layout)new GridLayout());
            Composite validatorGroup = new Composite(this.page, 0);
            GridLayout validatorGroupLayout = new GridLayout();
            validatorGroupLayout.numColumns = 2;
            validatorGroup.setLayout((Layout)validatorGroupLayout);
            Hyperlink link = new Hyperlink(validatorGroup, 0);
            GridData layout = new GridData(128);
            layout.horizontalSpan = 2;
            link.setLayoutData((Object)layout);
            link.setUnderlined(true);
            this.color = new Color((Device)validatorGroup.getDisplay(), new RGB(0, 0, 255));
            link.setForeground(this.color);
            link.setText(ResourceHandler.getExternalizedMessage("CONFIG_WS_SETTINGS"));
            link.addHyperlinkListener(new IHyperlinkListener(this){
                public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    String id = this.getPreferencePageID();
                    PreferencesUtil.createPreferenceDialogOn((Shell)ValidatorListPage.access$3(this.this$1).getShell(), (String)id, (String[])new String[]{id}, (Object)"PropertyAndPreferencePage.nolink").open();
                    try {
                        this.this$1.updateWidgets();
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }

                private String getPreferencePageID() {
                    return "ValidationPreferencePage";
                }
            });
            GridData overrideData = new GridData(512);
            overrideData.horizontalSpan = 2;
            this.overrideGlobalButton = new Button(validatorGroup, 32);
            this.overrideGlobalButton.setLayoutData((Object)overrideData);
            this.overrideGlobalButton.setText(ResourceHandler.getExternalizedMessage("PROP_BUTTON_OVERRIDE", new String[]{ValidationPropertiesPage.this.getProject().getName()}));
            this.overrideGlobalButton.setFocus();
            this.overrideGlobalButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setDoesProjectOverride(this.this$1.overrideGlobalButton.getSelection());
                    try {
                        this.this$1.updateWidgets();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$3(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.disableAllValidation = new Button(validatorGroup, 32);
            this.disableAllValidation.setLayoutData((Object)data);
            this.disableAllValidation.setText(ResourceHandler.getExternalizedMessage("DISABLE_VALIDATION"));
            this.disableAllValidation.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setDisableAllValidation(this.this$1.disableAllValidation.getSelection());
                    this.this$1.disableAllValidation.setFocus();
                    ValidatorListPage.access$0(this.this$1).setEnabled(!this.this$1.disableAllValidation.getSelection());
                    ValidatorListPage.access$1(this.this$1).setEnabled(!this.this$1.disableAllValidation.getSelection());
                    ValidatorListPage.access$2(this.this$1).setEnabled(!this.this$1.disableAllValidation.getSelection());
                    try {
                        this.this$1.updateWidgets();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$3(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            GridData listLabelData = new GridData(768);
            listLabelData.horizontalSpan = 2;
            this.messageLabel = new Label(validatorGroup, 0);
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_LBL_DESC", new String[]{ValidationPropertiesPage.this.getProject().getName()}));
            this.messageLabel.setLayoutData((Object)listLabelData);
            this.validatorsTable = new Table(validatorGroup, 67584);
            TableLayout tableLayout = new TableLayout();
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(160, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            this.validatorsTable.setHeaderVisible(true);
            this.validatorsTable.setLinesVisible(true);
            this.validatorsTable.setLayout((Layout)tableLayout);
            this.validatorList = new TableViewer(this.validatorsTable);
            GridData validatorListData = new GridData(768);
            validatorListData.horizontalSpan = 2;
            this.validatorsTable.setLayoutData((Object)validatorListData);
            this.validatorList.getTable().setLayoutData((Object)validatorListData);
            this.validatorList.setLabelProvider((IBaseLabelProvider)new ValidationLabelProvider());
            this.validatorList.setContentProvider((IContentProvider)new ValidationContentProvider());
            this.validatorList.setSorter((ViewerSorter)new ValidationViewerSorter());
            this.setupTableColumns(this.validatorsTable, this.validatorList);
            this.validatorsTable.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void mouseDown(MouseEvent e) {
                    int columnNumber;
                    if (e.button != 1) {
                        return;
                    }
                    TableItem tableItem = ValidatorListPage.access$0(this.this$1).getItem(new Point(e.x, e.y));
                    if (tableItem == null || tableItem.isDisposed()) {
                        return;
                    }
                    int columnsCount = ValidatorListPage.access$0(this.this$1).getColumnCount();
                    if (columnsCount == 0) {
                        columnNumber = 0;
                    } else {
                        columnNumber = -1;
                        int i = 0;
                        while (i < columnsCount) {
                            Rectangle bounds = tableItem.getBounds(i);
                            if (bounds.contains(e.x, e.y)) {
                                columnNumber = i;
                                break;
                            }
                            ++i;
                        }
                        if (columnNumber == -1) {
                            return;
                        }
                    }
                    this.this$1.columnClicked(columnNumber);
                }
            });
            this.validatorsTable.setMenu(this.createContextMenu());
            this.validatorsTable.addFocusListener((FocusListener)new FocusAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void focusGained(FocusEvent e) {
                    super.focusGained(e);
                    if (ValidatorListPage.access$0(this.this$1).getSelectionCount() == 0) {
                        ValidatorListPage.access$0(this.this$1).select(0);
                    }
                }
            });
            this.validatorList.setInput((Object)this.pagePreferences.getValidators());
            this.enableAllButton = new Button(validatorGroup, 8);
            GridData selectData = new GridData();
            this.enableAllButton.setLayoutData((Object)selectData);
            this.enableAllButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_ENABLEALL"));
            this.enableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        this.this$1.performEnableAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$3(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.enableAllButton, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            GridData deselectData = new GridData();
            this.disableAllButton = new Button(validatorGroup, 8);
            this.disableAllButton.setLayoutData((Object)deselectData);
            this.disableAllButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_DISABLEALL"));
            this.disableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        this.this$1.performDisableAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$3(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.disableAllButton, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            GridData disableValidationData = new GridData(768);
            disableValidationData.horizontalSpan = 2;
            this.addValidationBuilder = new Button(validatorGroup, 32);
            this.addValidationBuilder.setLayoutData((Object)disableValidationData);
            this.addValidationBuilder.setText(ResourceHandler.getExternalizedMessage("ADD_VALIDATION_BUILDER"));
            validatorGroup.setTabList(new Control[]{this.overrideGlobalButton, this.disableAllValidation, this.validatorList.getTable(), this.enableAllButton, this.disableAllButton});
            this.updateWidgets();
            Dialog.applyDialogFont((Control)parent);
            this.page.setSize(this.page.computeSize(-1, -1));
            return this.page;
        }

        protected void updateTable() throws InvocationTargetException {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                if (this.pagePreferences.isManualEnabled(vmd)) {
                    vmd.setManualValidation(true);
                } else {
                    vmd.setManualValidation(false);
                }
                if (this.pagePreferences.isBuildEnabled(vmd)) {
                    vmd.setBuildValidation(true);
                } else {
                    vmd.setBuildValidation(false);
                }
                ++i;
            }
            this.validatorList.refresh();
        }

        protected void enableManualAndBuildValues() {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                vmd.setManualValidation(true);
                vmd.setBuildValidation(true);
                ++i;
            }
            this.validatorList.refresh();
        }

        protected void disableManualAndBuildValues() {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                vmd.setManualValidation(false);
                vmd.setBuildValidation(false);
                ++i;
            }
            this.validatorList.refresh();
        }

        public boolean performDefaults() throws InvocationTargetException {
            this.pagePreferences.resetToDefault();
            this.updateWidgets();
            ValidationPropertiesPage.this.getDefaultsButton().setFocus();
            return true;
        }

        public boolean performEnableAll() throws InvocationTargetException {
            this.setAllValidators(true);
            this.pagePreferences.setEnabledValidators(this.getEnabledValidators());
            this.enableManualAndBuildValues();
            this.enableAllButton.setFocus();
            return true;
        }

        public boolean performDisableAll() throws InvocationTargetException {
            this.setAllValidators(false);
            this.pagePreferences.setEnabledValidators(this.getEnabledValidators());
            this.disableManualAndBuildValues();
            this.disableAllButton.setFocus();
            return true;
        }

        public ValidatorMetaData[] getEnabledValidators() {
            ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>();
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                if (validatorMetaData.isManualValidation() || validatorMetaData.isBuildValidation()) {
                    enabledValidators.add(validatorMetaData);
                }
                ++i;
            }
            return enabledValidators.toArray(new ValidatorMetaData[enabledValidators.size()]);
        }

        public ValidatorMetaData[] getManualEnabledValidators() {
            ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>();
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                if (validatorMetaData.isManualValidation()) {
                    enabledValidators.add(validatorMetaData);
                }
                ++i;
            }
            return enabledValidators.toArray(new ValidatorMetaData[enabledValidators.size()]);
        }

        public ValidatorMetaData[] getBuildEnabledValidators() {
            ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>();
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                if (validatorMetaData.isBuildValidation()) {
                    enabledValidators.add(validatorMetaData);
                }
                ++i;
            }
            return enabledValidators.toArray(new ValidatorMetaData[enabledValidators.size()]);
        }

        private void setAllValidators(boolean bool) {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                validatorMetaData.setManualValidation(bool);
                validatorMetaData.setBuildValidation(bool);
                ++i;
            }
        }

        protected Menu createContextMenu() {
            Menu menu = new Menu((Decorations)this.validatorsTable.getShell(), 8);
            MenuItem manualItem = new MenuItem(menu, 32);
            manualItem.setText(ResourceHandler.getExternalizedMessage("PREF_MNU_MANUAL"));
            MenuItem buildItem = new MenuItem(menu, 32);
            buildItem.setText(ResourceHandler.getExternalizedMessage("PREF_MNU_BUILD"));
            MenuItem settingsItem = new MenuItem(menu, 8);
            settingsItem.setText(ResourceHandler.getExternalizedMessage("PREF_MNU_SETTINGS"));
            class MenuItemListener
            extends SelectionAdapter {
                final /* synthetic */ ValidatorListPage this$1;
                private final /* synthetic */ Menu val$menu;

                MenuItemListener(ValidatorListPage validatorListPage, Menu menu) {
                    this.this$1 = validatorListPage;
                    this.val$menu = menu;
                }

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.getSource();
                    int index = this.val$menu.indexOf(menuItem) + 1;
                    this.this$1.columnClicked(index);
                }
            }
            MenuItemListener listener = new MenuItemListener(this, menu);
            manualItem.addSelectionListener((SelectionListener)listener);
            buildItem.addSelectionListener((SelectionListener)listener);
            settingsItem.addSelectionListener((SelectionListener)listener);
            menu.addMenuListener((MenuListener)new MenuAdapter(this, manualItem, buildItem, settingsItem){
                final /* synthetic */ ValidatorListPage this$1;
                private final /* synthetic */ MenuItem val$manualItem;
                private final /* synthetic */ MenuItem val$buildItem;
                private final /* synthetic */ MenuItem val$settingsItem;
                {
                    this.this$1 = validatorListPage;
                    this.val$manualItem = menuItem;
                    this.val$buildItem = menuItem2;
                    this.val$settingsItem = menuItem3;
                }

                public void menuShown(MenuEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)this.this$1.validatorList.getSelection();
                    ValidatorMetaData vmd = (ValidatorMetaData)selection.getFirstElement();
                    this.val$manualItem.setSelection(vmd.isManualValidation());
                    this.val$buildItem.setSelection(vmd.isBuildValidation());
                    this.val$settingsItem.setEnabled(vmd.isDelegating());
                }
            });
            return menu;
        }

        protected void columnClicked(int columnToEdit) {
            IStructuredSelection selection = (IStructuredSelection)this.validatorList.getSelection();
            ValidatorMetaData vmd = (ValidatorMetaData)selection.getFirstElement();
            switch (columnToEdit) {
                case 1: {
                    vmd.setManualValidation(!vmd.isManualValidation());
                    break;
                }
                case 2: {
                    vmd.setBuildValidation(!vmd.isBuildValidation());
                    break;
                }
                case 3: {
                    if (!vmd.isDelegating()) break;
                    String delegateID = this.pagePreferences.getDelegateUniqueName(vmd);
                    Shell shell = Display.getCurrent().getActiveShell();
                    DelegatingValidatorPreferencesDialog dialog = new DelegatingValidatorPreferencesDialog(shell, vmd, delegateID);
                    dialog.setBlockOnOpen(true);
                    dialog.create();
                    int result = dialog.open();
                    if (result != 0) break;
                    this.pagePreferences.setDelegateUniqueName(vmd, dialog.getDelegateID());
                }
            }
            this.validatorList.refresh();
        }

        void updateWidgets() throws InvocationTargetException {
            this.updateTable();
            this.updateAllWidgets();
        }

        protected void updateWidgetsForDefaults() throws InvocationTargetException {
            this.updateTableForDefaults();
            this.updateAllWidgets();
        }

        private void updateAllWidgets() throws InvocationTargetException {
            ConfigurationManager prefMgr = ConfigurationManager.getManager();
            this.canOverride = prefMgr.getGlobalConfiguration().canProjectsOverride();
            boolean overridePreferences = this.canOverride && this.pagePreferences.doesProjectOverride();
            this.overrideGlobalButton.setEnabled(this.canOverride);
            this.overrideGlobalButton.setSelection(overridePreferences);
            this.disableAllValidation.setEnabled(overridePreferences);
            this.disableAllValidation.setSelection(this.pagePreferences.isDisableAllValidation());
            if (overridePreferences) {
                this.enableDependentControls(!this.pagePreferences.isDisableAllValidation());
            } else {
                this.enableDependentControls(overridePreferences);
            }
            this.setAddValidationBuilderButtonEnablement();
            this.updateHelp();
        }

        private void setAddValidationBuilderButtonEnablement() {
            try {
                boolean builderExists = false;
                IProjectDescription description = ValidationPropertiesPage.this.getProject().getDescription();
                ICommand[] commands = description.getBuildSpec();
                int i = 0;
                while (i < commands.length) {
                    if (commands[i].getBuilderName().equals("org.eclipse.wst.validation.validationbuilder") | this.isValidationBuilderEnabled(commands[i])) {
                        builderExists = true;
                    }
                    ++i;
                }
                if (builderExists) {
                    this.addValidationBuilder.setVisible(false);
                } else {
                    this.addValidationBuilder.setVisible(true);
                    this.addValidationBuilder.setSelection(false);
                    this.addValidationBuilder.setEnabled(true);
                }
            }
            catch (CoreException ce) {
                Logger.getLogger().log((Throwable)ce);
            }
        }

        private boolean isValidationBuilderEnabled(ICommand command) {
            Map args = command.getArguments();
            if (args.isEmpty()) {
                return false;
            }
            String handle = (String)args.get("LaunchConfigHandle");
            return handle != null && handle.length() > 0 && handle.indexOf("org.eclipse.wst.validation.validationbuilder") != -1;
        }

        private void updateTableForDefaults() throws InvocationTargetException {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                if (this.pagePreferences.isEnabled(vmd)) {
                    vmd.setManualValidation(true);
                    vmd.setBuildValidation(true);
                } else {
                    vmd.setManualValidation(false);
                    vmd.setBuildValidation(false);
                }
                ++i;
            }
            this.validatorList.refresh();
        }

        private void enableDependentControls(boolean overridePreferences) {
            this.validatorsTable.setEnabled(overridePreferences);
            this.validatorList.refresh();
            this.enableAllButton.setEnabled(overridePreferences);
            this.disableAllButton.setEnabled(overridePreferences);
        }

        protected void updateHelp() throws InvocationTargetException {
            if (this.overrideGlobalButton.getEnabled()) {
                boolean doesProjectSupportBuildValidation = ValidatorManager.doesProjectSupportBuildValidation((IProject)ValidationPropertiesPage.this.getProject());
                if (doesProjectSupportBuildValidation) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.overrideGlobalButton, "org.eclipse.wst.common.frameworks.ui.jvpp0030");
                }
            } else {
                this.validatorList.getTable().setFocus();
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.validatorList.getTable(), "org.eclipse.wst.common.frameworks.ui.jvpp0001");
            }
        }

        private void storeValues() throws InvocationTargetException {
            this.pagePreferences.setDoesProjectOverride(this.overrideGlobalButton.getSelection());
            if (this.pagePreferences.doesProjectOverride()) {
                this.pagePreferences.setEnabledManualValidators(this.getManualEnabledValidators());
                this.pagePreferences.setEnabledBuildValidators(this.getBuildEnabledValidators());
            } else {
                this.pagePreferences.resetToDefault();
            }
            this.pagePreferences.store();
        }

        public boolean performOk() throws InvocationTargetException {
            this.addBuilder();
            this.storeValues();
            if (this.pagePreferences.hasEnabledValidatorsChanged(this.oldVmd, false) || this.pagePreferences.haveDelegatesChanged(this.oldDelegates, false)) {
                ValidatorManager.getManager().updateTaskList(ValidationPropertiesPage.this.getProject());
            }
            return true;
        }

        private void addBuilder() {
            if (this.addValidationBuilder.isEnabled() && this.addValidationBuilder.getSelection()) {
                ValidatorManager.addProjectBuildValidationSupport((IProject)ValidationPropertiesPage.this.getProject());
            }
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.enableAllButton.dispose();
            this.disableAllButton.dispose();
            this.validatorList.getTable().dispose();
            this.messageLabel.dispose();
            this.emptyRowPlaceholder.dispose();
            this.overrideGlobalButton.dispose();
            this.page.dispose();
            this.color.dispose();
        }

        public boolean performCancel() {
            this.pagePreferences.setDoesProjectOverride(this.existingOverrideGlobalVal);
            this.pagePreferences.setDisableAllValidation(this.existingDisableAllValidation);
            return true;
        }

        static /* synthetic */ Button access$1(ValidatorListPage validatorListPage) {
            return validatorListPage.enableAllButton;
        }

        static /* synthetic */ Button access$2(ValidatorListPage validatorListPage) {
            return validatorListPage.disableAllButton;
        }

        static /* synthetic */ ValidationPropertiesPage access$3(ValidatorListPage validatorListPage) {
            return validatorListPage.ValidationPropertiesPage.this;
        }

        public class ValidationContentProvider
        implements IStructuredContentProvider {
            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ValidatorMetaData[]) {
                    return (ValidatorMetaData[])inputElement;
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        public class ValidationLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof ValidatorMetaData) {
                    return ((ValidatorMetaData)element).getValidatorDisplayName();
                }
                return super.getText(element);
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ((ValidatorMetaData)element).getValidatorDisplayName();
                }
                return null;
            }

            private Image getImage(String imageName) {
                boolean isDisabled;
                boolean bl = isDisabled = !ValidatorListPage.this.validatorsTable.isEnabled();
                if (isDisabled) {
                    imageName = String.valueOf(imageName) + "_disabled";
                }
                Image image = ValidationUIPlugin.getPlugin().getImage(imageName);
                return image;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                ValidatorMetaData vmd;
                if (columnIndex == 1) {
                    if (((ValidatorMetaData)element).isManualValidation()) {
                        return this.getImage("ok_tbl");
                    }
                    return this.getImage("fail_tbl");
                }
                if (columnIndex == 2) {
                    if (((ValidatorMetaData)element).isBuildValidation()) {
                        return this.getImage("ok_tbl");
                    }
                    return this.getImage("fail_tbl");
                }
                if (columnIndex == 3 && (vmd = (ValidatorMetaData)element).isDelegating()) {
                    return this.getImage("settings");
                }
                return null;
            }
        }

        public class ValidationViewerSorter
        extends ViewerSorter {
            public int compare(Viewer viewer, Object e1, Object e2) {
                return super.compare(viewer, e1, e2);
            }
        }
    }
}

