/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.SWTUtil;
import org.eclipse.jst.server.generic.ui.internal.editor.UpdateServerPropertyOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ServerPropertiesEditorSection
extends ServerEditorSection {
    private GenericServer fServer;
    private PropertyChangeListener fPropertyChangeListener;
    private Map fControls = new HashMap();
    private boolean fUpdating;
    static /* synthetic */ Class class$0;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fServer = (GenericServer)this.server.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor());
        }
        this.fPropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("generic_server_instance_properties") && !ServerPropertiesEditorSection.this.fUpdating) {
                    ServerPropertiesEditorSection.this.fUpdating = true;
                    ServerPropertiesEditorSection.this.updateControls();
                    ServerPropertiesEditorSection.this.fUpdating = false;
                }
            }
        };
        this.server.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    protected void updateControls() {
        EList props = this.fServer.getServerDefinition().getProperty();
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            String value;
            Property property = (Property)iter.next();
            if (!property.getContext().equals("server")) continue;
            if ("boolean".equals(property.getType())) {
                Button b = (Button)this.fControls.get(property.getId());
                b.setSelection("true".equals(this.getPropertyValue(property)));
                continue;
            }
            if ("select".equals(property.getType()) || "combo".equals(property.getType())) {
                Combo c = (Combo)this.fControls.get(property.getId());
                value = this.getPropertyValue(property) == null ? "" : this.getPropertyValue(property);
                c.setText(value);
                continue;
            }
            Text t = (Text)this.fControls.get(property.getId());
            value = this.getPropertyValue(property) == null ? "" : this.getPropertyValue(property);
            t.setText(value);
        }
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit formToolkit = this.getFormToolkit(parent.getDisplay());
        Section section = formToolkit.createSection(parent, 458);
        section.setText(GenericServerUIMessages.ServerEditorSectionTitle);
        section.setDescription(GenericServerUIMessages.ServerEditorSectionDescription);
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = formToolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        EList props = this.fServer.getServerDefinition().getProperty();
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (!property.getContext().equals("server")) continue;
            this.createPropertyControl(composite, property, formToolkit);
        }
        formToolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    private void executeUpdateOperation(String propertyName, String propertyValue) {
        if (!this.fUpdating) {
            this.fUpdating = true;
            this.execute((IUndoableOperation)new UpdateServerPropertyOperation(this.server, GenericServerUIMessages.UpdateOperationDescription, propertyName, propertyValue));
            this.fUpdating = false;
        }
    }

    private void createPropertyControl(Composite parent, final Property property, FormToolkit toolkit) {
        if ("directory".equals(property.getType())) {
            final Text path = SWTUtil.createLabeledPath(property.getLabel(), this.getPropertyValue(property), parent, toolkit);
            this.fControls.put(property.getId(), path);
            path.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), path.getText());
                }
            });
        } else if ("file".equals(property.getType())) {
            final Text file = SWTUtil.createLabeledFile(property.getLabel(), this.getPropertyValue(property), parent, toolkit);
            this.fControls.put(property.getId(), file);
            file.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), file.getText());
                }
            });
        } else if ("boolean".equals(property.getType())) {
            final Button bool = SWTUtil.createLabeledCheck(property.getLabel(), "true".equals(this.getPropertyValue(property)), parent, toolkit);
            this.fControls.put(property.getId(), bool);
            bool.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), Boolean.toString(bool.getSelection()));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else if ("select".equals(property.getType())) {
            StringTokenizer tokenizer = new StringTokenizer(property.getDefault(), ",");
            int tokenCount = tokenizer.countTokens();
            String[] values = new String[tokenCount];
            int i = 0;
            while (tokenizer.hasMoreTokens() && i < tokenCount) {
                values[i] = tokenizer.nextToken();
                ++i;
            }
            final Combo combo = SWTUtil.createLabeledCombo(property.getLabel(), values, parent, toolkit);
            this.fControls.put(property.getId(), combo);
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), combo.getText());
                }
            });
            combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), combo.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else if ("combo".equals(property.getType())) {
            StringTokenizer tokenizer = new StringTokenizer(property.getDefault(), ",");
            int tokenCount = tokenizer.countTokens();
            String[] values = new String[tokenCount];
            int i = 0;
            while (tokenizer.hasMoreTokens() && i < tokenCount) {
                values[i] = tokenizer.nextToken();
                ++i;
            }
            final Combo combo = SWTUtil.createLabeledEditableCombo(property.getLabel(), values, this.getPropertyValue(property), parent, toolkit);
            this.fControls.put(property.getId(), combo);
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), combo.getText());
                }
            });
            combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), combo.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else {
            final Text defaultText = SWTUtil.createLabeledText(property.getLabel(), this.getPropertyValue(property), parent, toolkit);
            this.fControls.put(property.getId(), defaultText);
            defaultText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), defaultText.getText());
                }
            });
        }
    }

    private String getPropertyValue(Property property) {
        return (String)this.fServer.getServerInstanceProperties().get(property.getId());
    }

    public void dispose() {
        super.dispose();
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.fPropertyChangeListener);
        }
    }
}

