/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class JEE5ModelProvider
implements IModelProvider {
    protected XMLResourceImpl writableResource;
    protected IProject proj;
    protected IPath defaultResourcePath;
    private static boolean resourceChangeListenerEnabled = false;
    private static HashMap<IProject, HashSet<IPath>> modelResources = new HashMap();

    protected ProjectResourceSet getResourceSet(IProject proj2) {
        return (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)this.proj);
    }

    public XMLResourceImpl getWritableResource() {
        return this.writableResource;
    }

    public void setWritableResource(XMLResourceImpl writableResource) {
        this.writableResource = writableResource;
    }

    protected XMLResourceImpl getModelResource(IPath modelPath) {
        if (this.writableResource != null) {
            return this.writableResource;
        }
        if (modelPath == null) {
            modelPath = this.getDefaultResourcePath();
        }
        ProjectResourceSet resSet = this.getResourceSet(this.proj);
        IVirtualFolder container = ComponentCore.createComponent((IProject)this.proj).getRootFolder();
        String modelPathURI = modelPath.toString();
        URI uri = URI.createURI((String)(String.valueOf(container.getProjectRelativePath().toString()) + '/' + modelPathURI));
        XMLResourceImpl res = null;
        try {
            if (this.proj.getFile(uri.toString()).exists()) {
                res = (XMLResourceImpl)resSet.getResource(uri, true);
                HashSet<Object> currentResources = modelResources.get(this.proj);
                if (currentResources == null) {
                    currentResources = new HashSet();
                }
                currentResources.add((IPath)new Path(uri.toString()));
                modelResources.put(this.proj, currentResources);
                if (!resourceChangeListenerEnabled) {
                    resourceChangeListenerEnabled = true;
                    ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 1);
                }
            }
        }
        catch (WrappedException ex) {
            if (ex.getCause() instanceof FileNotFoundException) {
                return null;
            }
            throw ex;
        }
        return res;
    }

    public IPath getDefaultResourcePath() {
        return this.defaultResourcePath;
    }

    public void setDefaultResourcePath(IPath defaultResourcePath) {
        this.defaultResourcePath = defaultResourcePath;
    }

    public Object getModelObject() {
        return this.getModelObject(this.getDefaultResourcePath());
    }

    public Object getModelObject(IPath modelPath) {
        return null;
    }

    public IStatus validateEdit(IPath modelPath, Object context) {
        if (modelPath == null) {
            modelPath = this.getDefaultResourcePath();
        }
        IWorkspace work = ResourcesPlugin.getWorkspace();
        IFile file = WorkbenchResourceHelper.getFile((Resource)this.getModelResource(modelPath));
        if (file != null) {
            IFile[] files = new IFile[]{file};
            if (context == null) {
                context = IWorkspace.VALIDATE_PROMPT;
            }
            return work.validateEdit(files, context);
        }
        return Status.OK_STATUS;
    }

    public void modify(Runnable runnable, IPath modelPath) {
        try {
            try {
                XMLResourceImpl res = this.getModelResource(modelPath);
                if (res != null) {
                    this.setWritableResource(res);
                }
                runnable.run();
                try {
                    if (res != null) {
                        res.save(Collections.EMPTY_MAP);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setWritableResource(null);
            }
        }
        finally {
            this.setWritableResource(null);
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                IResourceDelta[] affectedChildren = delta.getAffectedChildren(6, 1);
                IResourceDelta projectDelta = null;
                IResource changedResource = null;
                IProject changedProject = null;
                IPath resourcePath = null;
                int i = 0;
                while (i < affectedChildren.length) {
                    projectDelta = affectedChildren[i];
                    changedResource = projectDelta.getResource();
                    changedProject = changedResource.getProject();
                    HashSet currentResources = (HashSet)modelResources.get(changedProject);
                    if (currentResources != null) {
                        if (changedResource == changedProject && projectDelta.getKind() == 2) {
                            modelResources.remove(changedProject);
                            if (modelResources.isEmpty()) {
                                resourceChangeListenerEnabled = false;
                                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                            }
                        } else {
                            Iterator iter = currentResources.iterator();
                            ArrayList<IPath> toUnload = new ArrayList<IPath>();
                            while (iter.hasNext()) {
                                resourcePath = (IPath)iter.next();
                                if (projectDelta.findMember(resourcePath) == null) continue;
                                toUnload.add(resourcePath);
                            }
                            if (toUnload.size() > 0) {
                                Resource current2 = null;
                                ProjectResourceSet resourceSet = JEE5ModelProvider.this.getResourceSet(changedProject);
                                URIConverter uriConverter = resourceSet.getURIConverter();
                                HashSet<URI> resourceURIs = new HashSet<URI>();
                                iter = toUnload.iterator();
                                while (iter.hasNext()) {
                                    resourceURIs.add(uriConverter.normalize(URI.createURI((String)((IPath)iter.next()).toString())));
                                }
                                for (Resource current2 : resourceSet.getResources()) {
                                    if (!resourceURIs.contains(current2.getURI())) continue;
                                    current2.unload();
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

