/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.project.facet;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBJarImpl;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbClientProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class EjbFacetPostInstallDelegate
extends J2EEFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel model = (IDataModel)config;
            IVirtualComponent c = ComponentCore.createComponent((IProject)project);
            String earProjectName = (String)model.getProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME");
            if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
                if (earProjectName != null && !earProjectName.equals("")) {
                    String ver = fv.getVersionString();
                    String j2eeVersionText = J2EEVersionUtil.convertVersionIntToString((int)J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID((String)ver));
                    String moduleURI = model.getStringProperty("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI");
                    this.installAndAddModuletoEAR(j2eeVersionText, earProjectName, (IRuntime)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME"), project, moduleURI, monitor);
                }
                boolean createClient = model.getBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT");
                String clientProjectName = (String)model.getProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ");
                if (createClient && clientProjectName != null && clientProjectName != "") {
                    IProject ejbClientProject = ProjectUtilities.getProject((String)clientProjectName);
                    if (ejbClientProject.exists()) {
                        return;
                    }
                    c.setMetaProperty("ClientProject", clientProjectName);
                    String clientURI = model.getStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_URI ");
                    c.setMetaProperty("ClientJARURI", clientURI);
                    IRuntime rt = (IRuntime)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                    try {
                        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new EjbClientProjectCreationDataModelProvider());
                        dm.setStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME", clientProjectName);
                        dm.setStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME", model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME"));
                        dm.setStringProperty("IJavaUtilityProjectCreationDataModelProperties.EAR_PROJECT_NAME", earProjectName);
                        dm.setStringProperty("IJavaUtilityProjectCreationDataModelProperties.SOURCE_FOLDER", (String)model.getProperty("IEjbFacetInstallDataModelProperties.CLIENT_SOURCE_FOLDER "));
                        dm.setProperty("IJavaUtilityProjectCreationDataModelProperties.RUNTIME", (Object)rt);
                        dm.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
                        dm.getDefaultOperation().execute(monitor, null);
                    }
                    catch (Exception e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                    if (createClient && clientProjectName != null && clientProjectName != "") {
                        try {
                            if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
                                this.runAddClientToEAROperation(model, monitor);
                            }
                            this.runAddClientToEJBOperation(model, monitor);
                            this.modifyEJBModuleJarDependency(model, monitor);
                            this.updateEJBDD(model, monitor);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void runAddClientToEAROperation(IDataModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String earProjectName = (String)model.getProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME");
        IProject earproject = ProjectUtilities.getProject((String)earProjectName);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earproject);
        String clientProjectName = model.getStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ");
        IProject clientProject = ProjectUtilities.getProject((String)clientProjectName);
        IVirtualComponent component = ComponentCore.createComponent((IProject)clientProject);
        if (earComp.exists() && component.exists()) {
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
            List modList = (List)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
            modList.add(component);
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
            String clientURI = model.getStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_URI ");
            ((Map)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP")).put(component, clientURI);
            try {
                dm.getDefaultOperation().execute(monitor, null);
            }
            catch (ExecutionException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
    }

    protected void runAddClientToEJBOperation(IDataModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String ejbprojectName = model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IProject ejbProj = ProjectUtilities.getProject((String)ejbprojectName);
        IVirtualComponent ejbcomponent = ComponentCore.createComponent((IProject)ejbProj);
        String clientProjectName = model.getStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ");
        IProject clientProject = ProjectUtilities.getProject((String)clientProjectName);
        IVirtualComponent ejbclientcomponent = ComponentCore.createComponent((IProject)clientProject);
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)ejbcomponent);
        List modList = (List)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modList.add(ejbclientcomponent);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
        try {
            dm.getDefaultOperation().execute(monitor, null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    private void modifyEJBModuleJarDependency(IDataModel model, IProgressMonitor aMonitor) throws InvocationTargetException, InterruptedException {
        String ejbprojectName = model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IProject ejbProj = ProjectUtilities.getProject((String)ejbprojectName);
        IVirtualComponent ejbComponent = ComponentCore.createComponent((IProject)ejbProj);
        IVirtualFile vf = ejbComponent.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile manifestmf = vf.getUnderlyingFile();
        if (manifestmf == null || !manifestmf.exists()) {
            try {
                this.createManifest(ejbProj, ejbComponent.getRootFolder().getUnderlyingFolder(), aMonitor);
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
            }
            String manifestFolder = String.valueOf('/') + model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER") + '/' + "META-INF";
            IFolder container = ejbProj.getFolder(manifestFolder);
            manifestmf = container.getFile((IPath)new Path("MANIFEST.MF"));
        }
        String clientURI = model.getStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_URI ");
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel(UpdateManifestDataModelProvider.class);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)ejbprojectName);
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", (Object)UpdateManifestDataModelProvider.convertClasspathStringToList((String)clientURI));
        try {
            updateManifestDataModel.getDefaultOperation().execute(aMonitor, null);
        }
        catch (Exception e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    private void updateEJBDD(IDataModel model, IProgressMonitor monitor) {
        String ejbprojectName = model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IProject ejbProj = ProjectUtilities.getProject((String)ejbprojectName);
        String clientProjectName = model.getStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ");
        IVirtualComponent c = ComponentCore.createComponent((IProject)ejbProj);
        Properties props = c.getMetaProperties();
        String clienturi = props.getProperty("ClientJARURI");
        EJBArtifactEdit ejbEdit = null;
        try {
            try {
                ejbEdit = new EJBArtifactEdit(ejbProj, false, true);
                if (ejbEdit != null) {
                    EJBJarImpl ejbres = (EJBJarImpl)ejbEdit.getDeploymentDescriptorRoot();
                    if (clienturi != null && !clienturi.equals("")) {
                        ejbres.setEjbClientJar(clienturi);
                    } else {
                        ejbres.setEjbClientJar(String.valueOf(clientProjectName) + ".jar");
                    }
                    ejbres.setEjbClientJar(clienturi);
                    ejbEdit.saveIfNecessary(monitor);
                }
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
                if (ejbEdit != null) {
                    ejbEdit.dispose();
                }
            }
        }
        finally {
            if (ejbEdit != null) {
                ejbEdit.dispose();
            }
        }
    }
}

