/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSMediaRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPageRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistContext;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalGenerator;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalGeneratorForAtmarkRule;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalGeneratorForDeclarationName;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalGeneratorForDeclarationValue;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalGeneratorForHTMLTag;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalGeneratorForPseudoSelector;
import org.w3c.dom.css.CSSFontFaceRule;

class CSSProposalArranger {
    private List fProposals = new ArrayList();
    private CSSContentAssistContext fContext = null;

    private CSSProposalArranger() {
    }

    CSSProposalArranger(int documentPosition, ICSSNode node, int documentOffset, char quote) {
        this();
        this.fContext = new CSSContentAssistContext(documentPosition, node, documentOffset, quote);
    }

    void buildProposals() {
        this.fProposals.clear();
        ICSSNode targetNode = this.fContext.getTargetNode();
        if (targetNode instanceof ICSSStyleSheet) {
            this.buildProposalsForAnyRule();
        } else if (targetNode instanceof ICSSMediaRule && this.fContext.isTargetPosAfterOf("LBRACE") || targetNode instanceof ICSSStyleRule && this.fContext.isTargetPosBeforeOf("LBRACE")) {
            this.buildProposalsForAnyRule();
        } else if (targetNode instanceof ICSSPageRule && this.fContext.isTargetPosBeforeOf("LBRACE")) {
            this.buildProposalsForPageRulePseudoClass();
        } else if ((targetNode instanceof ICSSStyleRule || targetNode instanceof CSSFontFaceRule || targetNode instanceof ICSSPageRule || targetNode instanceof ICSSStyleDeclaration) && (targetNode.getOwnerDocument() instanceof ICSSStyleDeclaration || this.fContext.targetFollows("DECLARATION_DELIMITER") || this.fContext.targetFollows("LBRACE"))) {
            this.buildProposalsForDeclarationName();
        } else if (targetNode instanceof ICSSStyleDeclItem) {
            if (this.fContext.isTargetPosAfterOf("DECLARATION_SEPARATOR")) {
                this.buildProposalsForDeclarationValue();
            } else {
                this.buildProposalsForDeclarationName();
            }
        } else if (targetNode instanceof ICSSPrimitiveValue) {
            this.buildProposalsForDeclarationValue();
        }
    }

    void buildProposalsForAnyRule() {
        CSSProposalGenerator generator = new CSSProposalGeneratorForAtmarkRule(this.fContext);
        this.fProposals.addAll(generator.getProposals());
        generator = new CSSProposalGeneratorForHTMLTag(this.fContext);
        this.fProposals.addAll(generator.getProposals());
        generator = new CSSProposalGeneratorForPseudoSelector(this.fContext);
        this.fProposals.addAll(generator.getProposals());
    }

    void buildProposalsForDeclarationName() {
        CSSProposalGeneratorForDeclarationName generator = new CSSProposalGeneratorForDeclarationName(this.fContext);
        this.fProposals.addAll(generator.getProposals());
    }

    void buildProposalsForDeclarationValue() {
        CSSProposalGeneratorForDeclarationValue generator = new CSSProposalGeneratorForDeclarationValue(this.fContext);
        this.fProposals.addAll(generator.getProposals());
    }

    void buildProposalsForPageRulePseudoClass() {
        CSSProposalGeneratorForPseudoSelector generator = new CSSProposalGeneratorForPseudoSelector(this.fContext);
        this.fProposals.addAll(generator.getProposals());
    }

    void buildProposalsForStyleRule() {
        CSSProposalGenerator generator = new CSSProposalGeneratorForHTMLTag(this.fContext);
        this.fProposals.addAll(generator.getProposals());
        generator = new CSSProposalGeneratorForPseudoSelector(this.fContext);
        this.fProposals.addAll(generator.getProposals());
    }

    ICompletionProposal[] getProposals() {
        this.buildProposals();
        CompletionProposal[] proposalArray = new CompletionProposal[this.fProposals.size()];
        Iterator iItem = this.fProposals.iterator();
        int i = 0;
        while (iItem.hasNext()) {
            proposalArray[i] = (ICompletionProposal)iItem.next();
            ++i;
        }
        return proposalArray;
    }
}

