/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.section;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldChangeListener;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.section.SetPropertyValueCommand;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.common.ui.properties.internal.provisional.AbstractPropertySection;

public abstract class AbstractEditPartSection
extends AbstractPropertySection {
    IDialogFieldChangeListener changeListener = new IDialogFieldChangeListener(){

        public void dialogFieldChanged(DialogField field) {
            AbstractEditPartSection.this.validate();
        }
    };
    private IPropertySource propertySource;
    private EditPart editPart;
    private Map propertyRegistry;
    private CommandStack commandStack;
    private CommandStackListener commandStackListener;

    public void refreshData() {
        super.refresh();
    }

    public abstract void validate();

    public void dispose() {
        super.dispose();
        if (this.getCommandStack() != null) {
            this.getCommandStack().removeCommandStackListener(this.getCommandStackListener());
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (part != null) {
            if (part.getAdapter(CommandStack.class) != null) {
                this.setCommandStack((CommandStack)part.getAdapter(CommandStack.class));
            }
            if (selection instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                if (structuredSelection.getFirstElement() instanceof EditPart) {
                    this.editPart = (EditPart)structuredSelection.getFirstElement();
                }
                if (this.editPart != null && this.editPart.getAdapter(IPropertySource.class) != null) {
                    this.propertySource = (IPropertySource)this.editPart.getAdapter(IPropertySource.class);
                }
            }
        }
        super.setInput(part, selection);
    }

    private CommandStackListener getCommandStackListener() {
        if (this.commandStackListener == null) {
            this.commandStackListener = new CommandStackListener(){

                public void commandStackChanged(EventObject e) {
                    AbstractEditPartSection.this.refreshData();
                }
            };
        }
        return this.commandStackListener;
    }

    public void setCommandStack(CommandStack stack) {
        this.commandStack = stack;
        stack.addCommandStackListener(this.getCommandStackListener());
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public IPropertySource getPropertySource() {
        return this.propertySource;
    }

    protected Object getFeatureID(String propertyName) {
        if (this.editPart != null && !(this.editPart.getModel() instanceof EObject)) {
            return null;
        }
        Object propertyID = this.getPropertyRegistry().get(propertyName);
        if (propertyID == null) {
            EClass cls = ((EObject)this.editPart.getModel()).eClass();
            for (EAttribute attr : cls.getEAllAttributes()) {
                if (!attr.getName().equalsIgnoreCase(propertyName)) continue;
                propertyID = Integer.toString(attr.getFeatureID());
                this.getPropertyRegistry().put(propertyName, propertyID);
                break;
            }
        }
        return propertyID;
    }

    protected Map getPropertyRegistry() {
        if (this.propertyRegistry == null) {
            this.propertyRegistry = new HashMap();
        }
        return this.propertyRegistry;
    }

    public Object getInput() {
        return this.editPart;
    }

    public void setValue(String propertyName, Object propertyValue) {
        if (propertyName != null && propertyValue != null && this.getPropertySource() != null) {
            SetPropertyValueCommand setCommand = new SetPropertyValueCommand(propertyName);
            setCommand.setTarget(this.getPropertySource());
            setCommand.setPropertyId(this.getFeatureID(propertyName));
            setCommand.setPropertyValue(propertyValue);
            if (this.getCommandStack() != null) {
                this.getCommandStack().execute((Command)setCommand);
            } else {
                setCommand.execute();
            }
        }
    }
}

