/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.LargeIconType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.SmallIconType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowElement;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowFactory;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.impl.PageReferenceElement;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.impl.ReferenceElement;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.FC2PFSynchronizer;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.PF2FCSynchronizer;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.TransformUtil;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowModelManager;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowTransform;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;

public class FC2PFTransformer
extends AdapterImpl {
    private static final boolean DEBUG = false;
    public static final int MY_NOTIFICATION_TYPE = 11;
    public static final int MY_NOTIFICATION_TYPE1 = 12;
    private boolean listenToNotify;
    private boolean isInEvent;
    boolean pageflowChanged = false;
    boolean needBatchOperations = false;
    private Map mapPaths2PF = new HashMap();
    private Map mapCases2Links = new HashMap();
    private Pageflow pageflow;
    FacesConfigType facesConfig;

    public void setListenToNotify(boolean listenToNotify) {
        this.listenToNotify = listenToNotify;
    }

    private void postEMFChanged() {
        this.startFCNotify();
        this.facesConfig.eNotify((Notification)new ENotificationImpl((InternalEObject)this.facesConfig, 4, 5, null, null));
        EList rules = this.facesConfig.getNavigationRule();
        int i = 0;
        while (i < rules.size()) {
            ((NavigationRuleType)rules.get(i)).eNotify((Notification)new ENotificationImpl((InternalEObject)rules.get(i), 4, 4, null, null));
            ++i;
        }
    }

    private void startFCNotify() {
        TreeIterator iterator = this.facesConfig.eAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            object.eSetDeliver(true);
        }
        this.facesConfig.eSetDeliver(true);
    }

    private TreeIterator stopFCNotify() {
        TreeIterator iterator = this.facesConfig.eAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            object.eSetDeliver(false);
        }
        this.facesConfig.eSetDeliver(false);
        return iterator;
    }

    boolean isNeedBatchOperations() {
        return this.needBatchOperations;
    }

    public void setNeedBatchOperations(boolean enable) {
        this.needBatchOperations = enable;
        if (!enable) {
            this.isInEvent = true;
            this.postEMFChanged();
            this.isInEvent = false;
        } else {
            this.stopFCNotify();
        }
    }

    private void updateFacesRule(NavigationRuleType navigationRule, PageflowPage pageSource) {
        FacesConfigFactory factory = FacesConfigFactory.eINSTANCE;
        if (pageSource.getComment() != null) {
            DescriptionType description = factory.createDescriptionType();
            description.setTextContent(pageSource.getComment());
            navigationRule.getDescription().clear();
            navigationRule.getDescription().add((Object)description);
        }
        if (pageSource.getLargeicon() != null || pageSource.getSmallicon() != null) {
            IconType icon = factory.createIconType();
            if (pageSource.getLargeicon() != null) {
                LargeIconType largeicon = factory.createLargeIconType();
                largeicon.setTextContent(pageSource.getLargeicon());
                icon.setLargeIcon(largeicon);
            }
            if (pageSource.getSmallicon() != null) {
                SmallIconType smallicon = factory.createSmallIconType();
                smallicon.setTextContent(pageSource.getSmallicon());
                icon.setSmallIcon(smallicon);
            }
            navigationRule.getIcon().clear();
            navigationRule.getIcon().add((Object)icon);
        }
        if (pageSource.getName() != null) {
            DisplayNameType displayName = factory.createDisplayNameType();
            displayName.setTextContent(pageSource.getName());
            navigationRule.getDisplayName().clear();
            navigationRule.getDisplayName().add((Object)displayName);
        }
    }

    private void createFacesCase(PageflowLink link, PageflowPage source, PageflowPage target_) {
        NavigationRuleType rule = FacesConfigFactory.eINSTANCE.createNavigationRuleType();
        FromViewIdType from = FacesConfigFactory.eINSTANCE.createFromViewIdType();
        from.setTextContent(source.getPath());
        rule.setFromViewId(from);
        NavigationCaseType navCase = FacesConfigFactory.eINSTANCE.createNavigationCaseType();
        ToViewIdType toView = FacesConfigFactory.eINSTANCE.createToViewIdType();
        toView.setTextContent(target_.getPath());
        navCase.setToViewId(toView);
        rule.getNavigationCase().add((Object)navCase);
        this.facesConfig.getNavigationRule().add((Object)rule);
        this.updateFacesRule(rule, source);
        source.getFCElements().add((EObject)from);
        target_.getFCElements().add((EObject)toView);
        link.getFCElements().add((EObject)navCase);
        this.mapCases2Links.put(navCase, link);
    }

    private void removePageflowPage(PageflowPage source) {
        Assert.isTrue((source.getOutlinks().size() == 0 && source.getInlinks().size() == 0 ? 1 : 0) != 0);
        this.pageflow.getNodes().remove((Object)source);
    }

    void removeCase(NavigationCaseType navCase) {
        NavigationRuleType rule = (NavigationRuleType)navCase.eContainer();
        rule.getNavigationCase().remove((Object)navCase);
        if (rule.getNavigationCase().size() == 0) {
            this.facesConfig.getNavigationRule().remove((Object)rule);
        }
    }

    private void removeLink(PageflowLink pLink) {
        PageflowPage source = (PageflowPage)pLink.getSource();
        PageflowPage target_ = (PageflowPage)pLink.getTarget();
        pLink.getPageflow().getLinks().remove((Object)pLink);
        source.getOutlinks().remove((Object)pLink);
        target_.getInlinks().remove((Object)pLink);
        pLink.getFCElements().clear();
        this.cleanPage(source);
        this.cleanPage(target_);
    }

    void changePFLinkStart(PageflowLink pLink, String newValue) {
        PageflowPage newPage = null;
        newPage = this.getValidPFPageInCache(newValue);
        if (newPage != null ? newValue.equals(((PageflowPage)pLink.getSource()).getPath()) : (newPage = TransformUtil.findPage(newValue, this.pageflow)) == null) {
            return;
        }
        NavigationCaseType caseType = (NavigationCaseType)pLink.getFCElements().getData().get(0);
        this.removeCase(caseType);
        NavigationCaseType newCase = FacesConfigFactory.eINSTANCE.createNavigationCaseType();
        ToViewIdType toView = FacesConfigFactory.eINSTANCE.createToViewIdType();
        toView.setTextContent(caseType.getToViewId().getTextContent());
        newCase.setToViewId(toView);
        NavigationRuleType newRule = FacesConfigFactory.eINSTANCE.createNavigationRuleType();
        FromViewIdType fromView = FacesConfigFactory.eINSTANCE.createFromViewIdType();
        fromView.setTextContent(newValue);
        newRule.setFromViewId(fromView);
        newRule.getNavigationCase().add((Object)newCase);
        this.facesConfig.getNavigationRule().add((Object)newRule);
        this.updateNode((EObject)caseType, (EObject)newCase);
        pLink.getFCElements().clear();
        pLink.getFCElements().add((EObject)newCase);
        pLink.setSource(newPage);
        this.updatePageflowElements(this.pageflow, newCase);
    }

    private void updateNode(EObject old, EObject newOne) {
        if (old instanceof NavigationRuleType) {
            ((NavigationRuleType)newOne).getDescription().clear();
            ((NavigationRuleType)newOne).getDescription().addAll((Collection)((NavigationRuleType)old).getDescription());
            ((NavigationRuleType)newOne).getDisplayName().clear();
            ((NavigationRuleType)newOne).getDisplayName().addAll((Collection)((NavigationRuleType)old).getDisplayName());
            ((NavigationRuleType)newOne).getDescription().clear();
            ((NavigationRuleType)newOne).getIcon().clear();
            ((NavigationRuleType)newOne).getIcon().addAll((Collection)((NavigationRuleType)old).getIcon());
        } else if (old instanceof NavigationCaseType) {
            ((NavigationCaseType)newOne).getDescription().clear();
            ((NavigationCaseType)newOne).getDescription().addAll((Collection)((NavigationCaseType)old).getDescription());
            ((NavigationCaseType)newOne).getDisplayName().clear();
            ((NavigationCaseType)newOne).getDisplayName().addAll((Collection)((NavigationCaseType)old).getDisplayName());
            ((NavigationCaseType)newOne).getDescription().clear();
            ((NavigationCaseType)newOne).getIcon().clear();
            ((NavigationCaseType)newOne).getIcon().addAll((Collection)((NavigationCaseType)old).getIcon());
            ((NavigationCaseType)newOne).setFromAction(((NavigationCaseType)old).getFromAction());
            ((NavigationCaseType)newOne).setFromOutcome(((NavigationCaseType)old).getFromOutcome());
        }
    }

    void changePFLinkEnd(PageflowLink pLink, String newValue) {
        PageflowPage newPage = null;
        newPage = this.getValidPFPageInCache(newValue);
        if (newPage != null ? newValue.equals(((PageflowPage)pLink.getSource()).getPath()) : (newPage = TransformUtil.findPage(newValue, this.pageflow)) == null) {
            return;
        }
        NavigationCaseType caseType = (NavigationCaseType)pLink.getFCElements().getData().get(0);
        ToViewIdType toView = caseType.getToViewId();
        if (toView == null) {
            toView = FacesConfigFactory.eINSTANCE.createToViewIdType();
        }
        toView.setTextContent(newValue);
        caseType.setToViewId(toView);
        pLink.setTarget(newPage);
        this.updatePageflowElements(this.pageflow, caseType);
    }

    void removeLink(NavigationCaseType caseType) {
        PageflowLink link = (PageflowLink)this.mapCases2Links.get(caseType);
        if (link != null) {
            this.removeLink(link);
        }
    }

    void addLink(PageflowPage source, PageflowPage target_, PageflowLink value) {
        if (source != null && target_ != null && value != null) {
            this.createFacesCase(value, source, target_);
        }
    }

    private void cleanPage(PageflowPage source) {
        if (source.getInlinks().size() == 0 && source.getOutlinks().size() == 0) {
            this.removePageflowPage(source);
        }
        source.update();
    }

    void refreshPFAdapter(EObject object) {
        TreeIterator content = object.eAllContents();
        while (content.hasNext()) {
            Object next = content.next();
            this.adapt((EObject)next);
        }
        this.adapt(object);
    }

    void refreshFCAdapter(EObject object) {
        EList rules = this.facesConfig.getNavigationRule();
        if (rules != null) {
            int i = 0;
            while (i < rules.size()) {
                NavigationRuleType rule = (NavigationRuleType)rules.get(i);
                this.adapt((EObject)rule);
                TreeIterator children = rule.eAllContents();
                while (children.hasNext()) {
                    this.adapt((EObject)children.next());
                }
                ++i;
            }
        }
        this.adapt((EObject)this.facesConfig);
    }

    public void setFacesConfig(FacesConfigType facesConfig) {
        this.facesConfig = facesConfig;
        this.refreshFCAdapter((EObject)facesConfig);
    }

    public void setPageflow(Pageflow pageflow) {
        this.pageflow = pageflow;
        pageflow.eAdapters().add((Object)this);
        this.refreshPFAdapter(pageflow);
    }

    public void adapt(EObject object) {
        if (object != null && !this.isAdapted(object)) {
            if (object instanceof PageflowElement) {
                object.eAdapters().add((Object)new PF2FCSynchronizer(this));
            } else {
                object.eAdapters().add((Object)new FC2PFSynchronizer(this));
            }
        }
    }

    public void unAdapt(EObject object) {
        Iterator adapters = object.eAdapters().iterator();
        while (adapters.hasNext()) {
            Object adapter = adapters.next();
            if (!(adapter instanceof FC2PFSynchronizer) && !(adapter instanceof PF2FCSynchronizer)) continue;
            adapters.remove();
        }
    }

    public boolean isAdapted(EObject object) {
        if (object != null) {
            for (Object adapter : object.eAdapters()) {
                if (!(adapter instanceof FC2PFSynchronizer) && !(adapter instanceof PF2FCSynchronizer)) continue;
                return true;
            }
        }
        return false;
    }

    public void clearCaches() {
        this.mapPaths2PF.clear();
        this.mapCases2Links.clear();
    }

    public void dispose() {
        this.clearCaches();
        Pageflow pageFlow = this.getPageflow();
        if (pageFlow != null) {
            pageFlow.dispose();
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void setTarget(Notifier newTarget) {
    }

    public static FromViewIdType getSource(NavigationCaseType caseType) {
        if (caseType.eContainer() instanceof NavigationRuleType) {
            NavigationRuleType rule = (NavigationRuleType)caseType.eContainer();
            return rule.getFromViewId();
        }
        return null;
    }

    private PageflowPage getOrCreateStartPage(NavigationCaseType navCase) {
        PageflowPage startPageflowNode = null;
        String path = "*";
        NavigationRuleType rule = (NavigationRuleType)navCase.eContainer();
        FromViewIdType source = FC2PFTransformer.getSource(navCase);
        if (source != null) {
            path = source.getTextContent();
        }
        if (this.getValidPFPageInCache(path) == null) {
            startPageflowNode = TransformUtil.findPage(path, this.pageflow);
            if (startPageflowNode == null) {
                startPageflowNode = this.createPFPage(path);
                this.pageflowChanged = true;
            }
            this.mapPaths2PF.put(path, startPageflowNode);
            PageflowTransform.getInstance().updatePageflowSourcePage(startPageflowNode, rule);
        } else {
            startPageflowNode = (PageflowPage)this.mapPaths2PF.get(path);
        }
        if (source != null) {
            PageReferenceElement element = new PageReferenceElement(startPageflowNode);
            ((ReferenceElement)element).add((EObject)source);
            startPageflowNode.setReferenceLink(element.resolveReferenceString());
            startPageflowNode.getFCElements().add((EObject)source);
        }
        return startPageflowNode;
    }

    private PageflowPage getOrCreateEndPage(NavigationCaseType navCase) {
        PageflowPage endPageflowNode = null;
        ToViewIdType target_ = navCase.getToViewId();
        if (target_ != null) {
            String path = target_.getTextContent();
            if (this.getValidPFPageInCache(path) == null) {
                endPageflowNode = TransformUtil.findPage(path, this.pageflow);
                if (endPageflowNode == null) {
                    endPageflowNode = this.createPFPage(path);
                    this.pageflowChanged = true;
                }
                this.mapPaths2PF.put(path, endPageflowNode);
                PageflowTransform.getInstance().updatePageflowTargetPage(endPageflowNode, navCase);
            } else {
                endPageflowNode = (PageflowPage)this.mapPaths2PF.get(path);
            }
            if (target_ != null) {
                PageReferenceElement element = new PageReferenceElement(endPageflowNode);
                ((ReferenceElement)element).add((EObject)target_);
                endPageflowNode.setReferenceLink(element.resolveReferenceString());
                endPageflowNode.getFCElements().add((EObject)target_);
            }
        }
        return endPageflowNode;
    }

    private PageflowPage getValidPFPageInCache(Object key) {
        EObject element = (EObject)this.mapPaths2PF.get(key);
        if (!(TransformUtil.isValidPageflowElement(element) && element instanceof PageflowPage && ((PageflowPage)element).getPath().equals(key))) {
            this.mapPaths2PF.remove(key);
            element = null;
        }
        return (PageflowPage)element;
    }

    private PageflowLink getValidPFLinkInCache(EObject caseType) {
        PageflowLink link = (PageflowLink)this.mapCases2Links.get(caseType);
        if (!TransformUtil.isValidLink(link)) {
            this.mapCases2Links.remove(caseType);
            link = null;
        }
        return link;
    }

    public boolean updatePageflowElements(Pageflow pageflow_, NavigationCaseType caseFC) {
        this.pageflowChanged = false;
        this.pageflow = pageflow_;
        ToViewIdType target_ = caseFC.getToViewId();
        if (target_ == null) {
            return false;
        }
        PageflowPage start = null;
        PageflowPage end = null;
        start = this.getOrCreateStartPage(caseFC);
        String action = null;
        if (caseFC.getFromAction() != null) {
            action = caseFC.getFromAction().getTextContent();
        }
        String fromOutCome = null;
        if (caseFC.getFromOutcome() != null) {
            fromOutCome = caseFC.getFromOutcome().getTextContent();
        }
        end = this.getOrCreateEndPage(caseFC);
        PageflowLink link = null;
        link = this.findUnmappedLink(start, end, caseFC);
        if (link == null && end != null) {
            link = this.createPFLink(start, end, action, fromOutCome);
            this.pageflowChanged = true;
        }
        if (link != null) {
            link.getFCElements().clear();
            link.getFCElements().add((EObject)caseFC);
            this.mapCases2Links.put(caseFC, link);
        }
        this.adapt(start);
        this.adapt(end);
        this.adapt((EObject)caseFC);
        this.adapt(link);
        return this.pageflowChanged;
    }

    private boolean cleanPageflowNavigationRule(Pageflow pageflow_) {
        boolean dirty = false;
        EList links = pageflow_.getLinks();
        Iterator linksIterator = links.iterator();
        while (linksIterator.hasNext()) {
            PageflowLink link = (PageflowLink)linksIterator.next();
            if (!link.getFCElements().isEmpty()) continue;
            linksIterator.remove();
            if (link.getSource() != null) {
                link.getSource().getOutlinks().remove((Object)link);
            }
            if (link.getTarget() != null) {
                link.getTarget().getInlinks().remove((Object)link);
            }
            dirty = true;
        }
        return dirty;
    }

    private boolean updateNavigationRulesInPageflowFromFacesConfig(List rulesFC) {
        boolean isNew = false;
        if (rulesFC == null || rulesFC.isEmpty()) {
            for (PageflowLink link : this.pageflow.getLinks()) {
                link.getSource().getOutlinks().remove((Object)link);
                link.getTarget().getInlinks().remove((Object)link);
            }
            this.pageflow.getLinks().clear();
        } else {
            for (NavigationRuleType ruleFC : rulesFC) {
                EList casesFC = ruleFC.getNavigationCase();
                for (NavigationCaseType navigationCaseFC : casesFC) {
                    isNew |= this.updatePageflowElements(this.pageflow, navigationCaseFC);
                }
            }
        }
        return isNew |= this.cleanPageflowNavigationRule(this.pageflow);
    }

    private PageflowLink findUnmappedLink(PageflowPage start, PageflowPage end, NavigationCaseType caseFC) {
        EList links = start.getOutlinks();
        int i = 0;
        int n = links.size();
        while (i < n) {
            PageflowLink link = (PageflowLink)links.get(i);
            if (link.getSource() == start && link.getTarget() == end) {
                link.update();
                if (link.getFCElements().isEmpty() || link.getFCElements().getData().get(0) == caseFC) {
                    return link;
                }
            }
            ++i;
        }
        return null;
    }

    public PageflowLink createPFLink(PageflowNode start, PageflowNode target_, NavigationCaseType caseFC) {
        PageflowLink link = null;
        String fromOutcome = caseFC.getFromOutcome() != null ? caseFC.getFromOutcome().getTextContent() : null;
        String action = caseFC.getFromAction() != null ? caseFC.getFromAction().getTextContent() : null;
        NavigationRuleType rule = (NavigationRuleType)caseFC.eContainer();
        link = this.createPFLink(fromOutcome);
        link.setFromaction(action);
        link.setSource(start);
        link.setTarget(target_);
        start.getOutlinks().add((Object)link);
        target_.getInlinks().add((Object)link);
        link.getFCElements().add((EObject)caseFC);
        start.getFCElements().add((EObject)rule.getFromViewId());
        target_.getFCElements().add((EObject)caseFC.getToViewId());
        return link;
    }

    public PageflowLink createPFLink(String fromOutcome) {
        PageflowLink link = null;
        link = PageflowModelManager.getFactory().createPFLink();
        if (fromOutcome != null && fromOutcome.length() > 0) {
            link.setOutcome(fromOutcome.trim());
        }
        this.pageflow.getLinks().add((Object)link);
        return link;
    }

    public PageflowLink createPFLink(PageflowNode start, PageflowNode target_, String action, String fromOutcome) {
        Assert.isTrue((start != null && target_ != null ? 1 : 0) != 0);
        PageflowLink link = null;
        link = this.createPFLink(fromOutcome);
        link.setFromaction(action);
        link.setSource(start);
        link.setTarget(target_);
        start.getOutlinks().add((Object)link);
        target_.getInlinks().add((Object)link);
        return link;
    }

    public PageflowPage createPFPage(String fromViewID) {
        PageflowPage page = PageflowFactory.eINSTANCE.createPFPage();
        if (fromViewID != null && fromViewID.length() > 0) {
            page.setPath(fromViewID.trim());
            page.setName(WebrootUtil.getPageNameFromWebPath((String)fromViewID.trim()));
        }
        this.pageflow.getNodes().add((Object)page);
        return page;
    }

    public boolean updatePageflowModelFromEMF() {
        if (this.pageflow != null && this.facesConfig != null) {
            EList navigationRulesInFacesconfig = this.facesConfig.getNavigationRule();
            this.clearCaches();
            return this.updateNavigationRulesInPageflowFromFacesConfig((List)navigationRulesInFacesconfig);
        }
        return false;
    }

    void refreshLink(NavigationCaseType caseType) {
        PageflowLink link = this.getValidPFLinkInCache((EObject)caseType);
        if (link != null) {
            this.removeLink(link);
        }
        if (TransformUtil.isValidFacesConfigElement((EObject)caseType)) {
            this.updatePageflowElements(this.pageflow, caseType);
        }
    }

    public void notifyChanged(Notification msg) {
        int type = msg.getEventType();
        switch (type) {
            case 11: {
                this.setNeedBatchOperations(true);
                break;
            }
            case 12: {
                this.setNeedBatchOperations(false);
            }
        }
    }

    public boolean isListenToNotify() {
        return this.listenToNotify && !this.isInEvent;
    }

    public boolean isInEvent() {
        return this.isInEvent;
    }

    public void setInEvent(boolean isInEvent) {
        this.isInEvent = isInEvent;
    }

    public FacesConfigType getFacesConfig() {
        return this.facesConfig;
    }

    public Pageflow getPageflow() {
        return this.pageflow;
    }

    public static FromViewIdType createRLFromViewID(String value) {
        FromViewIdType fromView = FacesConfigFactory.eINSTANCE.createFromViewIdType();
        fromView.setTextContent(value);
        return fromView;
    }

    public static ToViewIdType createFCToViewID(String value) {
        ToViewIdType toView = FacesConfigFactory.eINSTANCE.createToViewIdType();
        toView.setTextContent(value);
        return toView;
    }
}

