/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.FileTools;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classpath
implements Serializable {
    private final Entry[] entries;
    private static final long serialVersionUID = 1L;

    public static Classpath bootClasspath() {
        return new Classpath(System.getProperty("sun.boot.class.path"));
    }

    public static Classpath javaExtensionClasspath() {
        File[] dirs = Classpath.javaExtensionDirectories();
        ArrayList<String> jarFileNames = new ArrayList<String>();
        File[] fileArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (dir.isDirectory()) {
                Classpath.addJarFileNamesTo(dir, jarFileNames);
            }
            ++n2;
        }
        return new Classpath(jarFileNames);
    }

    public static Classpath javaClasspath() {
        return new Classpath(System.getProperty("java.class.path"));
    }

    public static Classpath completeClasspath() {
        return new Classpath(new Classpath[]{Classpath.bootClasspath(), Classpath.javaExtensionClasspath(), Classpath.javaClasspath()});
    }

    public static Classpath classpathFor(Class<?> javaClass) {
        return new Classpath(Classpath.locationFor(javaClass));
    }

    public static String convertToClassName(String classFileName) {
        String className = FileTools.stripExtension(classFileName);
        className = className.replace('/', '.');
        if (File.separatorChar != '/') {
            className = className.replace(File.separatorChar, '.');
        }
        return className;
    }

    public static String convertToClassName(File classFile) {
        return Classpath.convertToClassName(classFile.getPath());
    }

    public static Class<?> convertToClass(String classFileName) throws ClassNotFoundException {
        return Class.forName(Classpath.convertToClassName(classFileName));
    }

    public static Class<?> convertToClass(File classFile) throws ClassNotFoundException {
        return Classpath.convertToClass(classFile.getPath());
    }

    public static String convertToArchiveEntryNameBase(String className) {
        return className.replace('.', '/');
    }

    public static String convertToArchiveEntryNameBase(Class<?> javaClass) {
        return Classpath.convertToArchiveEntryNameBase(javaClass.getName());
    }

    public static String convertToArchiveClassFileEntryName(String className) {
        return String.valueOf(Classpath.convertToArchiveEntryNameBase(className)) + ".class";
    }

    public static String convertToArchiveClassFileEntryName(Class<?> javaClass) {
        return Classpath.convertToArchiveClassFileEntryName(javaClass.getName());
    }

    public static String convertToFileNameBase(String className) {
        return className.replace('.', File.separatorChar);
    }

    public static String convertToFileNameBase(Class<?> javaClass) {
        return Classpath.convertToFileNameBase(javaClass.getName());
    }

    public static String convertToClassFileName(String className) {
        return String.valueOf(Classpath.convertToFileNameBase(className)) + ".class";
    }

    public static String convertToClassFileName(Class<?> javaClass) {
        return Classpath.convertToClassFileName(javaClass.getName());
    }

    public static File convertToClassFile(String className) {
        return new File(Classpath.convertToClassFileName(className));
    }

    public static File convertToClassFile(Class<?> javaClass) {
        return Classpath.convertToClassFile(javaClass.getName());
    }

    public static String convertToJavaFileName(String className) {
        return String.valueOf(Classpath.convertToFileNameBase(className)) + ".java";
    }

    public static String convertToJavaFileName(Class<?> javaClass) {
        return Classpath.convertToJavaFileName(javaClass.getName());
    }

    public static File convertToJavaFile(String className) {
        return new File(Classpath.convertToJavaFileName(className));
    }

    public static File convertToJavaFile(Class<?> javaClass) {
        return Classpath.convertToJavaFile(javaClass.getName());
    }

    public static String convertToResourceName(Class<?> javaClass) {
        return String.valueOf('/') + Classpath.convertToArchiveClassFileEntryName(javaClass);
    }

    public static URL convertToResource(Class<?> javaClass) {
        return javaClass.getResource(Classpath.convertToResourceName(javaClass));
    }

    public static boolean fileNameIsArchive(String fileName) {
        String ext = FileTools.extension(fileName).toLowerCase();
        return ext.equals(".jar") || ext.equals(".zip");
    }

    public static boolean fileIsArchive(File file) {
        return Classpath.fileNameIsArchive(file.getName());
    }

    public static String rtJarName() {
        return Classpath.locationFor(Object.class);
    }

    public static String locationFor(Class<?> javaClass) {
        String path;
        URL url = Classpath.convertToResource(javaClass);
        try {
            path = FileTools.buildFile(url).getPath();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        String protocol = url.getProtocol().toLowerCase();
        if (protocol.equals("jar")) {
            return path.substring(0, path.indexOf(33));
        }
        if (protocol.equals("file")) {
            return path.substring(0, path.length() - Classpath.convertToClassFileName(javaClass).length() - 1);
        }
        if (protocol.equals("bundleresource")) {
            return path.substring(0, path.length() - Classpath.convertToClassFileName(javaClass).length() - 1);
        }
        throw new IllegalStateException(url.toString());
    }

    public static File[] javaExtensionDirectories() {
        return Classpath.convertToFiles(Classpath.javaExtensionDirectoryNames());
    }

    public static String[] javaExtensionDirectoryNames() {
        return System.getProperty("java.ext.dirs").split(File.pathSeparator);
    }

    private static File[] convertToFiles(String[] fileNames) {
        File[] files = new File[fileNames.length];
        int i = fileNames.length;
        while (i-- > 0) {
            files[i] = new File(fileNames[i]);
        }
        return files;
    }

    private static void addJarFileNamesTo(File dir, List<String> jarFileNames) {
        File[] jarFiles;
        File[] fileArray = jarFiles = Classpath.jarFilesIn(dir);
        int n = jarFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File jarFile = fileArray[n2];
            jarFileNames.add(FileTools.canonicalFile(jarFile).getPath());
            ++n2;
        }
    }

    private static File[] jarFilesIn(File directory) {
        return directory.listFiles(Classpath.jarFileFilter());
    }

    private static FileFilter jarFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                return FileTools.extension(file.getName()).toLowerCase().equals(".jar");
            }
        };
    }

    private Classpath(Entry[] entries) {
        this.entries = entries;
    }

    public Classpath(String[] fileNames) {
        this(Classpath.buildEntries(fileNames));
    }

    private static Entry[] buildEntries(String[] fileNames) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName != null && fileName.length() != 0) {
                entries.add(new Entry(fileName));
            }
            ++n2;
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public Classpath(String path) {
        this(path.split(File.pathSeparator));
    }

    public Classpath(List<String> fileNames) {
        this(fileNames.toArray(new String[fileNames.size()]));
    }

    public Classpath(Classpath[] classpaths) {
        this(Classpath.consolidateEntries(classpaths));
    }

    private static Entry[] consolidateEntries(Classpath[] classpaths) {
        ArrayList entries = new ArrayList();
        Classpath[] classpathArray = classpaths;
        int n = classpaths.length;
        int n2 = 0;
        while (n2 < n) {
            Classpath classpath = classpathArray[n2];
            CollectionTools.addAll(entries, classpath.getEntries());
            ++n2;
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public String path() {
        Entry[] localEntries = this.entries;
        int max = localEntries.length - 1;
        if (max == -1) {
            return "";
        }
        StringBuffer sb = new StringBuffer(2000);
        int i = 0;
        while (i < max) {
            sb.append(localEntries[i].fileName());
            sb.append(File.pathSeparatorChar);
            ++i;
        }
        sb.append(localEntries[max].fileName());
        return sb.toString();
    }

    public Entry entryForFileNamed(String shortFileName) {
        Entry[] localEntries;
        Entry[] entryArray = localEntries = this.entries;
        int n = localEntries.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            if (entry.file().getName().equals(shortFileName)) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    public Entry entryForClassNamed(String className) {
        Entry[] localEntries;
        String relativeClassFileName = Classpath.convertToClassFileName(className);
        String archiveEntryName = Classpath.convertToArchiveClassFileEntryName(className);
        Entry[] entryArray = localEntries = this.entries;
        int n = localEntries.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            if (entry.contains(relativeClassFileName, archiveEntryName)) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    public String[] classNames() {
        return this.classNames(Filter.Null.<String>instance());
    }

    public String[] classNames(Filter<String> filter) {
        HashSet<String> classNames = new HashSet<String>(10000);
        this.addClassNamesTo(classNames, filter);
        return classNames.toArray(new String[classNames.size()]);
    }

    public void addClassNamesTo(Collection<String> classNames) {
        this.addClassNamesTo(classNames, Filter.Null.<String>instance());
    }

    public void addClassNamesTo(Collection<String> classNames, Filter<String> filter) {
        Entry[] localEntries;
        Entry[] entryArray = localEntries = this.entries;
        int n = localEntries.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            entry.addClassNamesTo(classNames, filter);
            ++n2;
        }
    }

    public Iterator<String> classNamesStream() {
        return this.classNamesStream(Filter.Null.<String>instance());
    }

    public Iterator<String> classNamesStream(Filter<String> filter) {
        return new CompositeIterator<String>(this.entryClassNamesStreams(filter));
    }

    private Iterator<Iterator<String>> entryClassNamesStreams(final Filter<String> filter) {
        return new TransformationIterator<Entry, Iterator<String>>(new ArrayIterator<Entry>(this.entries)){

            @Override
            protected Iterator<String> transform(Entry entry) {
                return entry.classNamesStream(filter);
            }
        };
    }

    public Classpath compressed() {
        return new Classpath(CollectionTools.removeDuplicateElements(this.entries));
    }

    public URL[] urls() {
        Entry[] localEntries = this.entries;
        int len = localEntries.length;
        URL[] urls = new URL[len];
        int i = 0;
        while (i < len) {
            urls[i] = localEntries[i].url();
            ++i;
        }
        return urls;
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.path());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry
    implements Serializable {
        private final String fileName;
        private final File file;
        private final File canonicalFile;
        private static final long serialVersionUID = 1L;

        Entry(String fileName) {
            if (fileName == null || fileName.length() == 0) {
                throw new IllegalArgumentException("'fileName' must be non-empty");
            }
            this.fileName = fileName;
            this.file = new File(fileName);
            this.canonicalFile = FileTools.canonicalFile(this.file);
        }

        public String fileName() {
            return this.fileName;
        }

        public File file() {
            return this.file;
        }

        public File canonicalFile() {
            return this.canonicalFile;
        }

        public String canonicalFileName() {
            return this.canonicalFile.getAbsolutePath();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            return ((Entry)o).canonicalFile.equals(this.canonicalFile);
        }

        public int hashCode() {
            return this.canonicalFile.hashCode();
        }

        public URL url() {
            try {
                return this.canonicalFile.toURL();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean contains(Class<?> javaClass) {
            return this.contains(javaClass.getName());
        }

        public boolean contains(String className) {
            return this.contains(Classpath.convertToClassFileName(className), Classpath.convertToArchiveClassFileEntryName(className));
        }

        boolean contains(String relativeClassFileName, String archiveEntryName) {
            if (!this.canonicalFile.exists()) {
                return false;
            }
            if (this.canonicalFile.isDirectory() && new File(this.canonicalFile, relativeClassFileName).exists()) {
                return true;
            }
            return Classpath.fileIsArchive(this.canonicalFile) && this.archiveContainsEntry(archiveEntryName);
        }

        private boolean archiveContainsEntry(String zipEntryName) {
            ZipEntry zipEntry;
            block14: {
                ZipFile zipFile = null;
                zipEntry = null;
                try {
                    try {
                        zipFile = new ZipFile(this.canonicalFile);
                        zipEntry = zipFile.getEntry(zipEntryName);
                    }
                    catch (IOException iOException) {
                        zipEntry = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                            break block14;
                        }
                        catch (IOException iOException2) {
                            zipEntry = null;
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException iOException) {
                        zipEntry = null;
                    }
                    throw throwable;
                }
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {
                    zipEntry = null;
                }
            }
            return zipEntry != null;
        }

        public String[] classNames() {
            return this.classNames(Filter.Null.<String>instance());
        }

        public String[] classNames(Filter<String> filter) {
            ArrayList<String> classNames = new ArrayList<String>(2000);
            this.addClassNamesTo(classNames, filter);
            return classNames.toArray(new String[classNames.size()]);
        }

        public void addClassNamesTo(Collection<String> classNames) {
            this.addClassNamesTo(classNames, Filter.Null.<String>instance());
        }

        public void addClassNamesTo(Collection<String> classNames, Filter<String> filter) {
            if (this.canonicalFile.exists()) {
                if (this.canonicalFile.isDirectory()) {
                    this.addClassNamesForDirectoryTo(classNames, filter);
                } else if (Classpath.fileIsArchive(this.canonicalFile)) {
                    this.addClassNamesForArchiveTo(classNames, filter);
                }
            }
        }

        private void addClassNamesForDirectoryTo(Collection<String> classNames, Filter<String> filter) {
            int start = this.canonicalFile.getAbsolutePath().length() + 1;
            Iterator<File> stream = this.classFilesForDirectory();
            while (stream.hasNext()) {
                String className = Classpath.convertToClassName(stream.next().getAbsolutePath().substring(start));
                if (!filter.accept(className)) continue;
                classNames.add(className);
            }
        }

        private Iterator<File> classFilesForDirectory() {
            return new FilteringIterator<File>(FileTools.filesInTree(this.canonicalFile)){

                @Override
                protected boolean accept(Object next) {
                    return Entry.this.fileNameMightBeForClassFile(((File)next).getName());
                }
            };
        }

        private void addClassNamesForArchiveTo(Collection<String> classNames, Filter<String> filter) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(this.canonicalFile);
            }
            catch (IOException iOException) {
                return;
            }
            Enumeration<? extends ZipEntry> stream = zipFile.entries();
            while (stream.hasMoreElements()) {
                String className;
                ZipEntry zipEntry = stream.nextElement();
                String zipEntryName = zipEntry.getName();
                if (!this.fileNameMightBeForClassFile(zipEntryName) || !filter.accept(className = Classpath.convertToClassName(zipEntryName))) continue;
                classNames.add(className);
            }
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                return;
            }
        }

        boolean fileNameMightBeForClassFile(String name) {
            return FileTools.extension(name).toLowerCase().equals(".class") && name.indexOf(32) == -1;
        }

        public Iterator<String> classNamesStream() {
            return this.classNamesStream(Filter.Null.<String>instance());
        }

        public Iterator<String> classNamesStream(Filter<String> filter) {
            if (this.canonicalFile.exists()) {
                if (this.canonicalFile.isDirectory()) {
                    return this.classNamesForDirectory(filter);
                }
                if (Classpath.fileIsArchive(this.canonicalFile)) {
                    return this.classNamesForArchive(filter);
                }
            }
            return EmptyIterator.instance();
        }

        private Iterator<String> classNamesForDirectory(Filter<String> filter) {
            return new FilteringIterator<String>(this.classNamesForDirectory(), filter);
        }

        private Iterator<String> classNamesForDirectory() {
            final int start = this.canonicalFile.getAbsolutePath().length() + 1;
            return new TransformationIterator<File, String>(this.classFilesForDirectory()){

                @Override
                protected String transform(File f) {
                    return Classpath.convertToClassName(f.getAbsolutePath().substring(start));
                }
            };
        }

        private Iterator<String> classNamesForArchive(Filter<String> filter) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(this.canonicalFile);
            }
            catch (IOException iOException) {
                return EmptyIterator.instance();
            }
            HashSet<String> classNames = new HashSet<String>(zipFile.size());
            Enumeration<? extends ZipEntry> stream = zipFile.entries();
            while (stream.hasMoreElements()) {
                String className;
                ZipEntry zipEntry = stream.nextElement();
                String zipEntryName = zipEntry.getName();
                if (!this.fileNameMightBeForClassFile(zipEntryName) || !filter.accept(className = Classpath.convertToClassName(zipEntryName))) continue;
                classNames.add(className);
            }
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                return EmptyIterator.instance();
            }
            return classNames.iterator();
        }
    }
}

