/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.jpt.utility.internal.Bag;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.Range;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionTools {
    private static final Random RANDOM = new Random();

    public static <E> E[] add(E[] array, E value) {
        int len = array.length;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), len + 1);
        System.arraycopy(array, 0, result, 0, len);
        result[len] = value;
        return result;
    }

    public static <E> E[] add(E[] array, int index, E value) {
        int len = array.length;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), len + 1);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        result[index] = value;
        if (len > index) {
            System.arraycopy(array, index, result, index + 1, len - index);
        }
        return result;
    }

    public static char[] add(char[] array, char value) {
        int len = array.length;
        char[] result = new char[len + 1];
        System.arraycopy(array, 0, result, 0, len);
        result[len] = value;
        return result;
    }

    public static char[] add(char[] array, int index, char value) {
        int len = array.length;
        char[] result = new char[len + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, len - index);
        return result;
    }

    public static int[] add(int[] array, int value) {
        int len = array.length;
        int[] result = new int[len + 1];
        System.arraycopy(array, 0, result, 0, len);
        result[len] = value;
        return result;
    }

    public static int[] add(int[] array, int index, int value) {
        int len = array.length;
        int[] result = new int[len + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, len - index);
        return result;
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterator<E> iterator) {
        boolean modified = false;
        while (iterator.hasNext()) {
            modified |= collection.add(iterator.next());
        }
        return modified;
    }

    public static <E> boolean addAll(Collection<? super E> collection, E[] array) {
        boolean modified = false;
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            modified |= collection.add(item);
            ++n2;
        }
        return modified;
    }

    public static <E> E[] addAll(E[] array, Collection<? extends E> collection) {
        int len = array.length;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + collection.size());
        System.arraycopy(array, 0, result, 0, len);
        int i = len;
        for (E item : collection) {
            result[i++] = item;
        }
        return result;
    }

    public static <E> E[] addAll(E[] array, Iterator<? extends E> iterator) {
        return CollectionTools.addAll(array, (Collection)CollectionTools.list(iterator));
    }

    public static <E> E[] addAll(E[] array1, E[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        Object[] result = (Object[])Array.newInstance(array1.getClass().getComponentType(), len1 + len2);
        System.arraycopy(array1, 0, result, 0, len1);
        System.arraycopy(array2, 0, result, len1, len2);
        return result;
    }

    public static <E> E[] addAll(E[] array1, int index, E[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        Object[] result = (Object[])Array.newInstance(array1.getClass().getComponentType(), len1 + len2);
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, len2);
        System.arraycopy(array1, index, result, index + len2, len1 - index);
        return result;
    }

    public static char[] addAll(char[] array1, char[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        char[] result = new char[len1 + len2];
        System.arraycopy(array1, 0, result, 0, len1);
        System.arraycopy(array2, 0, result, len1, len2);
        return result;
    }

    public static char[] addAll(char[] array1, int index, char[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        char[] result = new char[len1 + len2];
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, len2);
        System.arraycopy(array1, index, result, index + len2, len1 - index);
        return result;
    }

    public static int[] addAll(int[] array1, int[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        int[] result = new int[len1 + len2];
        System.arraycopy(array1, 0, result, 0, len1);
        System.arraycopy(array2, 0, result, len1, len2);
        return result;
    }

    public static int[] addAll(int[] array1, int index, int[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        int[] result = new int[len1 + len2];
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, len2);
        System.arraycopy(array1, index, result, index + len2, len1 - index);
        return result;
    }

    public static Object[] array(Iterator<?> iterator) {
        return CollectionTools.list(iterator).toArray();
    }

    public static <E> E[] array(Iterator<? extends E> iterator, E[] array) {
        return CollectionTools.list(iterator).toArray(array);
    }

    public static <E> Bag<E> bag(Enumeration<? extends E> enumeration) {
        HashBag<E> bag = new HashBag<E>();
        while (enumeration.hasMoreElements()) {
            bag.add(enumeration.nextElement());
        }
        return bag;
    }

    public static <E> Bag<E> bag(Iterator<? extends E> iterator) {
        HashBag<E> bag = new HashBag<E>();
        while (iterator.hasNext()) {
            bag.add(iterator.next());
        }
        return bag;
    }

    public static <E> Bag<E> bag(E ... array) {
        HashBag<E> bag = new HashBag<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            bag.add(item);
            ++n2;
        }
        return bag;
    }

    public static <E> Collection<E> collection(Enumeration<? extends E> enumeration) {
        return CollectionTools.bag(enumeration);
    }

    public static <E> Collection<E> collection(Iterator<? extends E> iterator) {
        return CollectionTools.bag(iterator);
    }

    public static <E> Collection<E> collection(E ... array) {
        return CollectionTools.bag(array);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Enumeration<?> enumeration, Object value) {
        block2: {
            if (value != null) ** GOTO lbl8
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(enumeration.nextElement())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (enumeration.hasMoreElements())
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Iterator<?> iterator, Object value) {
        block2: {
            if (value != null) ** GOTO lbl8
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(iterator.next())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (iterator.hasNext())
            }
        }
        return false;
    }

    public static boolean contains(Object[] array, Object value) {
        if (value == null) {
            int i = array.length;
            while (i-- > 0) {
                if (array[i] != null) continue;
                return true;
            }
        } else {
            int i = array.length;
            while (i-- > 0) {
                if (!value.equals(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(char[] array, char value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection<?> collection, Iterator<?> iterator) {
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection<?> collection, Object[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (collection.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Iterator<?> iterator, Collection<?> collection) {
        return CollectionTools.collection(iterator).containsAll(collection);
    }

    public static boolean containsAll(Iterator<?> iterator1, Iterator<?> iterator2) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator1), iterator2);
    }

    public static boolean containsAll(Iterator<?> iterator, Object[] array) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator), array);
    }

    public static boolean containsAll(Object[] array, Collection<?> collection) {
        return CollectionTools.containsAll(array, collection.iterator());
    }

    public static boolean containsAll(Object[] array, Iterator<?> iterator) {
        while (iterator.hasNext()) {
            if (CollectionTools.contains(array, iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Object[] array1, Object[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (CollectionTools.contains(array1, array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(char[] array1, char[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (CollectionTools.contains(array1, array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(int[] array1, int[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (CollectionTools.contains(array1, array2[i])) continue;
            return false;
        }
        return true;
    }

    public static int diffEnd(Object[] array1, Object[] array2) {
        return CollectionTools.diffEnd(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int diffEnd(List<?> list1, List<?> list2) {
        int size2;
        int size1 = list1.size();
        if (size1 != (size2 = list2.size())) {
            return Math.max(size1, size2) - 1;
        }
        int end = size1 - 1;
        while (end > -1) {
            Object o = list1.get(end);
            if (o == null) {
                if (list2.get(end) == null) {
                    --end;
                    continue;
                }
                return end;
            }
            if (o.equals(list2.get(end))) {
                --end;
                continue;
            }
            return end;
        }
        return end;
    }

    public static Range diffRange(Object[] array1, Object[] array2) {
        return CollectionTools.diffRange(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static Range diffRange(List<?> list1, List<?> list2) {
        int end = CollectionTools.diffEnd(list1, list2);
        if (end == -1) {
            return new Range(list1.size(), end);
        }
        return new Range(CollectionTools.diffStart(list1, list2), end);
    }

    public static int diffStart(Object[] array1, Object[] array2) {
        return CollectionTools.diffStart(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int diffStart(List<?> list1, List<?> list2) {
        int end = Math.min(list1.size(), list2.size());
        int start = 0;
        while (start < end) {
            Object o = list1.get(start);
            if (o == null) {
                if (list2.get(start) == null) {
                    ++start;
                    continue;
                }
                return start;
            }
            if (o.equals(list2.get(start))) {
                ++start;
                continue;
            }
            return start;
        }
        return start;
    }

    public static boolean equals(ListIterator<?> iterator1, ListIterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Object o1 = iterator1.next();
            Object o2 = iterator2.next();
            if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static <E> E get(ListIterator<E> iterator, int index) {
        while (iterator.hasNext()) {
            E next = iterator.next();
            if (iterator.previousIndex() != index) continue;
            return next;
        }
        throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(index)) + ':' + String.valueOf(iterator.previousIndex()));
    }

    public static boolean identical(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        int length = array1.length;
        if (array2.length != length) {
            return false;
        }
        int i = length;
        while (i-- > 0) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(ListIterator<?> iterator1, ListIterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (iterator1.next() == iterator2.next()) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static int identityDiffEnd(Object[] array1, Object[] array2) {
        return CollectionTools.identityDiffEnd(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int identityDiffEnd(List<?> list1, List<?> list2) {
        int end;
        int size2;
        int size1 = list1.size();
        if (size1 != (size2 = list2.size())) {
            return Math.max(size1, size2) - 1;
        }
        for (end = size1 - 1; end > -1; --end) {
            if (list1.get(end) == list2.get(end)) {
                continue;
            }
            return end;
        }
        return end;
    }

    public static Range identityDiffRange(Object[] array1, Object[] array2) {
        return CollectionTools.identityDiffRange(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static Range identityDiffRange(List<?> list1, List<?> list2) {
        int end = CollectionTools.identityDiffEnd(list1, list2);
        if (end == -1) {
            return new Range(list1.size(), end);
        }
        return new Range(CollectionTools.identityDiffStart(list1, list2), end);
    }

    public static int identityDiffStart(Object[] array1, Object[] array2) {
        return CollectionTools.identityDiffStart(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int identityDiffStart(List<?> list1, List<?> list2) {
        int start;
        int end = Math.min(list1.size(), list2.size());
        for (start = 0; start < end; ++start) {
            if (list1.get(start) == list2.get(start)) {
                continue;
            }
            return start;
        }
        return start;
    }

    public static int indexOf(ListIterator<?> iterator, Object value) {
        if (value == null) {
            int i = 0;
            while (iterator.hasNext()) {
                if (iterator.next() == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                if (value.equals(iterator.next())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object value) {
        int len = array.length;
        if (value == null) {
            int i = 0;
            while (i < len) {
                if (array[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (value.equals(array[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] array, char value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <E extends Comparable<? super E>> int insertionIndexOf(List<E> sortedList, Comparable<E> value) {
        int len = sortedList.size();
        int i = 0;
        while (i < len) {
            if (value.compareTo((Comparable)sortedList.get(i)) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static <E> int insertionIndexOf(List<E> sortedList, E value, Comparator<? super E> comparator) {
        int len = sortedList.size();
        int i = 0;
        while (i < len) {
            if (comparator.compare(value, sortedList.get(i)) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static <E extends Comparable<? super E>> int insertionIndexOf(E[] sortedArray, Comparable<E> value) {
        int len = sortedArray.length;
        int i = 0;
        while (i < len) {
            if (value.compareTo(sortedArray[i]) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static <E> int insertionIndexOf(E[] sortedArray, E value, Comparator<? super E> comparator) {
        int len = sortedArray.length;
        int i = 0;
        while (i < len) {
            if (comparator.compare(value, sortedArray[i]) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static <E> Iterator<E> iterator(E ... array) {
        return new ArrayIterator<E>(array);
    }

    public static int lastIndexOf(ListIterator<?> iterator, Object value) {
        return CollectionTools.list(iterator).lastIndexOf(value);
    }

    public static int lastIndexOf(Object[] array, Object value) {
        int len = array.length;
        if (value == null) {
            int i = len;
            while (i-- > 0) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            int i = len;
            while (i-- > 0) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static <E> List<E> list(Iterator<? extends E> iterator) {
        ArrayList<E> list = new ArrayList<E>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <E> List<E> list(E ... array) {
        ArrayList<E> list = new ArrayList<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            list.add(item);
            ++n2;
        }
        return list;
    }

    public static <E> ListIterator<E> listIterator(E ... array) {
        return CollectionTools.listIterator(array, 0);
    }

    public static <E> ListIterator<E> listIterator(E[] array, int index) {
        return Arrays.asList(array).listIterator(index);
    }

    public static char max(char ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        char max = array[0];
        int i = 1;
        while (i < len) {
            char next = array[i];
            if (next > max) {
                max = next;
            }
            ++i;
        }
        return max;
    }

    public static int max(int ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int max = array[0];
        int i = 1;
        while (i < len) {
            int next = array[i];
            if (next > max) {
                max = next;
            }
            ++i;
        }
        return max;
    }

    public static char min(char ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        char min = array[0];
        int i = 1;
        while (i < len) {
            char next = array[i];
            if (next < min) {
                min = next;
            }
            ++i;
        }
        return min;
    }

    public static int min(int ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int min = array[0];
        int i = 1;
        while (i < len) {
            int next = array[i];
            if (next < min) {
                min = next;
            }
            ++i;
        }
        return min;
    }

    public static <E> E[] replaceAll(E[] array, Object oldValue, E newValue) {
        if (oldValue == null) {
            int i = array.length;
            while (i-- > 0) {
                if (array[i] != null) continue;
                array[i] = newValue;
            }
        } else {
            int i = array.length;
            while (i-- > 0) {
                if (!oldValue.equals(array[i])) continue;
                array[i] = newValue;
            }
        }
        return array;
    }

    public static int[] replaceAll(int[] array, int oldValue, int newValue) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != oldValue) continue;
            array[i] = newValue;
        }
        return array;
    }

    public static char[] replaceAll(char[] array, char oldValue, char newValue) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != oldValue) continue;
            array[i] = newValue;
        }
        return array;
    }

    public static <E> E[] remove(E[] array, Object value) {
        return CollectionTools.removeElementAtIndex(array, CollectionTools.indexOf(array, value));
    }

    public static char[] remove(char[] array, char value) {
        return CollectionTools.removeElementAtIndex(array, CollectionTools.indexOf(array, value));
    }

    public static int[] remove(int[] array, int value) {
        return CollectionTools.removeElementAtIndex(array, CollectionTools.indexOf(array, value));
    }

    public static boolean removeAll(Collection<?> collection, Iterator<?> iterator) {
        boolean modified = false;
        while (iterator.hasNext()) {
            modified |= CollectionTools.removeAllOccurrences(collection, iterator.next());
        }
        return modified;
    }

    public static boolean removeAll(Collection<?> collection, Object[] array) {
        boolean modified = false;
        int i = array.length;
        while (i-- > 0) {
            modified |= CollectionTools.removeAllOccurrences(collection, array[i]);
        }
        return modified;
    }

    public static <E> E[] removeAll(E[] array, Collection<?> collection) {
        E[] result = array;
        int i = array.length;
        while (i-- > 0) {
            E item = array[i];
            if (!collection.contains(item)) continue;
            result = CollectionTools.removeElementAtIndex(result, i);
        }
        return result;
    }

    public static <E> E[] removeAll(E[] array1, Object[] array2) {
        return CollectionTools.removeAll(array1, (Collection)CollectionTools.bag(array2));
    }

    public static char[] removeAll(char[] array1, char[] array2) {
        char[] result1 = array1;
        int i = array1.length;
        while (i-- > 0) {
            char item = array1[i];
            if (!CollectionTools.contains(array2, item)) continue;
            result1 = CollectionTools.removeElementAtIndex(result1, i);
        }
        return result1;
    }

    public static int[] removeAll(int[] array1, int[] array2) {
        int[] result1 = array1;
        int i = array1.length;
        while (i-- > 0) {
            int item = array1[i];
            if (!CollectionTools.contains(array2, item)) continue;
            result1 = CollectionTools.removeElementAtIndex(result1, i);
        }
        return result1;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean removeAllOccurrences(Collection<?> collection, Object value) {
        block2: {
            modified = false;
            stream = collection.iterator();
            if (value != null) ** GOTO lbl13
            while (stream.hasNext()) {
                if (stream.next() != null) continue;
                stream.remove();
                modified = true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(stream.next())) continue;
                stream.remove();
                modified = true;
lbl13:
                // 3 sources

                ** while (stream.hasNext())
            }
        }
        return modified;
    }

    public static <E> E[] removeAllOccurrences(E[] array, Object value) {
        E[] result = array;
        if (value == null) {
            int i = array.length;
            while (i-- > 0) {
                if (array[i] != null) continue;
                result = CollectionTools.removeElementAtIndex(result, i);
            }
        } else {
            int i = array.length;
            while (i-- > 0) {
                if (!value.equals(array[i])) continue;
                result = CollectionTools.removeElementAtIndex(result, i);
            }
        }
        return result;
    }

    public static char[] removeAllOccurrences(char[] array, char value) {
        char[] result = array;
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            result = CollectionTools.removeElementAtIndex(result, i);
        }
        return result;
    }

    public static int[] removeAllOccurrences(int[] array, int value) {
        int[] result = array;
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            result = CollectionTools.removeElementAtIndex(result, i);
        }
        return result;
    }

    public static <E> E[] removeElementAtIndex(E[] array, int index) {
        int len = array.length;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), len - 1);
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, len - index - 1);
        return result;
    }

    public static char[] removeElementAtIndex(char[] array, int index) {
        int len = array.length;
        char[] result = new char[len - 1];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, len - index - 1);
        return result;
    }

    public static int[] removeElementAtIndex(int[] array, int index) {
        int len = array.length;
        int[] result = new int[len - 1];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, len - index - 1);
        return result;
    }

    public static <E> E[] removeDuplicateElements(E ... array) {
        List<E> list = CollectionTools.removeDuplicateElements(Arrays.asList(array));
        return list.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), list.size()));
    }

    public static <E> List<E> removeDuplicateElements(List<E> list) {
        ArrayList<E> result = new ArrayList<E>(list.size());
        HashSet<E> set = new HashSet<E>(list.size());
        for (E item : list) {
            if (!set.add(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static boolean retainAll(Collection<?> collection, Iterator<?> iterator) {
        return collection.retainAll(CollectionTools.collection(iterator));
    }

    public static boolean retainAll(Collection<?> collection, Object[] array) {
        return collection.retainAll((Collection)CollectionTools.set(array));
    }

    public static <E> E[] retainAll(E[] array, Collection<?> collection) {
        E[] result = array;
        int i = array.length;
        while (i-- > 0) {
            if (collection.contains(array[i])) continue;
            result = CollectionTools.removeElementAtIndex(result, i);
        }
        return result;
    }

    public static <E> E[] retainAll(E[] array1, Object[] array2) {
        return CollectionTools.retainAll(array1, (Collection)CollectionTools.bag(array2));
    }

    public static char[] retainAll(char[] array1, char[] array2) {
        char[] result1 = array1;
        int i = array1.length;
        while (i-- > 0) {
            char item = array1[i];
            if (CollectionTools.contains(array2, item)) continue;
            result1 = CollectionTools.removeElementAtIndex(result1, i);
        }
        return result1;
    }

    public static int[] retainAll(int[] array1, int[] array2) {
        int[] result1 = array1;
        int i = array1.length;
        while (i-- > 0) {
            int item = array1[i];
            if (CollectionTools.contains(array2, item)) continue;
            result1 = CollectionTools.removeElementAtIndex(result1, i);
        }
        return result1;
    }

    public static <E> E[] reverse(E ... array) {
        int len = array.length;
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            CollectionTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static char[] reverse(char ... array) {
        int len = array.length;
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            CollectionTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static int[] reverse(int ... array) {
        int len = array.length;
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            CollectionTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static <E> List<E> reverseList(Iterator<? extends E> iterator) {
        return CollectionTools.reverse(CollectionTools.list(iterator));
    }

    public static <E> E[] rotate(E ... array) {
        return CollectionTools.rotate(array, 1);
    }

    public static <E> E[] rotate(E[] array, int distance) {
        int len = array.length;
        if (len == 0) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            E displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                E temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static char[] rotate(char ... array) {
        return CollectionTools.rotate(array, 1);
    }

    public static char[] rotate(char[] array, int distance) {
        int len = array.length;
        if (len == 0) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            char displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                char temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static int[] rotate(int ... array) {
        return CollectionTools.rotate(array, 1);
    }

    public static int[] rotate(int[] array, int distance) {
        int len = array.length;
        if (len == 0) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            int displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                int temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static <E> Set<E> set(Iterator<? extends E> iterator) {
        HashSet<E> set = new HashSet<E>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <E> Set<E> set(E ... array) {
        HashSet<E> set = new HashSet<E>(2 * array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            set.add(item);
            ++n2;
        }
        return set;
    }

    public static <E> E[] shuffle(E ... array) {
        return CollectionTools.shuffle(array, RANDOM);
    }

    public static <E> E[] shuffle(E[] array, Random random) {
        int len;
        int i = len = array.length;
        while (i-- > 0) {
            CollectionTools.swap(array, i, random.nextInt(len));
        }
        return array;
    }

    public static char[] shuffle(char ... array) {
        return CollectionTools.shuffle(array, RANDOM);
    }

    public static char[] shuffle(char[] array, Random random) {
        int len;
        int i = len = array.length;
        while (i-- > 0) {
            CollectionTools.swap(array, i, random.nextInt(len));
        }
        return array;
    }

    public static int[] shuffle(int ... array) {
        return CollectionTools.shuffle(array, RANDOM);
    }

    public static int[] shuffle(int[] array, Random random) {
        int len;
        int i = len = array.length;
        while (i-- > 0) {
            CollectionTools.swap(array, i, random.nextInt(len));
        }
        return array;
    }

    public static <E> Iterator<E> singletonIterator(E value) {
        return new SingleElementIterator<E>(value);
    }

    public static int size(Iterator<?> iterator) {
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public static <E extends Comparable<? super E>> SortedSet<E> sortedSet(Iterator<? extends E> iterator) {
        return CollectionTools.sortedSet(iterator, null);
    }

    public static <E> SortedSet<E> sortedSet(Iterator<? extends E> iterator, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(CollectionTools.list(iterator));
        return sortedSet;
    }

    public static <E extends Comparable<? super E>> SortedSet<E> sortedSet(E ... array) {
        return CollectionTools.sortedSet(array, null);
    }

    public static <E> SortedSet<E> sortedSet(E[] array, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(Arrays.asList(array));
        return sortedSet;
    }

    public static <E> E[] swap(E[] array, int i, int j) {
        E temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static char[] swap(char[] array, int i, int j) {
        char temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static int[] swap(int[] array, int i, int j) {
        int temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static <E> Vector<E> vector(Iterator<? extends E> iterator) {
        Vector<E> v = new Vector<E>();
        while (iterator.hasNext()) {
            v.addElement(iterator.next());
        }
        return v;
    }

    public static <E> Vector<E> vector(E ... array) {
        int len = array.length;
        Vector<E> v = new Vector<E>(len);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            v.addElement(item);
            ++n2;
        }
        return v;
    }

    public static <E> List<? super E> copy(List<? super E> dest, List<? extends E> src) {
        Collections.copy(dest, src);
        return dest;
    }

    public static <E> List<? super E> fill(List<? super E> list, E value) {
        Collections.fill(list, value);
        return list;
    }

    public static <E> List<E> reverse(List<E> list) {
        Collections.reverse(list);
        return list;
    }

    public static <E> List<E> rotate(List<E> list) {
        return CollectionTools.rotate(list, 1);
    }

    public static <E> List<E> rotate(List<E> list, int distance) {
        Collections.rotate(list, distance);
        return list;
    }

    public static <E> List<E> shuffle(List<E> list) {
        Collections.shuffle(list);
        return list;
    }

    public static <E> List<E> shuffle(List<E> list, Random random) {
        Collections.shuffle(list, random);
        return list;
    }

    public static <E extends Comparable<? super E>> List<E> sort(List<E> list) {
        Collections.sort(list);
        return list;
    }

    public static <E> List<E> sort(List<E> list, Comparator<? super E> comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public static <E extends Comparable<? super E>> Iterator<E> sort(Iterator<E> iterator) {
        return CollectionTools.sort(iterator, null);
    }

    public static <E> Iterator<E> sort(Iterator<E> iterator, Comparator<? super E> comparator) {
        return CollectionTools.sort(CollectionTools.list(iterator), comparator).iterator();
    }

    public static <E> List<E> swap(List<E> list, int i, int j) {
        Collections.swap(list, i, j);
        return list;
    }

    public static boolean[] fill(boolean[] array, boolean value) {
        Arrays.fill(array, value);
        return array;
    }

    public static boolean[] fill(boolean[] array, int fromIndex, int toIndex, boolean value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static byte[] fill(byte[] array, byte value) {
        Arrays.fill(array, value);
        return array;
    }

    public static byte[] fill(byte[] array, int fromIndex, int toIndex, byte value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static char[] fill(char[] array, char value) {
        Arrays.fill(array, value);
        return array;
    }

    public static char[] fill(char[] array, int fromIndex, int toIndex, char value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static double[] fill(double[] array, double value) {
        Arrays.fill(array, value);
        return array;
    }

    public static double[] fill(double[] array, int fromIndex, int toIndex, double value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static float[] fill(float[] array, float value) {
        Arrays.fill(array, value);
        return array;
    }

    public static float[] fill(float[] array, int fromIndex, int toIndex, float value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static int[] fill(int[] array, int value) {
        Arrays.fill(array, value);
        return array;
    }

    public static int[] fill(int[] array, int fromIndex, int toIndex, int value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static <E> E[] fill(E[] array, E value) {
        Arrays.fill(array, value);
        return array;
    }

    public static <E> E[] fill(E[] array, int fromIndex, int toIndex, E value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static long[] fill(long[] array, long value) {
        Arrays.fill(array, value);
        return array;
    }

    public static long[] fill(long[] array, int fromIndex, int toIndex, long value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static short[] fill(short[] array, short value) {
        Arrays.fill(array, value);
        return array;
    }

    public static short[] fill(short[] array, int fromIndex, int toIndex, short value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static byte[] sort(byte ... array) {
        Arrays.sort(array);
        return array;
    }

    public static byte[] sort(byte[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static char[] sort(char ... array) {
        Arrays.sort(array);
        return array;
    }

    public static char[] sort(char[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static double[] sort(double ... array) {
        Arrays.sort(array);
        return array;
    }

    public static double[] sort(double[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static float[] sort(float ... array) {
        Arrays.sort(array);
        return array;
    }

    public static float[] sort(float[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static int[] sort(int ... array) {
        Arrays.sort(array);
        return array;
    }

    public static int[] sort(int[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static <E> E[] sort(E ... array) {
        Arrays.sort(array);
        return array;
    }

    public static <E> E[] sort(E[] array, Comparator<? super E> comparator) {
        Arrays.sort(array, comparator);
        return array;
    }

    public static <E> E[] sort(E[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static <E> E[] sort(E[] array, int fromIndex, int toIndex, Comparator<? super E> comparator) {
        Arrays.sort(array, fromIndex, toIndex, comparator);
        return array;
    }

    public static long[] sort(long ... array) {
        Arrays.sort(array);
        return array;
    }

    public static long[] sort(long[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static short[] sort(short ... array) {
        Arrays.sort(array);
        return array;
    }

    public static short[] sort(short[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    private CollectionTools() {
        throw new UnsupportedOperationException();
    }
}

