/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.adapter.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.IStartup;
import org.eclipse.wst.server.preview.adapter.internal.core.Trace;

public class PreviewStartup
implements IStartup {
    private static final String ID = "xyz";

    public void startup() {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        IRuntime runtime = null;
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            if (runtimes[i].getRuntimeType() != null && "org.eclipse.wst.server.preview.runtime".equals(runtimes[i].getRuntimeType().getId()) && ID.equals(runtimes[i].getId())) {
                runtime = runtimes[i];
            }
            ++i;
        }
        if (runtime == null) {
            try {
                IRuntimeType runtimeType = ServerCore.findRuntimeType((String)"org.eclipse.wst.server.preview.runtime");
                IRuntimeWorkingCopy wc = runtimeType.createRuntime(ID, null);
                wc.setName("My Preview");
                wc.setReadOnly(true);
                runtime = wc.save(true, null);
            }
            catch (CoreException coreException) {
                Trace.trace(Trace.WARNING, "Could not create default preview runtime");
            }
        }
        IServer[] servers = ServerCore.getServers();
        boolean found = false;
        size = servers.length;
        int i2 = 0;
        while (i2 < size) {
            if (servers[i2].getServerType() != null && "org.eclipse.wst.server.preview.server".equals(servers[i2].getServerType().getId()) && ID.equals(servers[i2].getId())) {
                found = true;
            }
            ++i2;
        }
        if (!found) {
            try {
                IServerType serverType = ServerCore.findServerType((String)"org.eclipse.wst.server.preview.server");
                IServerWorkingCopy wc = serverType.createServer(ID, null, runtime, null);
                wc.setName("My preview");
                wc.setHost("localhost");
                wc.setReadOnly(true);
                wc.save(true, null);
            }
            catch (CoreException coreException) {
                Trace.trace(Trace.WARNING, "Could not create default preview server");
            }
        }
    }
}

