/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.ui.internal.IJpaPlatformUi;
import org.eclipse.jpt.ui.internal.details.IJpaDetailsProvider;
import org.eclipse.jpt.ui.internal.generic.EntitiesGenerator;
import org.eclipse.jpt.ui.internal.java.details.JavaDetailsProvider;
import org.eclipse.jpt.ui.internal.java.structure.JavaStructureProvider;
import org.eclipse.jpt.ui.internal.structure.IJpaStructureProvider;
import org.eclipse.jpt.ui.internal.xml.details.XmlDetailsProvider;
import org.eclipse.jpt.ui.internal.xml.structure.XmlStructureProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJpaPlatformUi
implements IJpaPlatformUi {
    private Collection<IJpaDetailsProvider> detailsProviders;
    private Collection<IJpaStructureProvider> structureProviders;

    protected BaseJpaPlatformUi() {
    }

    @Override
    public Collection<IJpaDetailsProvider> detailsProviders() {
        if (this.detailsProviders == null) {
            this.detailsProviders = this.buildJpaDetailsProvider();
        }
        return this.detailsProviders;
    }

    protected Collection<IJpaDetailsProvider> buildJpaDetailsProvider() {
        ArrayList<IJpaDetailsProvider> detailsProviders = new ArrayList<IJpaDetailsProvider>();
        detailsProviders.add(new JavaDetailsProvider());
        detailsProviders.add(new XmlDetailsProvider());
        return detailsProviders;
    }

    @Override
    public Collection<IJpaStructureProvider> structureProviders() {
        if (this.structureProviders == null) {
            this.structureProviders = this.buildJpaStructureProvider();
        }
        return this.structureProviders;
    }

    protected Collection<IJpaStructureProvider> buildJpaStructureProvider() {
        ArrayList<IJpaStructureProvider> structureProviders = new ArrayList<IJpaStructureProvider>();
        structureProviders.add(new JavaStructureProvider());
        structureProviders.add(new XmlStructureProvider());
        return structureProviders;
    }

    @Override
    public void generateEntities(IJpaProject project, IStructuredSelection selection) {
        EntitiesGenerator.generate(project, selection);
    }
}

