/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jpt.core.internal.mappings.DefaultTrueBoolean;
import org.eclipse.jpt.core.internal.mappings.IAbstractColumn;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.mappings.INamedColumn;
import org.eclipse.jpt.db.internal.Connection;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.CommonWidgets;
import org.eclipse.jpt.ui.internal.mappings.details.EnumComboViewer;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ColumnComposite
extends BaseJpaComposite {
    private IColumn column;
    private Adapter columnListener = this.buildColumnListener();
    private ConnectionListener connectionListener = this.buildConnectionListener();
    protected CCombo columnCombo;
    protected CCombo tableCombo;
    protected EnumComboViewer insertableComboViewer;
    protected EnumComboViewer updatableComboViewer;
    private ConnectionProfile connectionProfile;

    public ColumnComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildColumnListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                ColumnComposite.this.columnChanged(notification);
            }
        };
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void aboutToClose(Connection connection) {
            }

            public void closed(Connection connection) {
                ColumnComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (ColumnComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        ColumnComposite.this.populateColumnCombo();
                    }
                });
            }

            public void modified(Connection connection) {
                ColumnComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (ColumnComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        ColumnComposite.this.populateColumnCombo();
                    }
                });
            }

            public boolean okToClose(Connection connection) {
                return true;
            }

            public void opened(Connection connection) {
                ColumnComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (ColumnComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        ColumnComposite.this.populateColumnCombo();
                    }
                });
            }

            public void databaseChanged(Connection connection, Database database) {
            }

            public void schemaChanged(Connection connection, Schema schema) {
            }

            public void tableChanged(Connection connection, final Table table) {
                ColumnComposite.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (table == ColumnComposite.this.getDbTable() && !ColumnComposite.this.getControl().isDisposed()) {
                            ColumnComposite.this.populateColumnCombo();
                        }
                    }
                });
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Group columnGroup = this.getWidgetFactory().createGroup(composite, JptUiMappingsMessages.ColumnComposite_columnSection);
        layout = new GridLayout();
        layout.marginHeight = 0;
        columnGroup.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        columnGroup.setLayoutData((Object)gridData);
        Composite intermediaryComposite = this.getWidgetFactory().createComposite((Composite)columnGroup);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        intermediaryComposite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        intermediaryComposite.setLayoutData((Object)gridData);
        CommonWidgets.buildColumnLabel(intermediaryComposite, this.getWidgetFactory());
        this.columnCombo = this.buildColumnCombo(intermediaryComposite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.columnCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.columnCombo, "org.eclipse.jpt.ui.mapping_column");
        CommonWidgets.buildColumnTableLabel(intermediaryComposite, this.getWidgetFactory());
        this.tableCombo = this.buildTableCombo(intermediaryComposite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.tableCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.tableCombo, "org.eclipse.jpt.ui.mapping_columnTable");
        this.getWidgetFactory().createLabel(intermediaryComposite, JptUiMappingsMessages.ColumnComposite_insertable);
        this.insertableComboViewer = new EnumComboViewer(intermediaryComposite, this.commandStack, this.getWidgetFactory());
        this.insertableComboViewer.getControl().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp(this.insertableComboViewer.getControl(), "org.eclipse.jpt.ui.mapping_columnInsertable");
        this.getWidgetFactory().createLabel(intermediaryComposite, JptUiMappingsMessages.ColumnComposite_updatable);
        this.updatableComboViewer = new EnumComboViewer(intermediaryComposite, this.commandStack, this.getWidgetFactory());
        this.updatableComboViewer.getControl().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp(this.updatableComboViewer.getControl(), "org.eclipse.jpt.ui.mapping_columnUpdatable");
    }

    private CCombo buildColumnCombo(Composite parent) {
        final CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        combo.add(JptUiMappingsMessages.ColumnComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ColumnComposite.this.isPopulating()) {
                    return;
                }
                String columnText = ((CCombo)e.getSource()).getText();
                if (columnText.equals("")) {
                    columnText = null;
                    if (ColumnComposite.this.column.getSpecifiedName() == null || ColumnComposite.this.column.getSpecifiedName().equals("")) {
                        return;
                    }
                }
                if (columnText != null && combo.getItemCount() > 0 && columnText.equals(combo.getItem(0))) {
                    columnText = null;
                }
                if (ColumnComposite.this.column.getSpecifiedName() == null && columnText != null) {
                    ColumnComposite.this.column.setSpecifiedName(columnText);
                }
                if (ColumnComposite.this.column.getSpecifiedName() != null && !ColumnComposite.this.column.getSpecifiedName().equals(columnText)) {
                    ColumnComposite.this.column.setSpecifiedName(columnText);
                }
            }
        });
        return combo;
    }

    private CCombo buildTableCombo(Composite parent) {
        final CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        combo.add(JptUiMappingsMessages.ColumnComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ColumnComposite.this.isPopulating()) {
                    return;
                }
                String tableText = ((CCombo)e.getSource()).getText();
                if (tableText.equals("")) {
                    tableText = null;
                    if (ColumnComposite.this.column.getSpecifiedTable() == null || ColumnComposite.this.column.getSpecifiedTable().equals("")) {
                        return;
                    }
                }
                if (tableText != null && combo.getItemCount() > 0 && tableText.equals(combo.getItem(0))) {
                    tableText = null;
                }
                if (ColumnComposite.this.column.getSpecifiedTable() == null && tableText != null) {
                    ColumnComposite.this.column.setSpecifiedTable(tableText);
                }
                if (ColumnComposite.this.column.getSpecifiedTable() != null && !ColumnComposite.this.column.getSpecifiedTable().equals(tableText)) {
                    ColumnComposite.this.column.setSpecifiedTable(tableText);
                }
            }
        });
        return combo;
    }

    protected void columnChanged(Notification notification) {
        if (notification.getFeatureID(INamedColumn.class) == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (ColumnComposite.this.getControl().isDisposed() || ColumnComposite.this.isPopulating()) {
                        return;
                    }
                    ColumnComposite.this.populateColumnName();
                }
            });
        } else if (notification.getFeatureID(INamedColumn.class) == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (ColumnComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    ColumnComposite.this.populateDefaultColumnName();
                }
            });
        } else if (notification.getFeatureID(IAbstractColumn.class) == 10) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (ColumnComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    ColumnComposite.this.populateDefaultColumnTable();
                    ColumnComposite.this.populateColumnCombo();
                }
            });
        } else if (notification.getFeatureID(IAbstractColumn.class) == 9) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (ColumnComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    ColumnComposite.this.populateColumnTable();
                    ColumnComposite.this.populateColumnCombo();
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.column != null) {
            this.column.eAdapters().add((Object)this.columnListener);
            this.addConnectionListener();
        }
    }

    protected void disengageListeners() {
        if (this.column != null) {
            this.removeConnectionListener();
            this.column.eAdapters().remove((Object)this.columnListener);
        }
    }

    private ConnectionProfile getConnectionProfile() {
        if (this.connectionProfile == null) {
            this.connectionProfile = this.column.getJpaProject().connectionProfile();
        }
        return this.connectionProfile;
    }

    private void addConnectionListener() {
        this.getConnectionProfile().addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.getConnectionProfile().removeConnectionListener(this.connectionListener);
    }

    private Table getDbTable() {
        return this.column.dbTable();
    }

    private void populateColumnCombo() {
        this.populateDefaultColumnName();
        if (this.getConnectionProfile().isConnected()) {
            this.columnCombo.remove(1, this.columnCombo.getItemCount() - 1);
            Table table = this.getDbTable();
            if (table != null) {
                Iterator i = CollectionTools.sort((List)CollectionTools.list((Iterator)table.columnNames())).iterator();
                while (i.hasNext()) {
                    this.columnCombo.add((String)i.next());
                }
            }
        } else {
            this.columnCombo.remove(1, this.columnCombo.getItemCount() - 1);
        }
        this.populateColumnName();
    }

    protected void populateDefaultColumnName() {
        String defaultTableName = this.column.getDefaultName();
        int selectionIndex = this.columnCombo.getSelectionIndex();
        this.columnCombo.setItem(0, NLS.bind((String)JptUiMappingsMessages.ColumnComposite_defaultWithOneParam, (Object)defaultTableName));
        if (selectionIndex == 0) {
            this.columnCombo.clearSelection();
            this.columnCombo.select(0);
        }
    }

    protected void populateColumnName() {
        String specifiedColumnName = this.column.getSpecifiedName();
        if (specifiedColumnName != null) {
            if (!this.columnCombo.getText().equals(specifiedColumnName)) {
                this.columnCombo.setText(specifiedColumnName);
            }
        } else {
            String defaultColumnName = this.column.getDefaultName();
            if (!this.columnCombo.getText().equals(NLS.bind((String)JptUiMappingsMessages.ColumnComposite_defaultWithOneParam, (Object)defaultColumnName))) {
                this.columnCombo.select(0);
            }
        }
    }

    private void populateTableCombo() {
        this.populateDefaultColumnTable();
        this.tableCombo.remove(1, this.tableCombo.getItemCount() - 1);
        if (this.column != null) {
            Iterator i = this.column.getOwner().getTypeMapping().associatedTableNamesIncludingInherited();
            while (i.hasNext()) {
                this.tableCombo.add((String)i.next());
            }
        }
        this.populateColumnTable();
    }

    protected void populateDefaultColumnTable() {
        String defaultTableName = this.column.getDefaultTable();
        int selectionIndex = this.tableCombo.getSelectionIndex();
        this.tableCombo.setItem(0, NLS.bind((String)JptUiMappingsMessages.ColumnComposite_defaultWithOneParam, (Object)defaultTableName));
        if (selectionIndex == 0) {
            this.tableCombo.clearSelection();
            this.tableCombo.select(0);
        }
    }

    protected void populateColumnTable() {
        String tableName = this.column.getSpecifiedTable();
        String defaultTableName = this.column.getDefaultTable();
        if (tableName != null) {
            if (!this.tableCombo.getText().equals(tableName)) {
                this.tableCombo.setText(tableName);
            }
        } else if (!this.tableCombo.getText().equals(NLS.bind((String)JptUiMappingsMessages.ColumnComposite_defaultWithOneParam, (Object)defaultTableName))) {
            this.tableCombo.select(0);
        }
    }

    public void doPopulate(EObject obj) {
        this.column = (IColumn)obj;
        if (this.column != null) {
            this.populateColumnCombo();
            this.populateTableCombo();
        }
        this.insertableComboViewer.populate(new InsertableHolder((IAbstractColumn)this.column));
        this.updatableComboViewer.populate(new UpdatableHolder((IAbstractColumn)this.column));
    }

    public void doPopulate() {
        if (this.column != null) {
            this.populateColumnCombo();
            this.populateTableCombo();
        } else {
            this.connectionProfile = null;
        }
        this.insertableComboViewer.populate();
        this.updatableComboViewer.populate();
    }

    protected void enableWidgets(boolean enabled) {
        this.columnCombo.setEnabled(enabled);
        this.tableCombo.setEnabled(enabled);
        this.insertableComboViewer.getControl().setEnabled(enabled);
        this.updatableComboViewer.getControl().setEnabled(enabled);
    }

    public void dispose() {
        this.insertableComboViewer.dispose();
        this.updatableComboViewer.dispose();
        super.dispose();
    }

    private class InsertableHolder
    extends EObjectImpl
    implements EnumComboViewer.EnumHolder {
        private IAbstractColumn column;

        InsertableHolder(IAbstractColumn column) {
            this.column = column;
        }

        public Object get() {
            return this.column.getInsertable();
        }

        public void set(Object enumSetting) {
            this.column.setInsertable((DefaultTrueBoolean)enumSetting);
        }

        public Class featureClass() {
            return IAbstractColumn.class;
        }

        public int featureId() {
            return 6;
        }

        public EObject wrappedObject() {
            return this.column;
        }

        public Object[] enumValues() {
            return DefaultTrueBoolean.VALUES.toArray();
        }

        public Object defaultValue() {
            return DefaultTrueBoolean.DEFAULT;
        }

        public String defaultString() {
            return "True";
        }
    }

    private class UpdatableHolder
    extends EObjectImpl
    implements EnumComboViewer.EnumHolder {
        private IAbstractColumn column;

        UpdatableHolder(IAbstractColumn column) {
            this.column = column;
        }

        public Object get() {
            return this.column.getUpdatable();
        }

        public void set(Object enumSetting) {
            this.column.setUpdatable((DefaultTrueBoolean)enumSetting);
        }

        public Class featureClass() {
            return IAbstractColumn.class;
        }

        public int featureId() {
            return 7;
        }

        public EObject wrappedObject() {
            return this.column;
        }

        public Object[] enumValues() {
            return DefaultTrueBoolean.VALUES.toArray();
        }

        public Object defaultValue() {
            return DefaultTrueBoolean.DEFAULT;
        }

        public String defaultString() {
            return "True";
        }
    }
}

