/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.core.internal.mappings.GenerationType;
import org.eclipse.jpt.core.internal.mappings.IGeneratedValue;
import org.eclipse.jpt.core.internal.mappings.IId;
import org.eclipse.jpt.core.internal.platform.IGeneratorRepository;
import org.eclipse.jpt.core.internal.platform.NullGeneratorRepository;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.widgets.CComboViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class GeneratedValueComposite
extends BaseJpaComposite {
    private IId id;
    private IGeneratedValue generatedValue;
    private Adapter generatedValueListener = this.buildGeneratedValueListener();
    private CComboViewer strategyComboViewer;
    private CCombo generatorNameCombo;
    protected boolean populating;

    public GeneratedValueComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildGeneratedValueListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                GeneratedValueComposite.this.generatedValueChanged(notification);
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.GeneratedValueComposite_strategy);
        this.strategyComboViewer = this.buildStrategyComboViewer(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.strategyComboViewer.getCombo().setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.strategyComboViewer.getCombo(), "org.eclipse.jpt.ui.mapping_generatedValueStrategy");
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.GeneratedValueComposite_generatorName);
        this.generatorNameCombo = this.buildGeneratorNameCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.generatorNameCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.generatorNameCombo, "org.eclipse.jpt.ui.mapping_generatedValueGeneratorName");
    }

    private CComboViewer buildStrategyComboViewer(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent);
        CComboViewer viewer = new CComboViewer(combo);
        viewer.setLabelProvider(this.buildStrategyLabelProvider());
        viewer.add(GenerationType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (GeneratedValueComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    GenerationType selectedType = (GenerationType)selection.getFirstElement();
                    if (GeneratedValueComposite.this.generatedValue == null) {
                        GeneratedValueComposite.this.createGeneratedValue();
                    }
                    if (!GeneratedValueComposite.this.generatedValue.getStrategy().equals((Object)selectedType)) {
                        GeneratedValueComposite.this.generatedValue.setStrategy(selectedType);
                    }
                }
            }
        });
        return viewer;
    }

    private IBaseLabelProvider buildStrategyLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element == GenerationType.DEFAULT) {
                    return NLS.bind((String)JptUiMappingsMessages.GeneratedValueComposite_default, (Object)"Auto");
                }
                return super.getText(element);
            }
        };
    }

    protected CCombo buildGeneratorNameCombo(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        combo.add(JptUiMappingsMessages.TableComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneratedValueComposite.this.isPopulating()) {
                    return;
                }
                String generatorName = ((CCombo)e.getSource()).getText();
                if (generatorName.equals("")) {
                    if (GeneratedValueComposite.this.generatedValue.getGenerator() == null || GeneratedValueComposite.this.generatedValue.getGenerator().equals("")) {
                        return;
                    }
                    generatorName = null;
                }
                if (GeneratedValueComposite.this.generatedValue == null) {
                    GeneratedValueComposite.this.createGeneratedValue();
                }
                GeneratedValueComposite.this.generatedValue.setGenerator(generatorName);
            }
        });
        return combo;
    }

    private void createGeneratedValue() {
        IGeneratedValue generatedValue = this.id.createGeneratedValue();
        this.id.setGeneratedValue(generatedValue);
    }

    protected void generatedValueChanged(Notification notification) {
        if (notification.getFeatureID(IGeneratedValue.class) == 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (GeneratedValueComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    if (GeneratedValueComposite.this.selectedStrategy() != GeneratedValueComposite.this.generatedValue.getStrategy()) {
                        GeneratedValueComposite.this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GeneratedValueComposite.this.generatedValue.getStrategy()));
                    }
                }
            });
        } else if (notification.getFeatureID(IGeneratedValue.class) == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (GeneratedValueComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    GeneratedValueComposite.this.populateGeneratorName();
                }
            });
        }
    }

    protected void doPopulate(EObject obj) {
        this.id = (IId)obj;
        this.generatedValue = this.id == null ? null : this.id.getGeneratedValue();
        if (this.generatedValue == null) {
            this.strategyComboViewer.getCombo().deselectAll();
            this.generatorNameCombo.setText("");
            this.populating = false;
            return;
        }
        this.populateStrategyCombo();
        this.populateGeneratorNameCombo();
    }

    protected void doPopulate() {
    }

    protected void engageListeners() {
        if (this.generatedValue != null) {
            this.generatedValue.eAdapters().add((Object)this.generatedValueListener);
        }
    }

    protected void disengageListeners() {
        if (this.generatedValue != null) {
            this.generatedValue.eAdapters().remove((Object)this.generatedValueListener);
        }
    }

    private IGeneratorRepository getGeneratorRepository() {
        return NullGeneratorRepository.instance();
    }

    private void populateGeneratorNameCombo() {
        this.generatorNameCombo.removeAll();
        Iterator i = this.getGeneratorRepository().generatorNames();
        while (i.hasNext()) {
            this.generatorNameCombo.add((String)i.next());
        }
        this.populateGeneratorName();
    }

    private void populateGeneratorName() {
        String generatorName = this.generatedValue.getGenerator();
        if (generatorName == null || generatorName.equals("")) {
            this.generatorNameCombo.setText("");
        } else if (!this.generatorNameCombo.getText().equals(generatorName)) {
            this.generatorNameCombo.setText(generatorName);
        }
    }

    private void populateStrategyCombo() {
        GenerationType selectedType = this.selectedStrategy();
        GenerationType strategy = this.generatedValue.getStrategy();
        if (strategy == GenerationType.AUTO) {
            if (selectedType != GenerationType.AUTO) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GenerationType.AUTO));
            }
        } else if (strategy == GenerationType.SEQUENCE) {
            if (selectedType != GenerationType.SEQUENCE) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GenerationType.SEQUENCE));
            }
        } else if (strategy == GenerationType.IDENTITY) {
            if (selectedType != GenerationType.IDENTITY) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GenerationType.IDENTITY));
            }
        } else if (strategy == GenerationType.TABLE) {
            if (selectedType != GenerationType.TABLE) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GenerationType.TABLE));
            }
        } else if (selectedType != GenerationType.DEFAULT) {
            this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GenerationType.DEFAULT));
        }
    }

    private GenerationType selectedStrategy() {
        return (GenerationType)((StructuredSelection)this.strategyComboViewer.getSelection()).getFirstElement();
    }
}

