/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.internal.mappings.IAbstractJoinColumn;
import org.eclipse.jpt.core.internal.mappings.INamedColumn;
import org.eclipse.jpt.core.internal.mappings.IPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.mappings.ISecondaryTable;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.PrimaryKeyJoinColumnInSecondaryTableDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class PrimaryKeyJoinColumnsInSecondaryTableComposite
extends BaseJpaComposite {
    private ISecondaryTable secondaryTable;
    private final Adapter secondaryTableListener = this.buildSecondaryTableListener();
    private final Adapter pkJoinColumnListener = this.buildPkJoinColumnListener();
    ListViewer pkJoinColumnsListViewer;
    private Group pkJoinColumnsGroup;
    Button overrideDefaultJoinColumnsCheckBox;
    private Button pkJoinColumnsAddButton;
    private Button pkJoinColumnsRemoveButton;
    private Button pkJoinColumnsEditButton;

    public PrimaryKeyJoinColumnsInSecondaryTableComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildSecondaryTableListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.secondaryTableChanged(notification);
            }
        };
    }

    private Adapter buildPkJoinColumnListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.pkJoinColumnChanged(notification);
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        this.overrideDefaultJoinColumnsCheckBox = this.getWidgetFactory().createButton(composite, JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_overrideDefaultPrimaryKeyJoinColumns, 32);
        this.overrideDefaultJoinColumnsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (PrimaryKeyJoinColumnsInSecondaryTableComposite.this.overrideDefaultJoinColumnsCheckBox.getSelection()) {
                    IPrimaryKeyJoinColumn defaultJoinColumn = (IPrimaryKeyJoinColumn)PrimaryKeyJoinColumnsInSecondaryTableComposite.this.secondaryTable.getDefaultPrimaryKeyJoinColumns().get(0);
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    IPrimaryKeyJoinColumn pkJoinColumn = PrimaryKeyJoinColumnsInSecondaryTableComposite.this.secondaryTable.createPrimaryKeyJoinColumn(0);
                    PrimaryKeyJoinColumnsInSecondaryTableComposite.this.secondaryTable.getSpecifiedPrimaryKeyJoinColumns().add((Object)pkJoinColumn);
                    pkJoinColumn.setSpecifiedName(columnName);
                    pkJoinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                } else {
                    PrimaryKeyJoinColumnsInSecondaryTableComposite.this.secondaryTable.getSpecifiedPrimaryKeyJoinColumns().clear();
                }
            }
        });
        this.pkJoinColumnsGroup = this.getWidgetFactory().createGroup(composite, JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_primaryKeyJoinColumn);
        this.pkJoinColumnsGroup.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.pkJoinColumnsGroup.setLayoutData((Object)gridData);
        this.pkJoinColumnsListViewer = new ListViewer((Composite)this.pkJoinColumnsGroup, 2050);
        this.pkJoinColumnsListViewer.setContentProvider(this.buildJoinColumnsListContentProvider());
        this.pkJoinColumnsListViewer.setLabelProvider((IBaseLabelProvider)this.buildJoinColumnsListLabelProvider());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.pkJoinColumnsListViewer.getList().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.pkJoinColumnsListViewer.getList(), "org.eclipse.jpt.ui.mapping_joinTableJoinColumns");
        this.pkJoinColumnsAddButton = new Button((Composite)this.pkJoinColumnsGroup, 0);
        this.pkJoinColumnsAddButton.setText(JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_add);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.pkJoinColumnsAddButton.setLayoutData((Object)gridData);
        this.pkJoinColumnsAddButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.addPrimaryKeyJoinColumn();
            }
        });
        this.pkJoinColumnsEditButton = new Button((Composite)this.pkJoinColumnsGroup, 0);
        this.pkJoinColumnsEditButton.setText(JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_edit);
        this.pkJoinColumnsEditButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.editPrimaryKeyJoinColumn();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.pkJoinColumnsEditButton.setLayoutData((Object)gridData);
        this.pkJoinColumnsRemoveButton = new Button((Composite)this.pkJoinColumnsGroup, 0);
        this.pkJoinColumnsRemoveButton.setText(JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_remove);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.pkJoinColumnsRemoveButton.setLayoutData((Object)gridData);
        this.pkJoinColumnsRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.removePrimaryKeyJoinColumn();
            }
        });
        this.pkJoinColumnsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.updatePrimaryKeyJoinColumnsEnablement();
            }
        });
    }

    private IContentProvider buildJoinColumnsListContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((ISecondaryTable)inputElement).getPrimaryKeyJoinColumns().toArray();
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                IPrimaryKeyJoinColumn joinColumn = (IPrimaryKeyJoinColumn)element;
                return PrimaryKeyJoinColumnsInSecondaryTableComposite.this.secondaryTable.containsSpecifiedPrimaryKeyJoinColumns() ? PrimaryKeyJoinColumnsInSecondaryTableComposite.this.buildJoinColumnLabel(joinColumn) : PrimaryKeyJoinColumnsInSecondaryTableComposite.this.buildDefaultJoinColumnLabel(joinColumn);
            }
        };
    }

    String buildDefaultJoinColumnLabel(IPrimaryKeyJoinColumn joinColumn) {
        return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    String buildJoinColumnLabel(IPrimaryKeyJoinColumn joinColumn) {
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    void addPrimaryKeyJoinColumn() {
        PrimaryKeyJoinColumnInSecondaryTableDialog dialog = new PrimaryKeyJoinColumnInSecondaryTableDialog(this.getControl().getShell(), this.secondaryTable);
        this.addJoinColumnFromDialog(dialog);
    }

    private void addJoinColumnFromDialog(PrimaryKeyJoinColumnInSecondaryTableDialog dialog) {
        if (dialog.open() == 0) {
            int index = this.secondaryTable.getSpecifiedPrimaryKeyJoinColumns().size();
            String name = dialog.getSelectedName();
            String referencedColumnName = dialog.getReferencedColumnName();
            IPrimaryKeyJoinColumn joinColumn = this.secondaryTable.createPrimaryKeyJoinColumn(index);
            this.secondaryTable.getSpecifiedPrimaryKeyJoinColumns().add((Object)joinColumn);
            joinColumn.setSpecifiedName(name);
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    private IPrimaryKeyJoinColumn getSelectedJoinColumn() {
        return (IPrimaryKeyJoinColumn)((StructuredSelection)this.pkJoinColumnsListViewer.getSelection()).getFirstElement();
    }

    void editPrimaryKeyJoinColumn() {
        IPrimaryKeyJoinColumn joinColumn = this.getSelectedJoinColumn();
        PrimaryKeyJoinColumnInSecondaryTableDialog dialog = new PrimaryKeyJoinColumnInSecondaryTableDialog(this.getControl().getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    private void editJoinColumnFromDialog(PrimaryKeyJoinColumnInSecondaryTableDialog dialog, IPrimaryKeyJoinColumn joinColumn) {
        if (dialog.open() == 0) {
            this.editJoinColumnDialogOkd(dialog, joinColumn);
        }
    }

    private void editJoinColumnDialogOkd(PrimaryKeyJoinColumnInSecondaryTableDialog dialog, IPrimaryKeyJoinColumn joinColumn) {
        String name = dialog.getSelectedName();
        String referencedColumnName = dialog.getReferencedColumnName();
        if (dialog.isDefaultNameSelected()) {
            if (joinColumn.getSpecifiedName() != null) {
                joinColumn.setSpecifiedName(null);
            }
        } else if (joinColumn.getSpecifiedName() == null || !joinColumn.getSpecifiedName().equals(name)) {
            joinColumn.setSpecifiedName(name);
        }
        if (dialog.isDefaultReferencedColumnNameSelected()) {
            if (joinColumn.getSpecifiedReferencedColumnName() != null) {
                joinColumn.setSpecifiedReferencedColumnName(null);
            }
        } else if (joinColumn.getSpecifiedReferencedColumnName() == null || !joinColumn.getSpecifiedReferencedColumnName().equals(referencedColumnName)) {
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    void removePrimaryKeyJoinColumn() {
        ISelection selection = this.pkJoinColumnsListViewer.getSelection();
        if (selection instanceof StructuredSelection) {
            Iterator i = ((StructuredSelection)selection).iterator();
            while (i.hasNext()) {
                this.secondaryTable.getPrimaryKeyJoinColumns().remove(i.next());
            }
        }
    }

    void updatePrimaryKeyJoinColumnsEnablement() {
        boolean groupEnabledState = this.secondaryTable.containsSpecifiedPrimaryKeyJoinColumns();
        this.enableGroup(this.pkJoinColumnsGroup, groupEnabledState);
        this.pkJoinColumnsRemoveButton.setEnabled(groupEnabledState && !((StructuredSelection)this.pkJoinColumnsListViewer.getSelection()).isEmpty());
        this.pkJoinColumnsEditButton.setEnabled(groupEnabledState && ((StructuredSelection)this.pkJoinColumnsListViewer.getSelection()).size() == 1);
    }

    private void enableGroup(Group group, boolean enabled) {
        group.setEnabled(enabled);
        int i = 0;
        while (i < group.getChildren().length) {
            group.getChildren()[i].setEnabled(enabled);
            ++i;
        }
    }

    public void doPopulate(EObject obj) {
        this.secondaryTable = (ISecondaryTable)obj;
        if (this.secondaryTable == null) {
            this.pkJoinColumnsListViewer.setInput(null);
            return;
        }
        this.pkJoinColumnsListViewer.setInput((Object)this.secondaryTable);
        this.updatePrimaryKeyJoinColumnsEnablement();
        this.overrideDefaultJoinColumnsCheckBox.setSelection(this.secondaryTable.containsSpecifiedPrimaryKeyJoinColumns());
    }

    protected void doPopulate() {
    }

    protected void engageListeners() {
        if (this.secondaryTable != null) {
            this.secondaryTable.eAdapters().add((Object)this.secondaryTableListener);
            for (IPrimaryKeyJoinColumn pkJoinColumn : this.secondaryTable.getPrimaryKeyJoinColumns()) {
                pkJoinColumn.eAdapters().add((Object)this.pkJoinColumnListener);
            }
        }
    }

    protected void disengageListeners() {
        if (this.secondaryTable != null) {
            for (IPrimaryKeyJoinColumn pkJoinColumn : this.secondaryTable.getPrimaryKeyJoinColumns()) {
                pkJoinColumn.eAdapters().remove((Object)this.pkJoinColumnListener);
            }
            this.secondaryTable.eAdapters().remove((Object)this.secondaryTableListener);
        }
    }

    protected void secondaryTableChanged(Notification notification) {
        if (notification.getFeatureID(ISecondaryTable.class) == 11) {
            if (notification.getEventType() == 3) {
                ((IPrimaryKeyJoinColumn)notification.getNewValue()).eAdapters().add((Object)this.pkJoinColumnListener);
            } else if (notification.getEventType() == 4) {
                ((IPrimaryKeyJoinColumn)notification.getOldValue()).eAdapters().remove((Object)this.pkJoinColumnListener);
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (PrimaryKeyJoinColumnsInSecondaryTableComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    PrimaryKeyJoinColumnsInSecondaryTableComposite.this.pkJoinColumnsListViewer.refresh();
                    PrimaryKeyJoinColumnsInSecondaryTableComposite.this.overrideDefaultJoinColumnsCheckBox.setSelection(PrimaryKeyJoinColumnsInSecondaryTableComposite.this.secondaryTable.containsSpecifiedPrimaryKeyJoinColumns());
                    PrimaryKeyJoinColumnsInSecondaryTableComposite.this.updatePrimaryKeyJoinColumnsEnablement();
                }
            });
        }
    }

    protected void pkJoinColumnChanged(Notification notification) {
        if (notification.getFeatureID(INamedColumn.class) == 1 || notification.getFeatureID(IAbstractJoinColumn.class) == 5 || notification.getFeatureID(INamedColumn.class) == 2 || notification.getFeatureID(IAbstractJoinColumn.class) == 6) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (PrimaryKeyJoinColumnsInSecondaryTableComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    PrimaryKeyJoinColumnsInSecondaryTableComposite.this.pkJoinColumnsListViewer.refresh();
                }
            });
        }
    }

    protected void enableWidgets(boolean enabled) {
        this.pkJoinColumnsListViewer.getControl().setEnabled(enabled);
        this.overrideDefaultJoinColumnsCheckBox.setEnabled(enabled);
        this.pkJoinColumnsEditButton.setEnabled(enabled);
        this.pkJoinColumnsRemoveButton.setEnabled(enabled);
        this.pkJoinColumnsAddButton.setEnabled(enabled);
    }
}

