/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.xml.details;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.AccessType;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.XmlEObject;
import org.eclipse.jpt.core.internal.content.orm.XmlPersistentType;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.ui.internal.details.PersistentTypeDetailsPage;
import org.eclipse.jpt.ui.internal.java.details.ITypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.EmbeddableUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.EntityUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.MappedSuperclassUiProvider;
import org.eclipse.jpt.ui.internal.widgets.CComboViewer;
import org.eclipse.jpt.ui.internal.xml.JptUiXmlMessages;
import org.eclipse.jpt.ui.internal.xml.details.AccessTypeComboViewer;
import org.eclipse.jpt.ui.internal.xml.details.CommonWidgets;
import org.eclipse.jpt.ui.internal.xml.details.MetaDataCompleteComboViewer;
import org.eclipse.jpt.ui.internal.xml.details.XmlJavaClassChooser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlPersistentTypeDetailsPage
extends PersistentTypeDetailsPage {
    private XmlJavaClassChooser javaClassChooser;
    private MetaDataCompleteComboViewer metadataCompleteComboViewer;
    private AccessTypeComboViewer accessComboViewer;

    public XmlPersistentTypeDetailsPage(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, widgetFactory);
    }

    @Override
    protected Collection<ITypeMappingUiProvider> buildTypeMappingUiProviders() {
        ArrayList<ITypeMappingUiProvider> typeMappingUiProviders = new ArrayList<ITypeMappingUiProvider>();
        typeMappingUiProviders.add(new EntityUiProvider());
        typeMappingUiProviders.add(new MappedSuperclassUiProvider());
        typeMappingUiProviders.add(new EmbeddableUiProvider());
        return typeMappingUiProviders;
    }

    @Override
    protected void initializeLayout(Composite composite) {
        composite.setLayout((Layout)new GridLayout(2, false));
        CommonWidgets.buildJavaClassLabel(composite, this.getWidgetFactory());
        this.javaClassChooser = CommonWidgets.buildJavaClassChooser(composite, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.javaClassChooser.getControl().setLayoutData((Object)gridData);
        this.buildTypeMappingLabel(composite);
        CComboViewer typeMappingCombo = this.buildTypeMappingCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        typeMappingCombo.getCombo().setLayoutData((Object)gridData);
        this.buildMetadataCompleteLabel(composite);
        this.metadataCompleteComboViewer = new MetaDataCompleteComboViewer(composite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.metadataCompleteComboViewer.getControl().setLayoutData((Object)gridData);
        CommonWidgets.buildAccessLabel(composite, this.getWidgetFactory());
        this.accessComboViewer = CommonWidgets.buildAccessTypeComboViewer(composite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.accessComboViewer.getControl().setLayoutData((Object)gridData);
        PageBook typeMappingPageBook = this.buildTypeMappingPageBook(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        typeMappingPageBook.setLayoutData((Object)gridData);
    }

    private Label buildMetadataCompleteLabel(Composite parent) {
        return this.getWidgetFactory().createLabel(parent, JptUiXmlMessages.PersistentTypePage_MetadataCompleteLabel);
    }

    @Override
    protected void doPopulate(IJpaContentNode persistentTypeNode) {
        super.doPopulate(persistentTypeNode);
        if (persistentTypeNode == null) {
            this.javaClassChooser.populate(null);
            this.metadataCompleteComboViewer.populate(null);
            this.accessComboViewer.populate(new MyAccessHolder(null));
        } else {
            XmlTypeMapping mapping = ((XmlPersistentType)persistentTypeNode).getMapping();
            this.javaClassChooser.populate((EObject)mapping);
            this.metadataCompleteComboViewer.populate((EObject)mapping);
            this.accessComboViewer.populate(new MyAccessHolder(mapping));
        }
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.javaClassChooser.populate();
        this.metadataCompleteComboViewer.populate();
        this.accessComboViewer.populate();
    }

    @Override
    public void dispose() {
        this.javaClassChooser.dispose();
        this.metadataCompleteComboViewer.dispose();
        this.accessComboViewer.dispose();
        super.dispose();
    }

    private class MyAccessHolder
    extends XmlEObject
    implements AccessTypeComboViewer.AccessHolder {
        private XmlTypeMapping xmlTypeMapping;

        MyAccessHolder(XmlTypeMapping xmlTypeMapping) {
            this.xmlTypeMapping = xmlTypeMapping;
        }

        public void setAccess(AccessType accessType) {
            this.xmlTypeMapping.setSpecifiedAccess(accessType);
        }

        public AccessType getAccess() {
            return this.xmlTypeMapping.getSpecifiedAccess();
        }

        public Class featureClass() {
            return XmlTypeMapping.class;
        }

        public int featureId() {
            return 3;
        }

        public EObject wrappedObject() {
            return this.xmlTypeMapping;
        }
    }
}

