/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.jem.internal.beaninfo.common.InvalidObject;
import org.eclipse.jem.internal.proxy.common.MapTypes;

public class FeatureAttributeValue
implements Serializable {
    private transient Object value;
    private transient Object internalValue;
    private boolean implicitValue;
    private static final long serialVersionUID = 1105717634844L;
    private static final Pattern QUOTE = Pattern.compile("\"");
    private static final String NULL = "null";
    private static final String INVALID = "INV";
    private static final String IMPLICIT = "implicit,";

    public FeatureAttributeValue(String initString) {
        if (initString.startsWith(IMPLICIT)) {
            this.setImplicitValue(true);
            initString = initString.substring(IMPLICIT.length());
        }
        this.value = FeatureAttributeValue.parseString(initString);
    }

    public FeatureAttributeValue() {
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.setInternalValue(null);
    }

    public void setInternalValue(Object internalValue) {
        this.internalValue = internalValue;
    }

    public Object getInternalValue() {
        return this.internalValue;
    }

    public String toString() {
        if (this.value == null) {
            return super.toString();
        }
        StringBuffer out = new StringBuffer(100);
        if (this.isImplicitValue()) {
            out.append(IMPLICIT);
        }
        FeatureAttributeValue.makeString(this.value, out);
        return out.toString();
    }

    public static String makeString(Object value) {
        StringBuffer out = new StringBuffer(100);
        FeatureAttributeValue.makeString(value, out);
        return out.toString();
    }

    private static void makeString(Object value, StringBuffer out) {
        if (value == null) {
            out.append(NULL);
        } else if (value instanceof String || value instanceof Class) {
            String str;
            out.append('\"');
            String string = str = value instanceof String ? (String)value : ((Class)value).getName();
            if (str.indexOf(34) != -1) {
                out.append(QUOTE.matcher(str).replaceAll("\\\\\""));
            } else {
                out.append(str);
            }
            out.append('\"');
        } else if (value instanceof Number) {
            out.append(value);
        } else if (value instanceof Boolean) {
            out.append(value);
        } else if (value instanceof Character) {
            out.append('\'');
            Character c = (Character)value;
            if (c.charValue() != '\'') {
                out.append(c.charValue());
            } else {
                out.append("\\'");
            }
            out.append('\'');
        } else if (value.getClass().isArray()) {
            Class<?> type = value.getClass();
            Class<?> ft = type.getComponentType();
            int dims = 1;
            while (ft.isArray()) {
                ++dims;
                ft = ft.getComponentType();
            }
            if (ft == Object.class || ft == String.class || ft == Boolean.class || ft == Character.class || ft.isPrimitive() || Number.class.isAssignableFrom(ft)) {
                out.append('[');
                int length = Array.getLength(value);
                out.append(length);
                out.append(']');
                while (--dims > 0) {
                    out.append("[]");
                }
                out.append('{');
                int i = 0;
                while (i < length) {
                    if (i != 0) {
                        out.append(',');
                    }
                    FeatureAttributeValue.makeString(Array.get(value, i), out);
                    ++i;
                }
                out.append('}');
            } else {
                out.append(INVALID);
            }
        } else {
            out.append(INVALID);
        }
    }

    public static Object parseString(String input) {
        return FeatureAttributeValue.parseString(new StringParser(input));
    }

    /*
     * Unable to fully structure code
     */
    private static Object parseString(StringParser parser) {
        block47: {
            parser.skipWhitespace();
            if (parser.atEnd()) break block47;
            c = parser.read();
            switch (c) {
                case '\"': {
                    start = parser.nextIndex();
                    dequoted = null;
                    dequoteIndex = 0;
                    while (!parser.atEnd()) {
                        cc = parser.read();
                        if (cc == '\"') {
                            if (dequoted == null) {
                                return parser.getInput().substring(start, parser.nextIndex() - 1);
                            }
                            endNdx = parser.nextIndex() - 1;
                            parser.getInput().getChars(start, endNdx, dequoted, dequoteIndex);
                            return new String(dequoted, 0, dequoteIndex += endNdx - start);
                        }
                        if (cc != '\\' || parser.peek() != '\"') continue;
                        if (dequoted == null) {
                            dequoted = new char[parser.getLength()];
                        }
                        endNdx = parser.nextIndex() - 1;
                        parser.getInput().getChars(start, endNdx, dequoted, dequoteIndex);
                        dequoteIndex += endNdx - start;
                        dequoted[dequoteIndex++] = parser.read();
                        start = parser.nextIndex();
                    }
                    break;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    numberComplete = false;
                    floatType = false;
                    foundE = false;
                    foundESign = false;
                    start = parser.nextIndex() - 1;
                    while (!parser.atEnd() && !numberComplete) {
                        cc = parser.read();
                        switch (cc) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                break;
                            }
                            case '.': {
                                if (floatType) {
                                    return InvalidObject.INSTANCE;
                                }
                                floatType = true;
                                break;
                            }
                            case 'E': 
                            case 'e': {
                                if (foundE) {
                                    return InvalidObject.INSTANCE;
                                }
                                foundE = true;
                                floatType = true;
                                break;
                            }
                            case '+': 
                            case '-': {
                                if (!foundE || foundESign) {
                                    return InvalidObject.INSTANCE;
                                }
                                foundESign = true;
                                break;
                            }
                            default: {
                                parser.backup();
                                numberComplete = true;
                            }
                        }
                    }
                    try {
                        if (!floatType) {
                            return Long.valueOf(parser.getInput().substring(start, parser.nextIndex()));
                        }
                        return Double.valueOf(parser.getInput().substring(start, parser.nextIndex()));
                    }
                    catch (NumberFormatException v0) {
                        break;
                    }
                }
                case 'F': 
                case 'T': 
                case 'f': 
                case 't': {
                    if (parser.getInput().regionMatches(true, parser.nextIndex() - 1, "true", 0, 4)) {
                        parser.skip(3);
                        return Boolean.TRUE;
                    }
                    if (!parser.getInput().regionMatches(true, parser.nextIndex() - 1, "false", 0, 5)) break;
                    parser.skip(4);
                    return Boolean.FALSE;
                }
                case '\'': {
                    cc = parser.read();
                    if (cc == '\\') {
                        cc = parser.read();
                    } else if (cc == '\'') break;
                    if (parser.peek() != '\'') break;
                    parser.read();
                    return new Character(cc);
                }
                case 'n': {
                    if (!parser.getInput().regionMatches(parser.nextIndex() - 1, "null", 0, 4)) break;
                    parser.skip(3);
                    return null;
                }
                case 'I': {
                    if (!parser.getInput().regionMatches(parser.nextIndex() - 1, "INV", 0, "INV".length())) break;
                    parser.skip("INV".length() - 1);
                    return InvalidObject.INSTANCE;
                }
                case '[': {
                    size = FeatureAttributeValue.parseString(parser);
                    if (!(size instanceof Long)) break;
                    parser.skipWhitespace();
                    cc = parser.read();
                    if (cc != ']') break;
                    dim = 1;
                    valid = true;
                    while (true) {
                        parser.skipWhitespace();
                        cc = parser.read();
                        if (cc != '[') ** GOTO lbl109
                        parser.skipWhitespace();
                        cc = parser.read();
                        if (cc != ']') break;
                        ++dim;
                    }
                    valid = false;
                    parser.backup();
                    ** GOTO lbl110
lbl109:
                    // 1 sources

                    parser.backup();
lbl110:
                    // 2 sources

                    if (!valid) break;
                    parser.skipWhitespace();
                    cc = parser.read();
                    if (cc != '{') break;
                    dims = new int[dim];
                    dims[0] = len = ((Long)size).intValue();
                    array = Array.newInstance(Object.class, dims);
                    Arrays.fill((Object[])array, null);
                    invSetting = null;
                    entry = FeatureAttributeValue.parseString(parser);
                    compType = array.getClass().getComponentType();
                    i = -1;
                    while (true) {
                        if (++i < len) {
                            if (compType.isInstance(entry)) {
                                Array.set(array, i, entry);
                            } else {
                                if (invSetting == null) {
                                    if (dim == 1) {
                                        invSetting = InvalidObject.INSTANCE;
                                    } else {
                                        invDims = new int[dim - 1];
                                        Arrays.fill(invDims, 1);
                                        finalEntry = invSetting = Array.newInstance(Object.class, invDims);
                                        j = invDims.length - 1;
                                        while (j > 0) {
                                            finalEntry = Array.get(finalEntry, 0);
                                            --j;
                                        }
                                        Array.set(finalEntry, 0, InvalidObject.INSTANCE);
                                    }
                                }
                                Array.set(array, i, invSetting);
                            }
                        }
                        parser.skipWhitespace();
                        cc = parser.read();
                        if (cc == ',') {
                            entry = FeatureAttributeValue.parseString(parser);
                            continue;
                        }
                        if (cc == '}') ** GOTO lbl177
                        if (parser.atEnd()) break;
                        parser.backup();
                        entry = FeatureAttributeValue.parseString(parser);
                    }
                    e = new IllegalStateException(parser.toString());
                    try {
                        biPluginClass = Class.forName("org.eclipse.jem.internal.beaninfo.core.BeaninfoPlugin");
                        getPlugin = biPluginClass.getMethod("getPlugin", null);
                        getLogger = biPluginClass.getMethod("getLogger", null);
                        log = getLogger.getReturnType().getMethod("log", new Class[]{Throwable.class, Level.class});
                        biPlugin = getPlugin.invoke(null, null);
                        logger = getLogger.invoke(biPlugin, null);
                        log.invoke(logger, new Object[]{e, Level.WARNING});
                        return InvalidObject.INSTANCE;
                    }
                    catch (SecurityException v1) {
                    }
                    catch (IllegalArgumentException v2) {
                    }
                    catch (ClassNotFoundException v3) {
                    }
                    catch (NoSuchMethodException v4) {
                    }
                    catch (IllegalAccessException v5) {
                    }
                    catch (InvocationTargetException v6) {
                    }
                    catch (NullPointerException v7) {}
                    e.printStackTrace();
                    return InvalidObject.INSTANCE;
lbl177:
                    // 1 sources

                    return array;
                }
            }
        }
        return InvalidObject.INSTANCE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeObject(this.value, out);
    }

    private void writeObject(Object value, ObjectOutputStream out) throws IOException {
        if (value == null) {
            out.writeObject(value);
        } else if (value instanceof Class) {
            out.writeObject(((Class)value).getName());
        } else if (!value.getClass().isArray()) {
            if (value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character) {
                out.writeObject(value);
            } else {
                out.writeObject(InvalidObject.INSTANCE);
            }
        } else {
            Class<?> type = value.getClass();
            Class<?> ft = type.getComponentType();
            int dims = 1;
            while (ft.isArray()) {
                ++dims;
                ft = ft.getComponentType();
            }
            if (ft == Object.class || ft == String.class || ft == Boolean.class || ft == Character.class || ft.isPrimitive() || ft == Class.class || Number.class.isAssignableFrom(ft)) {
                String jniType = dims == 1 ? "java.lang.Object" : MapTypes.getJNITypeName((String)"java.lang.Object", (int)(dims - 1));
                try {
                    Class<?> componentType = Class.forName(jniType);
                    out.writeObject(componentType);
                    int length = Array.getLength(value);
                    out.writeInt(length);
                    int i = 0;
                    while (i < length) {
                        this.writeObject(Array.get(value, i), out);
                        ++i;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                out.writeObject(InvalidObject.INSTANCE);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.value = this.readActualObject(in);
    }

    private Object readActualObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object val = in.readObject();
        if (val instanceof Class) {
            int length = in.readInt();
            Object array = Array.newInstance((Class)val, length);
            int i = 0;
            while (i < length) {
                Array.set(array, i, this.readActualObject(in));
                ++i;
            }
            return array;
        }
        return val;
    }

    public boolean isImplicitValue() {
        return this.implicitValue;
    }

    public void setImplicitValue(boolean implicitValue) {
        this.implicitValue = implicitValue;
    }

    private static class StringParser {
        private int next = 0;
        private int length;
        private String input;

        public StringParser(String input) {
            this.input = input;
            this.length = input.length();
        }

        public String toString() {
            return "StringParser: \"" + this.input + '\"';
        }

        public void skipWhitespace() {
            while (this.next < this.length) {
                if (Character.isWhitespace(this.input.charAt(this.next++))) continue;
                --this.next;
                break;
            }
        }

        public int nextIndex() {
            return this.next;
        }

        public int getLength() {
            return this.length;
        }

        public char read() {
            return this.next < this.length ? this.input.charAt(this.next++) : (char)'\u0000';
        }

        public void backup() {
            if (--this.next < 0) {
                this.next = 0;
            }
        }

        public char peek() {
            return this.next < this.length ? this.input.charAt(this.next) : (char)'\u0000';
        }

        public boolean atEnd() {
            return this.next >= this.length;
        }

        public void reset(int nextIndex) {
            this.next = nextIndex <= this.length ? nextIndex : this.length;
        }

        public void skip(int skip) {
            if ((this.next += skip) > this.length) {
                this.next = this.length;
            }
        }

        public String getInput() {
            return this.input;
        }
    }
}

