/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderFactory;
import org.eclipse.jst.j2ee.model.J2EEModelProviderRegistry;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelProviderManager {
    private static final int DEFAULT_PRIORITY = 100;
    private static HashMap<ModelProviderKey, IModelProviderFactory> providers;
    private static J2EEModelProviderRegistry registry;

    public static IModelProvider getModelProvider(IProject project, IProjectFacetVersion vers) {
        IModelProviderFactory factory = ModelProviderManager.getProvider(vers);
        return factory.create(project);
    }

    public static IModelProvider getModelProvider(IVirtualComponent aModule, IProjectFacetVersion vers) {
        IModelProviderFactory factory = ModelProviderManager.getProvider(vers);
        return factory.create(aModule);
    }

    public static void registerProvider(IModelProviderFactory providerFactory, IProjectFacetVersion v, String priority) {
        int currentPriority;
        int newPriority = priority != null ? Integer.parseInt(priority) : 100;
        if (newPriority <= (currentPriority = ModelProviderManager.getProviderPriority(v))) {
            ModelProviderKey key = ModelProviderManager.createProviderKey(v, newPriority);
            providers.put(key, providerFactory);
        }
    }

    private static IModelProviderFactory getProvider(IProjectFacetVersion v) {
        Set<ModelProviderKey> keys = ModelProviderManager.getProviders().keySet();
        for (ModelProviderKey key : keys) {
            if (!key.version.equals(v)) continue;
            return providers.get(key);
        }
        return null;
    }

    private static int getProviderPriority(IProjectFacetVersion v) {
        Set<ModelProviderKey> keys = providers.keySet();
        for (ModelProviderKey key : keys) {
            if (!key.version.equals(v)) continue;
            return key.priority;
        }
        return 100;
    }

    private static void initProviders() {
        providers = new HashMap();
        registry = J2EEModelProviderRegistry.getInstance();
    }

    private static ModelProviderKey createProviderKey(IProjectFacetVersion fv, int priority) {
        ModelProviderKey key = new ModelProviderKey();
        key.priority = priority;
        key.version = fv;
        return key;
    }

    public static IModelProvider getModelProvider(IProject proj) {
        IProjectFacetVersion facetVersion = ModelProviderManager.getDefaultFacet(proj);
        return ModelProviderManager.getModelProvider(proj, facetVersion);
    }

    public static IModelProvider getModelProvider(IVirtualComponent aModule) {
        IProjectFacetVersion facetVersion = ModelProviderManager.getDefaultFacet(aModule);
        return ModelProviderManager.getModelProvider(aModule, facetVersion);
    }

    private static IProjectFacetVersion getDefaultFacet(IProject proj) {
        String type = J2EEProjectUtilities.getJ2EEProjectType(proj);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)type);
        IFacetedProject fp = null;
        try {
            fp = ProjectFacetsManager.create((IProject)proj);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (fp != null && facet != null) {
            return fp.getInstalledVersion(facet);
        }
        return null;
    }

    private static IProjectFacetVersion getDefaultFacet(IVirtualComponent aModule) {
        String type = J2EEProjectUtilities.getJ2EEComponentType(aModule);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)type);
        IFacetedProject fp = null;
        try {
            if (!aModule.isBinary()) {
                fp = ProjectFacetsManager.create((IProject)aModule.getProject());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (fp != null && facet != null) {
            return fp.getInstalledVersion(facet);
        }
        return null;
    }

    private static HashMap<ModelProviderKey, IModelProviderFactory> getProviders() {
        if (registry == null) {
            ModelProviderManager.initProviders();
        }
        return providers;
    }

    public static class ModelProviderKey {
        protected IProjectFacetVersion version;
        protected int priority;

        public boolean equals(Object aOther) {
            if (this == aOther) {
                return true;
            }
            ModelProviderKey otherKey = (ModelProviderKey)aOther;
            return this.version.equals(otherKey.version);
        }

        public int hashCode() {
            return this.version.hashCode();
        }
    }
}

