/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class AppClientFacetInstallDelegate
extends J2EEFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            try {
                IDataModel model = (IDataModel)config;
                IJavaProject jproj = JavaCore.create((IProject)project);
                WtpUtils.addNatures((IProject)project);
                this.createFlexibleProject(monitor, project, model, jproj);
                ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
                ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
                try {
                    ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
                }
                catch (ExecutionException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected IVirtualComponent createFlexibleProject(IProgressMonitor monitor, IProject project, IDataModel model, IJavaProject jproj) throws Exception {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IPath pjpath = project.getFullPath();
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        c.create(0, null);
        this.setOutputFolder(model, c);
        IVirtualFolder root = c.getRootFolder();
        IFolder sourceFolder = null;
        String configFolder = null;
        configFolder = model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        root.createLink((IPath)new Path("/" + configFolder), 0, null);
        String configFolderName = model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        IPath configFolderpath = pjpath.append(configFolderName);
        sourceFolder = ws.getRoot().getFolder(configFolderpath);
        if (!sourceFolder.getFile("META-INF/application-client.xml").exists()) {
            String ver = model.getStringProperty("IFacetDataModelProperties.FACET_VERSION_STR");
            int nVer = J2EEVersionUtil.convertVersionStringToInt(ver);
            AppClientArtifactEdit.createDeploymentDescriptor(project, nVer);
        }
        IClasspathEntry[] cp = jproj.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            IClasspathEntry cpe = cp[i];
            if (cpe.getEntryKind() == 3) {
                root.createLink(cpe.getPath().removeFirstSegments(1), 0, null);
            }
            ++i;
        }
        return c;
    }
}

