/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.viewer.HTMLGraphicalViewer;
import org.w3c.dom.Element;

public class DesignResizeComponentCommand
extends Command {
    private EditPart _part;
    private Object _constraint;
    private SourceViewer _viewer;

    public DesignResizeComponentCommand(EditPart child, Object constraint) {
        this._part = child;
        this._constraint = constraint;
        EditPart part = child;
        if (!(part instanceof ScalableRootEditPart)) {
            while (part != null && !(part.getParent() instanceof ScalableRootEditPart)) {
                part = part.getParent();
            }
        }
        if (part != null) {
            EditPartViewer viewer = ((ScalableRootEditPart)part.getParent()).getViewer();
            HTMLEditor editor = (HTMLEditor)((DefaultEditDomain)((HTMLGraphicalViewer)viewer).getEditDomain()).getEditorPart();
            this._viewer = editor.getTextEditor().getTextViewer();
        }
    }

    public void execute() {
        StringBuffer style;
        Element element = (Element)this._part.getModel();
        String width = element.getAttribute("width");
        String originalStyle = element.getAttribute("style");
        if (originalStyle != null) {
            originalStyle = this.removeOthers(originalStyle, "width");
            originalStyle = this.removeOthers(originalStyle, "height");
            style = new StringBuffer(originalStyle);
        } else {
            style = new StringBuffer(50);
        }
        if (width == null) {
            style.append(";").append("width").append(":").append(((Rectangle)this._constraint).width).append(";");
            style.append("height").append(":").append(((Rectangle)this._constraint).height).append("");
        }
        element.setAttribute("style", style.toString());
    }

    public void redo() {
        this._viewer.doOperation(2);
    }

    public String removeOthers(String style, String item) {
        String result = null;
        int pos = style.indexOf(item);
        if (pos < 0) {
            return style;
        }
        int pos1 = pos;
        if (pos > 0 && style.charAt(pos - 1) == ';') {
            --pos;
        }
        char ch = style.charAt(pos1);
        while (ch != ';' && ch != '\"' && ch != '\'') {
            if (++pos1 >= style.length()) break;
            ch = style.charAt(pos1);
        }
        result = pos1 < style.length() ? String.valueOf(style.substring(0, pos)) + style.substring(pos1 + 1, style.length()) : style.substring(0, pos);
        if (result.indexOf(item) >= 0) {
            return this.removeOthers(result, item);
        }
        return result;
    }

    public void undo() {
        this._viewer.doOperation(1);
    }
}

