/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetListAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class CSSTempUtil {
    public static List getStyleSheets(Element element) {
        StyleSheetList ssl;
        ArrayList<StyleSheet> styleSheets = new ArrayList<StyleSheet>();
        INodeNotifier docnotifier = (INodeNotifier)element.getOwnerDocument();
        IStyleSheetListAdapter adapter = (IStyleSheetListAdapter)docnotifier.getAdapterFor(IStyleSheetListAdapter.class);
        StyleSheetList styleSheetList = ssl = adapter == null ? null : adapter.getStyleSheets();
        if (ssl != null) {
            int i = 0;
            int numStyles = ssl.getLength();
            while (i < numStyles) {
                StyleSheet ss = ssl.item(i);
                styleSheets.add(ss);
                ++i;
            }
        }
        Node parent = element.getParentNode();
        Element rootEle = element;
        while (parent != null && parent instanceof Element) {
            rootEle = (Element)parent;
            parent = parent.getParentNode();
        }
        CSSTempUtil.addStyleSheet(rootEle, styleSheets);
        return styleSheets;
    }

    private static void addStyleSheet(Element node, List result) {
        IDOMElement element = (IDOMElement)node;
        String tagName = element.getTagName();
        if (tagName == null) {
            return;
        }
        boolean isContainer = false;
        if (element.isCommentTag()) {
            Node parent = element.getParentNode();
            if (parent == element.getOwnerDocument()) {
                isContainer = true;
            } else if (parent.getNodeType() == 1 && (tagName = ((Element)parent).getTagName()) != null && tagName.equalsIgnoreCase("HEAD")) {
                isContainer = true;
            }
        } else {
            StyleSheet sheet;
            IStyleSheetAdapter sheetAdapter;
            INodeAdapter adapter;
            IDOMElement notifier = element;
            if (("link".equalsIgnoreCase(tagName) || "style".equalsIgnoreCase(tagName)) && (adapter = notifier.getAdapterFor(IStyleSheetAdapter.class)) instanceof IStyleSheetAdapter && (sheetAdapter = (IStyleSheetAdapter)adapter).getElement() != null && "text/css".equals(sheetAdapter.getElement().getAttribute("type")) && (sheet = ((IStyleSheetAdapter)adapter).getSheet()) != null) {
                result.add(sheet);
            }
            isContainer = true;
        }
        if (isContainer) {
            Node child = element.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    CSSTempUtil.addStyleSheet((Element)child, result);
                }
                child = child.getNextSibling();
            }
        }
    }
}

