/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.PageDesignerResources;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteItemManager;
import org.eclipse.jst.pagedesigner.tools.RangeSelectionTool;

public class DesignerPaletteRoot
extends PaletteRoot {
    private IPaletteItemManager _manager;

    public DesignerPaletteRoot(IPaletteItemManager manager) {
        this._manager = manager;
        this.setupBasicItems();
        this.loadItems();
    }

    public IPaletteItemManager getPaletteManager() {
        return this._manager;
    }

    private void setupBasicItems() {
        PaletteGroup controls = new PaletteGroup(PageDesignerResources.getInstance().getString("JSFPalette.DefaultGroup.LabelJSFPallete"));
        this.add((PaletteEntry)controls);
        SelectionToolEntry tool = new SelectionToolEntry(){

            public Tool createTool() {
                return new RangeSelectionTool();
            }
        };
        controls.add((PaletteEntry)tool);
        this.setDefaultEntry((ToolEntry)tool);
        controls.add((PaletteEntry)new MarqueeToolEntry());
    }

    private void loadItems() {
        this.removeItems();
        List categories = this._manager.getAllCategories();
        this.addAll(categories);
    }

    protected void removeItems() {
        ArrayList children1 = new ArrayList(this.getChildren());
        children1.remove(0);
        int i = 0;
        int n = children1.size();
        while (i < n) {
            this.remove((PaletteEntry)children1.get(i));
            ++i;
        }
    }

    public void refresh() {
        this.loadItems();
    }
}

