/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.MetadataFactory;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.dom.JSFValidatorSupport;
import org.eclipse.jst.pagedesigner.dom.ValidatorSupport;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteElementTemplateHelper;
import org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.PaletteInfo;
import org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.PaletteInfos;
import org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.PaletteInfosFactory;
import org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.TagCreationAttribute;
import org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.TagCreationInfo;
import org.eclipse.jst.pagedesigner.itemcreation.ITagCreator;
import org.eclipse.jst.pagedesigner.utils.BodyHelper;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

public class DefaultTagCreator
implements ITagCreator {
    private static final QName _qnameHTMLForm = new QName("HTML", "form");
    protected TagToolPaletteEntry _tagItem;
    protected ITaglibDomainMetaDataModelContext _modelContext;
    private Entity _tagEntity;

    public DefaultTagCreator(ITaglibDomainMetaDataModelContext modelContext) {
        this._modelContext = modelContext;
    }

    public Element createTag(TagToolPaletteEntry tagToolPaletteEntry, IDOMModel model, IDOMPosition domPosition) {
        String defaultPrefix;
        this._tagItem = tagToolPaletteEntry;
        IDOMPosition position = this.preAdjustPositionForNecessaryContainers(model, domPosition);
        if (position == null) {
            return null;
        }
        String uri = this.getURI();
        String prefix = this.getPrefix(uri, model, defaultPrefix = this.getDefaultPrefix());
        Element ele = this.createElement(model, prefix);
        if (ele == null) {
            return null;
        }
        this.applyTemplate(model, ele);
        this.applyRequiredAttrs(ele);
        this.addTagToContainer(position, ele);
        return ele;
    }

    protected Element createElement(IDOMModel model, String prefix) {
        Element ele = model.getDocument().createElement(this._tagItem.getTagName());
        if (ele == null) {
            return null;
        }
        if ("jsp".equals(this.getURI()) && (ele.getLocalName().startsWith("directive.") || "declaration".equals(ele.getLocalName()) || "expression".equals(ele.getLocalName()) || "scriptlet".equals(ele.getLocalName()))) {
            ((IDOMElement)ele).setJSPTag(true);
        }
        if (prefix != null) {
            ele.setPrefix(prefix);
        }
        return ele;
    }

    protected void addTagToContainer(IDOMPosition position, Element tagElement) {
        if (position == null || position.getContainerNode() == null) {
            return;
        }
        if (position.getNextSiblingNode() == null) {
            position.getContainerNode().appendChild(tagElement);
        } else {
            position.getContainerNode().insertBefore(tagElement, position.getNextSiblingNode());
        }
    }

    protected IDOMPosition preAdjustPositionForNecessaryContainers(IDOMModel model, IDOMPosition domPosition) {
        IDOMPosition position = DOMPositionHelper.splitText(domPosition);
        position = BodyHelper.adjustInsertPosition(this.getURI(), this.getLocalTagName(), position);
        if ((position = this.createContainers(position)) == null) {
            return null;
        }
        return DOMPositionHelper.toDOMRefPosition(position);
    }

    protected IDOMPosition createContainers(IDOMPosition position) {
        if (this.isJSFComponent()) {
            return JSFValidatorSupport.prepareInsertJSFComponent(position, this.getURI(), this.getLocalTagName(), this.isHTMLFormRequired());
        }
        if (this.isHTMLFormRequired()) {
            boolean hasform = ValidatorSupport.checkContainer(position, _qnameHTMLForm);
            IDOMPosition newPosition = position;
            if (!hasform && (newPosition = ValidatorSupport.insertContainer(position, _qnameHTMLForm)) == null) {
                newPosition = position;
            }
            return newPosition;
        }
        return position;
    }

    private boolean isJSFComponent() {
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)this._modelContext);
        Trait t = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"is-jsf-component-library");
        if (t != null) {
            return TraitValueHelper.getValueAsBoolean((Trait)t);
        }
        return false;
    }

    private String getDefaultPrefix() {
        return this._tagItem.getDefaultPrefix();
    }

    private String getURI() {
        return this._tagItem.getURI();
    }

    private String getLocalTagName() {
        return this._tagItem.getTagName();
    }

    protected void applyRequiredAttrs(Element element) {
        EList list;
        TagCreationInfo info = this.getTagCreationInfo();
        if (info != null && (list = info.getAttributes()) != null) {
            for (TagCreationAttribute attr : list) {
                element.setAttribute(attr.getId(), attr.getValue() == null ? "" : attr.getValue());
            }
        }
    }

    protected void applyTemplate(IDOMModel model, Element tagElement) {
        TagCreationInfo tagCreationInfo = this.getTagCreationInfo();
        if (tagCreationInfo != null) {
            PaletteElementTemplateHelper.applyTemplate(model, tagElement, this.getTagToolItem(), tagCreationInfo);
        }
    }

    protected TagCreationInfo getTagCreationInfo() {
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)this._modelContext);
        if (model != null) {
            PaletteInfos pis;
            PaletteInfo pi;
            Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"paletteInfos");
            if (trait != null && (pi = (pis = (PaletteInfos)trait.getValue()).findPaletteInfoById(this._tagItem.getId())) != null) {
                return pi.getTagCreation();
            }
            Entity tag = this.getTagEntity();
            if (tag != null && (trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)tag, (String)"tag-create")) != null && trait.getValue() != null) {
                return (TagCreationInfo)trait.getValue();
            }
        }
        return null;
    }

    protected TagToolPaletteEntry getTagToolItem() {
        return this._tagItem;
    }

    protected String getPrefix(String uri, IDOMModel model, String suggested) {
        if ("html".equalsIgnoreCase(uri) || "jsp".equalsIgnoreCase(uri) || "JSP11".equalsIgnoreCase(uri)) {
            return null;
        }
        return JSPUtil.getOrCreatePrefix(model, uri, suggested);
    }

    protected Trait createRequiredAttrTraits(CMElementDeclaration tag) {
        ArrayList<CMAttributeDeclaration> reqs = new ArrayList<CMAttributeDeclaration>();
        for (CMAttributeDeclaration attr : tag.getAttributes()) {
            if (attr.getUsage() != 2) continue;
            reqs.add(attr);
        }
        if (reqs.size() > 0) {
            return this.internalCreateTagCreateAttributes(reqs);
        }
        return null;
    }

    private Trait internalCreateTagCreateAttributes(List reqs) {
        Trait t = MetadataFactory.eINSTANCE.createTrait();
        t.setId("create-trait");
        TagCreationInfo info = PaletteInfosFactory.eINSTANCE.createTagCreationInfo();
        Iterator it = reqs.iterator();
        while (it.hasNext()) {
            TagCreationAttribute attrInfo = PaletteInfosFactory.eINSTANCE.createTagCreationAttribute();
            CMAttributeDeclaration attr = (CMAttributeDeclaration)it.next();
            attrInfo.setId(attr.getAttrName());
            attrInfo.setValue("");
            info.getAttributes().add((Object)attrInfo);
        }
        t.setValue((EObject)info);
        return t;
    }

    protected boolean isHTMLFormRequired() {
        Trait t = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.getTagEntity(), (String)"requires-html-form");
        if (t != null) {
            return TraitValueHelper.getValueAsBoolean((Trait)t);
        }
        return false;
    }

    protected Entity getTagEntity() {
        if (this._tagEntity == null) {
            this._tagEntity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)this._modelContext, (String)this._tagItem.getTagName());
        }
        return this._tagEntity;
    }
}

