/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.single.ChangeAttributeCommand;
import org.eclipse.jst.pagedesigner.meta.IAttributeDescriptor;
import org.eclipse.jst.pagedesigner.meta.ICMRegistry;
import org.eclipse.jst.pagedesigner.meta.IElementDescriptor;
import org.eclipse.jst.pagedesigner.meta.internal.CMRegistry;
import org.eclipse.jst.pagedesigner.properties.AttributePropertyDescriptor;
import org.eclipse.jst.pagedesigner.properties.PropertyDescriptorWrapper;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;

public class AttributePropertySource
implements IPropertySource {
    private IDOMElement _element;
    private IPropertySource _innerSource;

    public AttributePropertySource(Element ele, IPropertySource source) {
        this._element = (IDOMElement)ele;
        this._innerSource = source;
    }

    public Object getEditableValue() {
        return this._innerSource.getEditableValue();
    }

    public Object getPropertyValue(Object id) {
        if (id == null) {
            return null;
        }
        String name = id.toString();
        String value = this._element.getAttribute(name);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        return this._innerSource.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        this._innerSource.resetPropertyValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        Object oldValue = this.getPropertyValue(id);
        if (oldValue == value || oldValue != null && oldValue.equals(value)) {
            return;
        }
        ChangeAttributeCommand c = new ChangeAttributeCommand(PDPlugin.getResourceString("AttributePropertySource.CommandLabel.ChangeAttribute"), this._element, (String)id, (String)value);
        c.execute();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IElementDescriptor elementDescriptor = this.getElementDescriptor();
        ArrayList<Object> result = new ArrayList<Object>();
        if (elementDescriptor == null) {
            IPropertyDescriptor[] original = this._innerSource.getPropertyDescriptors();
            int i = 0;
            while (i < original.length) {
                result.add(new PropertyDescriptorWrapper(this._element, original[i]));
                ++i;
            }
        } else {
            IAttributeDescriptor[] attrs;
            HashMap<Object, IPropertyDescriptor> map = new HashMap<Object, IPropertyDescriptor>();
            IPropertyDescriptor[] descs = this._innerSource.getPropertyDescriptors();
            if (descs != null) {
                int i = 0;
                while (i < descs.length) {
                    map.put(descs[i].getId(), descs[i]);
                    ++i;
                }
            }
            if ((attrs = elementDescriptor.getAttributeDescriptors()) != null) {
                int i = 0;
                while (i < attrs.length) {
                    IPropertyDescriptor desc = (IPropertyDescriptor)map.remove(attrs[i].getAttributeName());
                    result.add(new AttributePropertyDescriptor((Element)this._element, attrs[i], desc));
                    ++i;
                }
            }
            for (IPropertyDescriptor desc : map.values()) {
                IAttributeDescriptor attr = this.findReferencedAttribute(elementDescriptor, desc);
                if (attr != null) {
                    result.add(new AttributePropertyDescriptor((Element)this._element, attr, desc));
                    continue;
                }
                result.add(new PropertyDescriptorWrapper(this._element, desc));
            }
        }
        IPropertyDescriptor[] ret = new IPropertyDescriptor[result.size()];
        result.toArray(ret);
        return ret;
    }

    private IAttributeDescriptor findReferencedAttribute(IElementDescriptor elementDescriptor, IPropertyDescriptor desc) {
        return null;
    }

    private IElementDescriptor getElementDescriptor() {
        ICMRegistry registry = CMRegistry.getInstance();
        String uri = CMUtil.getElementNamespaceURI((Element)this._element);
        return registry.getElementDescriptor(uri, this._element.getLocalName());
    }
}

