/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.jsf.common.ui.internal.utils.StringUtil;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.properties.DesignerPropertyTool;
import org.eclipse.jst.pagedesigner.properties.ISectionFilter;
import org.eclipse.jst.pagedesigner.properties.attrgroup.AttributeGroup;
import org.eclipse.jst.pagedesigner.properties.attrgroup.AttributeGroupSection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISection;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISectionDescriptor;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITypeMapper;
import org.w3c.dom.Element;

public class DesignerSectionDescriptor
implements ISectionDescriptor {
    private static final String ATT_ID = "id";
    private static final String ATT_TARGET_TAB = "tab";
    private static final String ATT_AFTER_SECTION = "afterSection";
    private static final String ATT_CLASS = "class";
    private static final String ATT_FILTER = "filter";
    private static final String TOP = "top";
    private static final String TAGFILTER = "tagFilter";
    private static final String CASESENSITIVE = "caseSensitive";
    private static final String TAGNAME = "tagName";
    private static final String URI = "uri";
    private String _id;
    private String _targetTab;
    private String _afterSection;
    private ISectionFilter _sectionFilter;
    private IConfigurationElement _configurationElement;
    private TagFilter[] _tagFilters;

    public DesignerSectionDescriptor(IConfigurationElement configurationElement) {
        IConfigurationElement[] elements;
        String filterClass;
        this._configurationElement = configurationElement;
        this._id = this.getConfigurationElement().getAttribute(ATT_ID);
        this._targetTab = this.getConfigurationElement().getAttribute(ATT_TARGET_TAB);
        this._afterSection = this.getConfigurationElement().getAttribute(ATT_AFTER_SECTION);
        if (this._id == null || this._targetTab == null) {
            this.handleSectionError(null);
        }
        if (this.getAfterSection() == null) {
            this._afterSection = TOP;
        }
        if ((filterClass = this.getConfigurationElement().getAttribute(ATT_FILTER)) != null) {
            try {
                Object obj = this.getConfigurationElement().createExecutableExtension(ATT_FILTER);
                if (obj instanceof ISectionFilter) {
                    this._sectionFilter = (ISectionFilter)obj;
                }
            }
            catch (CoreException ex) {
                this.handleSectionError(ex);
            }
        }
        if ((elements = this.getConfigurationElement().getChildren(TAGFILTER)) != null && elements.length > 0) {
            this._tagFilters = new TagFilter[elements.length];
            int i = 0;
            while (i < this._tagFilters.length) {
                this._tagFilters[i] = new TagFilter();
                this._tagFilters[i].uri = elements[i].getAttribute(URI);
                this._tagFilters[i].tag = elements[i].getAttribute(TAGNAME);
                this._tagFilters[i].caseSensitive = Boolean.TRUE.toString().equalsIgnoreCase(elements[i].getAttribute(CASESENSITIVE));
                ++i;
            }
        }
    }

    private void handleSectionError(CoreException exception) {
        PDPlugin.getLogger(DesignerSectionDescriptor.class).error("error", (Throwable)exception);
        exception.printStackTrace();
    }

    public String getId() {
        return this._id;
    }

    public String getTargetTab() {
        return this._targetTab;
    }

    public boolean appliesTo(IWorkbenchPart part, ISelection selection) {
        Element node = DesignerPropertyTool.getElement(part, selection);
        if (node == null) {
            return false;
        }
        if (this._tagFilters != null) {
            String uri = CMUtil.getElementNamespaceURI((Element)node);
            String tag = node.getLocalName();
            int i = 0;
            while (i < this._tagFilters.length) {
                if (!this.match(uri, tag, this._tagFilters[i])) {
                    return false;
                }
                ++i;
            }
        }
        return this._sectionFilter == null || this._sectionFilter.appliesTo(node);
    }

    private boolean match(String uri, String tag, TagFilter filter) {
        if (!StringUtil.isSameString((String)uri, (String)filter.uri)) {
            return false;
        }
        if (uri != null && filter.uri != null && !uri.equals(filter.uri)) {
            return false;
        }
        if (filter.caseSensitive) {
            return tag.equals(filter.tag);
        }
        return tag.equalsIgnoreCase(filter.tag);
    }

    public String getAfterSection() {
        return this._afterSection;
    }

    public ISection getSectionClass() {
        Object section = null;
        try {
            Object secOrGroup = this.getConfigurationElement().createExecutableExtension(ATT_CLASS);
            if (secOrGroup instanceof ISection) {
                section = (ISection)secOrGroup;
            } else if (secOrGroup instanceof AttributeGroup) {
                section = new AttributeGroupSection((AttributeGroup)((Object)secOrGroup));
            }
        }
        catch (CoreException exception) {
            this.handleSectionError(exception);
        }
        return section;
    }

    public List getInputTypes() {
        return Collections.EMPTY_LIST;
    }

    public String toString() {
        return this.getId();
    }

    private IConfigurationElement getConfigurationElement() {
        return this._configurationElement;
    }

    public ITypeMapper getFilter() {
        return null;
    }

    public int getEnablesFor() {
        return 1;
    }

    private static class TagFilter {
        public String uri;
        public String tag;
        public boolean caseSensitive = false;

        private TagFilter() {
        }
    }
}

