/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tools;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Node;

public class ExposeHelper {
    private static final int DEFAULT_OFFSET = 100;
    private static final int SCROLL_OFFSET = 8;
    IHTMLGraphicalViewer _viewer;

    public ExposeHelper(IHTMLGraphicalViewer viewer) {
        this._viewer = viewer;
    }

    public void exposeArea(Rectangle rect) {
        if (this._viewer == null) {
            return;
        }
        FigureCanvas canvas = (FigureCanvas)this._viewer.getControl();
        Viewport port = this._viewer.getViewport();
        if (port == null) {
            return;
        }
        Rectangle exposeRegion = rect.getCopy();
        Rectangle portBounds = port.getBounds().getCopy();
        Point viewLocation = port.getViewLocation();
        Dimension diff = this.calculateDiff(portBounds, exposeRegion);
        if (diff != null) {
            viewLocation.x -= diff.width;
            viewLocation.y -= diff.height;
            canvas.scrollSmoothTo(viewLocation.x, viewLocation.y);
        }
    }

    private void exposeVertical(int offset) {
        if (this._viewer == null) {
            return;
        }
        FigureCanvas canvas = (FigureCanvas)this._viewer.getControl();
        Viewport port = this._viewer.getViewport();
        if (port == null) {
            return;
        }
        Point viewLocation = port.getViewLocation();
        viewLocation.y += offset;
        canvas.scrollSmoothTo(viewLocation.x, viewLocation.y);
    }

    private void exposeHorizontal(int offset) {
        if (this._viewer == null) {
            return;
        }
        FigureCanvas canvas = (FigureCanvas)this._viewer.getControl();
        Viewport port = this._viewer.getViewport();
        if (port == null) {
            return;
        }
        Point viewLocation = port.getViewLocation();
        viewLocation.x += offset;
        canvas.scrollSmoothTo(viewLocation.x, viewLocation.y);
    }

    private int calculateX(Rectangle portBounds, Rectangle caretRect) {
        int result = 0;
        if (portBounds.x > caretRect.getRight().x) {
            result = portBounds.getLeft().getDifference((Point)caretRect.getRight()).width;
            if (portBounds.width >= caretRect.width) {
                result = portBounds.getLeft().getDifference((Point)caretRect.getLeft()).width;
            }
        } else if (portBounds.getRight().x < caretRect.getLeft().x) {
            result = portBounds.getRight().getDifference((Point)caretRect.getLeft()).width;
            if (portBounds.width >= caretRect.width) {
                result = portBounds.getRight().getDifference((Point)caretRect.getRight()).width;
            }
        }
        return result;
    }

    private int calculateY(Rectangle portBounds, Rectangle caretRect) {
        int result = 0;
        if (portBounds.y > caretRect.getBottom().y) {
            result = portBounds.getTop().getDifference((Point)caretRect.getBottom()).height;
            if (portBounds.height >= caretRect.height) {
                result = portBounds.getTop().getDifference((Point)caretRect.getTop()).height;
            }
        } else if (portBounds.getBottom().y < caretRect.getTop().y) {
            result = portBounds.getBottom().getDifference((Point)caretRect.getTop()).height;
            if (portBounds.height >= caretRect.height) {
                result = portBounds.getBottom().getDifference((Point)caretRect.getBottom()).height;
            }
        } else if (portBounds.getBottom().y < caretRect.getBottom().y) {
            if (portBounds.height >= caretRect.height) {
                result = portBounds.getBottom().getDifference((Point)caretRect.getBottom()).height;
            }
        } else if (portBounds.getTop().y > caretRect.getTop().y && portBounds.height >= caretRect.height) {
            result = portBounds.getTop().getDifference((Point)caretRect.getTop()).height;
        }
        return result;
    }

    private Dimension calculateDiff(Rectangle portBounds, Rectangle caretRect) {
        Dimension diff = new Dimension(0, 0);
        diff.width = this.calculateX(portBounds, caretRect);
        diff.height = this.calculateY(portBounds, caretRect);
        return diff;
    }

    private static void expose(EditPart part, ScrollingGraphicalViewer viewer) {
        if (part != null && part.getModel() instanceof Node) {
            viewer.reveal(part);
        }
    }

    private static void expose(Node element, ScrollingGraphicalViewer viewer) {
        if (element instanceof INodeNotifier) {
            EditPart editPart = (EditPart)((INodeNotifier)element).getAdapterFor(EditPart.class);
            ExposeHelper.expose(editPart, viewer);
        }
    }

    public static void expose(ISelection selection, ScrollingGraphicalViewer viewer) {
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof Node) {
                ExposeHelper.expose((Node)element, viewer);
            } else if (element instanceof EditPart) {
                ExposeHelper.expose((EditPart)element, viewer);
            }
        }
    }

    public void adjustVertical(Point p) {
        int offset = 0;
        offset = this.getVerticalBoundsOffset(p, false);
        if (offset < 8) {
            this.exposeVertical(8 - offset);
        } else {
            offset = this.getVerticalBoundsOffset(p, true);
            if (offset < 8) {
                this.exposeVertical(offset - 8);
            }
        }
        offset = this.getHorizontalBoundsOffset(p, true);
        if (offset < 8) {
            this.exposeHorizontal(8 - offset);
        } else {
            offset = this.getHorizontalBoundsOffset(p, false);
            if (offset < 8) {
                this.exposeHorizontal(offset - 8);
            }
        }
    }

    public Point getViewpostLocation() {
        Viewport port;
        if (this._viewer != null && (port = this._viewer.getViewport()) != null) {
            return port.getViewLocation();
        }
        return null;
    }

    public Point translateToViewport(IFigure figure, Point p) {
        Point vp = this.getViewpostLocation();
        return new Point(p.x - vp.x, p.y - vp.y);
    }

    private int getHorizontalBoundsOffset(Point p, boolean forward) {
        if (this._viewer == null) {
            return 100;
        }
        Viewport port = this._viewer.getViewport();
        if (port == null) {
            return 100;
        }
        if (forward) {
            Rectangle portBounds = port.getBounds().getCopy();
            return portBounds.getRight().x - p.x;
        }
        return p.x;
    }

    private int getVerticalBoundsOffset(Point p, boolean up) {
        if (this._viewer == null) {
            return 100;
        }
        Viewport port = this._viewer.getViewport();
        if (port == null) {
            return 100;
        }
        if (!up) {
            Rectangle portBounds = port.getBounds().getCopy();
            return portBounds.getBottom().y - p.y;
        }
        return p.y;
    }

    public void exposeBorder(Rectangle rect, AbstractEditPolicy policy) {
        Point p = rect.getTopLeft();
        p = this.translateToViewport(((GraphicalEditPart)policy.getHost()).getFigure(), p);
        this.adjustVertical(p);
        p = rect.getBottomRight();
        p = this.translateToViewport(((GraphicalEditPart)policy.getHost()).getFigure(), p);
        this.adjustVertical(p);
    }
}

