/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.viewer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.viewer.CaretPositionResolver;
import org.eclipse.jst.pagedesigner.viewer.LayoutPart;

public class FlowBoxLine {
    private int _x;
    private int _y;
    private int _height;
    private int _width;
    private HashMap _parts = new HashMap();
    private IPositionMediator _validator;
    private Point _point;

    public FlowBoxLine(Rectangle rect, IPositionMediator validator, Point point) {
        this._x = rect.x;
        this._y = rect.y;
        this._width = rect.width;
        this._height = rect.height;
        this._validator = validator;
        this._point = point;
    }

    public int getHeight() {
        return this._height;
    }

    public int getWidth() {
        return this._width;
    }

    public int getX() {
        return this._x;
    }

    public int getY() {
        return this._y;
    }

    public HashMap getPartsList() {
        return this._parts;
    }

    public Point getRightBottom() {
        return new Point(this._x + this._width, this._y + this._height);
    }

    public boolean addLayoutPart(EditPart part, Point point) {
        Assert.isTrue((part != null && point != null ? 1 : 0) != 0);
        Rectangle rect = null;
        LayoutPart lPart = new LayoutPart(part, point);
        if (this._parts.size() == 0) {
            this.resetBounds(lPart);
            return true;
        }
        if (!this.interact(lPart)) {
            if (this.closer(lPart)) {
                this.resetBounds(lPart);
                return true;
            }
            return false;
        }
        rect = lPart.getAbsoluteBounds();
        int xx = Math.min(rect.x, this._x);
        int width = Math.max(rect.getRight().x, this.getRightBottom().x) - xx;
        int yy = Math.min(rect.y, this._y);
        int height = Math.max(rect.getBottom().y, this.getRightBottom().y) - yy;
        this._x = xx;
        this._y = yy;
        this._width = width;
        this._height = height;
        this._parts.put(part, lPart);
        return true;
    }

    public boolean interact(LayoutPart lPart) {
        Rectangle rect = lPart.getAbsoluteBounds();
        return rect.getBottom().y > this._y && this.getRightBottom().y > rect.y;
    }

    public boolean contains(EditPart part) {
        return this._parts.containsKey(part);
    }

    public boolean contains(LayoutPart part) {
        return this._parts.containsValue(part);
    }

    public LayoutPart getLayoutPart(EditPart part) {
        return (LayoutPart)this._parts.get(part);
    }

    public EditPart getClosestPart() {
        if (this._parts.isEmpty()) {
            return null;
        }
        Collection parts = this._parts.values();
        Iterator iterator = parts.iterator();
        LayoutPart closestPart = (LayoutPart)iterator.next();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                LayoutPart nextPart = (LayoutPart)iterator.next();
                closestPart = CaretPositionResolver.getCloserPart(closestPart, nextPart, this._point);
            }
        }
        LayoutPart result = null;
        result = this._validator.getActionData().getActionType() == 4 || closestPart.isInline() ? CaretPositionResolver.getInstance(this._validator, this._point).resolveClosestPartFrom(closestPart) : closestPart;
        if (result != null) {
            return result.getPart();
        }
        return null;
    }

    private boolean closer(LayoutPart lPart) {
        int partYOffset;
        int lineYOffset = Math.abs(CaretPositionResolver.getYDistance(this.getBounds(), this._point));
        return lineYOffset > (partYOffset = Math.abs(CaretPositionResolver.getYDistance(lPart.getAbsoluteBounds(), this._point)));
    }

    public Rectangle getBounds() {
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    private void resetBounds(Rectangle rect) {
        this._x = rect.x;
        this._y = rect.y;
        this._width = rect.width;
        this._height = rect.height;
    }

    private void resetBounds(LayoutPart lPart) {
        EditPart part = lPart.getPart();
        Rectangle rect = lPart.getAbsoluteBounds();
        this.resetBounds(rect);
        this._parts.clear();
        this._parts.put(part, lPart);
    }
}

