/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.consumption.core.command;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.consumption.core.data.DataModel;
import org.eclipse.jst.ws.axis2.consumption.core.messages.Axis2ConsumptionUIMessages;
import org.eclipse.jst.ws.axis2.consumption.core.utils.ContentCopyUtils;
import org.eclipse.jst.ws.axis2.consumption.core.utils.WSDL2JavaGenerator;
import org.eclipse.jst.ws.axis2.consumption.core.utils.WSDLPropertyReader;
import org.eclipse.jst.ws.axis2.core.utils.ClassLoadingUtil;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class Axis2ClientCodegenCommand
extends AbstractDataModelOperation {
    private DataModel model;

    public Axis2ClientCodegenCommand(DataModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        IEnvironment environment = this.getEnvironment();
        IStatusHandler statusHandler = environment.getStatusHandler();
        String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String currentDynamicWebProjectDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)this.model.getWebProjectName());
        String matadataDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)".metadata");
        String matadataPluginsDir = FileUtils.addAnotherNodeToPath((String)matadataDir, (String)".plugins");
        String matadataAxis2Dir = FileUtils.addAnotherNodeToPath((String)matadataPluginsDir, (String)"org.eclipse.jst.ws.axis2");
        String tempCodegenOutputLocation = FileUtils.addAnotherNodeToPath((String)matadataAxis2Dir, (String)"codegen");
        File tempCodegenOutputLocationFile = new File(tempCodegenOutputLocation);
        if (tempCodegenOutputLocationFile.exists()) {
            FileUtils.deleteDirectories((String)tempCodegenOutputLocation);
        }
        FileUtils.createDirectorys((String)tempCodegenOutputLocation);
        WSDL2JavaGenerator generator = new WSDL2JavaGenerator();
        try {
            ClassLoadingUtil.setInitByClient((boolean)true);
            ClassLoadingUtil.cleanAntClassLoader();
            ClassLoadingUtil.init((String)this.model.getWebProjectName());
            Object axisServiceInstance = generator.getAxisService(this.model.getWsdlURI());
            Map optionsMap = generator.fillOptionMap(this.model.isASync(), this.model.isSync(), false, false, this.model.isTestCaseCheck(), this.model.isGenerateAllCheck(), this.model.getServiceName() != null ? this.model.getServiceName() : null, this.model.getPortName() != null ? this.model.getPortName() : null, this.model.getDatabindingType().toLowerCase() != null ? this.model.getDatabindingType().toLowerCase() : null, this.model.getWsdlURI() != null ? this.model.getWsdlURI() : null, this.model.getPackageText() != null ? this.model.getPackageText() : null, "java", tempCodegenOutputLocation, this.model.getNamespaseToPackageMapping(), false);
            Class CodeGenConfigurationClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"org.apache.axis2.wsdl.codegen.CodeGenConfiguration");
            Constructor CodeGenConfigurationConstructor = CodeGenConfigurationClass.getConstructor(Map.class);
            Object CodeGenConfigurationInstance = CodeGenConfigurationConstructor.newInstance(optionsMap);
            Method addAxisServiceMethod = CodeGenConfigurationClass.getMethod("addAxisService", axisServiceInstance.getClass());
            addAxisServiceMethod.invoke(CodeGenConfigurationInstance, axisServiceInstance);
            WSDLPropertyReader reader = new WSDLPropertyReader();
            reader.readWSDL(this.model.getWebProjectName(), this.model.getWsdlURI());
            Object wsdlDefinitionInstance = reader.getWsdlDefinitionInstance();
            Method setWsdlDefinitionMethod = CodeGenConfigurationClass.getMethod("setWsdlDefinition", reader.getWsdlDefinitionClass());
            setWsdlDefinitionMethod.invoke(CodeGenConfigurationInstance, wsdlDefinitionInstance);
            Method setBaseURIMethod = CodeGenConfigurationClass.getMethod("setBaseURI", String.class);
            setBaseURIMethod.invoke(CodeGenConfigurationInstance, generator.getBaseUri(this.model.getWsdlURI()));
            Class AxisServiceClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"org.apache.axis2.description.AxisService");
            Method getTargetNamespaceMethod = AxisServiceClass.getMethod("getTargetNamespace", null);
            Object targetNamespace = getTargetNamespaceMethod.invoke(axisServiceInstance, null);
            Class URLProcessorClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"org.apache.axis2.util.URLProcessor");
            Method makePackageNameMethod = URLProcessorClass.getMethod("makePackageName", String.class);
            Object stringReturn = makePackageNameMethod.invoke(null, targetNamespace);
            this.model.setPackageText(stringReturn.toString());
            Method setPackageNameMethod = CodeGenConfigurationClass.getMethod("setPackageName", String.class);
            setPackageNameMethod.invoke(CodeGenConfigurationInstance, stringReturn);
            Class CodeGenerationEngineClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"org.apache.axis2.wsdl.codegen.CodeGenerationEngine");
            Constructor CodeGenerationEngineConstructor = CodeGenerationEngineClass.getConstructor(CodeGenConfigurationInstance.getClass());
            Object CodeGenerationEngineInstance = CodeGenerationEngineConstructor.newInstance(CodeGenConfigurationInstance);
            Method generateMethod = CodeGenerationEngineClass.getMethod("generate", null);
            generateMethod.invoke(CodeGenerationEngineInstance, null);
            ContentCopyUtils contentCopyUtils = new ContentCopyUtils();
            status = contentCopyUtils.copyDirectoryRecursivelyIntoWorkspace(tempCodegenOutputLocation, currentDynamicWebProjectDir, monitor, statusHandler);
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)Axis2ConsumptionUIMessages.ERROR_CODEGEN_EXCEPTION, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }
}

